/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import moze_intel.projecte.capability.ModeChangerItemCapabilityWrapper;
import moze_intel.projecte.gameObjs.ObjHandler;
import moze_intel.projecte.gameObjs.items.IItemMode;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.NonNullLazy;

public class DiviningRod
extends ItemPE
implements IItemMode {
    private final String[] modes;

    public DiviningRod(Item.Properties props, String[] modeDesc) {
        super(props);
        this.modes = modeDesc;
        this.addItemCapability(ModeChangerItemCapabilityWrapper::new);
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext ctx) {
        World world = ctx.func_195991_k();
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        PlayerEntity player = ctx.func_195999_j();
        LongArrayList emcValues = new LongArrayList();
        long totalEmc = 0L;
        int numBlocks = 0;
        int depth = this.getDepthFromMode(ctx.func_195996_i());
        NonNullLazy furnaceRecipes = NonNullLazy.of(() -> world.func_199532_z().func_215366_a(IRecipeType.field_222150_b).values());
        for (BlockPos digPos : WorldHelper.getPositionsFromBox(WorldHelper.getDeepBox(ctx.func_195995_a(), ctx.func_196000_l(), depth))) {
            BlockState state;
            List drops;
            if (world.func_175623_d(digPos) || (drops = Block.func_220077_a((BlockState)(state = world.func_180495_p(digPos)), (ServerWorld)((ServerWorld)world), (BlockPos)digPos, (TileEntity)world.func_175625_s(digPos), (Entity)player, (ItemStack)ctx.func_195996_i())).isEmpty()) continue;
            ItemStack blockStack = (ItemStack)drops.get(0);
            long blockEmc = EMCHelper.getEmcValue(blockStack);
            if (blockEmc == 0L) {
                for (IRecipe furnaceRecipe : (Collection)furnaceRecipes.get()) {
                    long currentValue;
                    if (!((Ingredient)furnaceRecipe.func_192400_c().get(0)).test(blockStack) || (currentValue = EMCHelper.getEmcValue(furnaceRecipe.func_77571_b())) == 0L) continue;
                    if (!emcValues.contains(currentValue)) {
                        emcValues.add(currentValue);
                    }
                    totalEmc += currentValue;
                    break;
                }
            } else {
                if (!emcValues.contains(blockEmc)) {
                    emcValues.add(blockEmc);
                }
                totalEmc += blockEmc;
            }
            ++numBlocks;
        }
        if (numBlocks == 0) {
            return ActionResultType.FAIL;
        }
        player.func_145747_a((ITextComponent)new TranslationTextComponent("pe.divining.avgemc", new Object[]{numBlocks, totalEmc / (long)numBlocks}));
        if (this == ObjHandler.dRod2 || this == ObjHandler.dRod3) {
            long[] maxValues = new long[3];
            for (int i = 0; i < 3; ++i) {
                maxValues[i] = 1L;
            }
            emcValues.sort(Comparator.reverseOrder());
            int num = Math.min(emcValues.size(), 3);
            for (int i = 0; i < num; ++i) {
                maxValues[i] = emcValues.getLong(i);
            }
            player.func_145747_a((ITextComponent)new TranslationTextComponent("pe.divining.maxemc", new Object[]{maxValues[0]}));
            if (this == ObjHandler.dRod3) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("pe.divining.secondmax", new Object[]{maxValues[1]}));
                player.func_145747_a((ITextComponent)new TranslationTextComponent("pe.divining.thirdmax", new Object[]{maxValues[2]}));
            }
        }
        return ActionResultType.SUCCESS;
    }

    private int getDepthFromMode(ItemStack stack) {
        return Integer.parseInt(this.getModeTranslationKey(stack).substring(25));
    }

    @Override
    public String[] getModeTranslationKeys() {
        return this.modes;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> list, ITooltipFlag flags) {
        list.add(this.getToolTip(stack));
    }
}

