/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import moze_intel.projecte.capability.ItemCapability;
import moze_intel.projecte.capability.ItemCapabilityWrapper;
import moze_intel.projecte.utils.EMCHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.ModList;

public class ItemPE
extends Item {
    protected static final ResourceLocation ACTIVE_NAME = new ResourceLocation("projecte", "active");
    protected static final IItemPropertyGetter ACTIVE_GETTER = (stack, world, entity) -> stack.func_77942_o() && stack.func_77978_p().func_74767_n("Active") ? 1.0f : 0.0f;
    protected static final IItemPropertyGetter MODE_GETTER = (stack, world, entity) -> stack.func_77942_o() ? (float)stack.func_77978_p().func_74762_e("Mode") : 0.0f;
    private final List<Supplier<ItemCapability<?>>> supportedCapabilities = new ArrayList();

    public ItemPE(Item.Properties props) {
        super(props);
    }

    protected void addItemCapability(Supplier<ItemCapability<?>> capabilitySupplier) {
        this.supportedCapabilities.add(capabilitySupplier);
    }

    protected void addItemCapability(String modid, Supplier<Supplier<ItemCapability<?>>> capabilitySupplier) {
        if (ModList.get().isLoaded(modid)) {
            this.supportedCapabilities.add(capabilitySupplier.get());
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (oldStack.func_77973_b() != newStack.func_77973_b()) {
            return true;
        }
        if (oldStack.func_77942_o() && newStack.func_77942_o()) {
            CompoundNBT newTag = newStack.func_77978_p();
            CompoundNBT oldTag = oldStack.func_77978_p();
            boolean diffActive = oldTag.func_74764_b("Active") && newTag.func_74764_b("Active") && !oldTag.func_74781_a("Active").equals(newTag.func_74781_a("Active"));
            boolean diffMode = oldTag.func_74764_b("Mode") && newTag.func_74764_b("Mode") && !oldTag.func_74781_a("Mode").equals(newTag.func_74781_a("Mode"));
            return diffActive || diffMode;
        }
        return false;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        if (this.supportedCapabilities.isEmpty()) {
            return super.initCapabilities(stack, nbt);
        }
        return new ItemCapabilityWrapper(stack, this.supportedCapabilities);
    }

    public static long getEmc(ItemStack stack) {
        return stack.func_77942_o() ? stack.func_77978_p().func_74763_f("StoredEMC") : 0L;
    }

    public static void setEmc(ItemStack stack, long amount) {
        stack.func_196082_o().func_74772_a("StoredEMC", amount);
    }

    public static void addEmcToStack(ItemStack stack, long amount) {
        ItemPE.setEmc(stack, ItemPE.getEmc(stack) + amount);
    }

    public static void removeEmc(ItemStack stack, long amount) {
        long result = ItemPE.getEmc(stack) - amount;
        if (result < 0L) {
            result = 0L;
        }
        ItemPE.setEmc(stack, result);
    }

    public static boolean consumeFuel(PlayerEntity player, ItemStack stack, long amount, boolean shouldRemove) {
        if (amount <= 0L) {
            return true;
        }
        long current = ItemPE.getEmc(stack);
        if (current < amount) {
            long consume = EMCHelper.consumePlayerFuel(player, amount - current);
            if (consume == -1L) {
                return false;
            }
            ItemPE.addEmcToStack(stack, consume);
        }
        if (shouldRemove) {
            ItemPE.removeEmc(stack, amount);
        }
        return true;
    }
}

