/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.PESounds;
import moze_intel.projecte.api.capabilities.item.IExtraFunction;
import moze_intel.projecte.api.capabilities.item.IProjectileShooter;
import moze_intel.projecte.capability.ExtraFunctionItemCapabilityWrapper;
import moze_intel.projecte.capability.ProjectileShooterItemCapabilityWrapper;
import moze_intel.projecte.gameObjs.container.PhilosStoneContainer;
import moze_intel.projecte.gameObjs.entity.EntityMobRandomizer;
import moze_intel.projecte.gameObjs.items.ItemMode;
import moze_intel.projecte.utils.ClientKeyHelper;
import moze_intel.projecte.utils.PEKeybind;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.WorldTransmutations;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class PhilosophersStone
extends ItemMode
implements IProjectileShooter,
IExtraFunction {
    public PhilosophersStone(Item.Properties props) {
        super(props, 4, new String[]{"pe.philstone.mode1", "pe.philstone.mode2", "pe.philstone.mode3"});
        this.addItemCapability(ExtraFunctionItemCapabilityWrapper::new);
        this.addItemCapability(ProjectileShooterItemCapabilityWrapper::new);
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        return stack.func_77946_l();
    }

    public RayTraceResult getHitBlock(PlayerEntity player) {
        return PhilosophersStone.func_219968_a((World)player.func_130014_f_(), (PlayerEntity)player, (RayTraceContext.FluidMode)(player.func_225608_bj_() ? RayTraceContext.FluidMode.SOURCE_ONLY : RayTraceContext.FluidMode.NONE));
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext ctx) {
        BlockState result;
        BlockPos pos = ctx.func_195995_a();
        Direction sideHit = ctx.func_196000_l();
        World world = ctx.func_195991_k();
        PlayerEntity player = ctx.func_195999_j();
        ItemStack stack = ctx.func_195996_i();
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        RayTraceResult rtr = this.getHitBlock(player);
        if (rtr instanceof BlockRayTraceResult && !((BlockRayTraceResult)rtr).func_216350_a().equals((Object)pos)) {
            pos = ((BlockRayTraceResult)rtr).func_216350_a();
            sideHit = ((BlockRayTraceResult)rtr).func_216354_b();
        }
        if ((result = WorldTransmutations.getWorldTransmutation((IBlockReader)world, pos, player.func_225608_bj_())) != null) {
            byte mode = this.getMode(stack);
            int charge = this.getCharge(stack);
            for (BlockPos currentPos : PhilosophersStone.getAffectedPositions(world, pos, player, sideHit, mode, charge)) {
                PlayerHelper.checkedReplaceBlock((ServerPlayerEntity)player, currentPos, result);
                if (world.field_73012_v.nextInt(8) != 0) continue;
                ((ServerWorld)world).func_195598_a((IParticleData)ParticleTypes.field_197594_E, (double)currentPos.func_177958_n(), (double)(currentPos.func_177956_o() + 1), (double)currentPos.func_177952_p(), 2, 0.0, 0.0, 0.0, 0.0);
            }
            world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), PESounds.TRANSMUTE, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    public boolean shootProjectile(@Nonnull PlayerEntity player, @Nonnull ItemStack stack, Hand hand) {
        World world = player.func_130014_f_();
        world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), PESounds.TRANSMUTE, SoundCategory.PLAYERS, 1.0f, 1.0f);
        EntityMobRandomizer ent = new EntityMobRandomizer(player, world);
        ent.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 1.5f, 1.0f);
        world.func_217376_c((Entity)ent);
        return true;
    }

    @Override
    public boolean doExtraFunction(@Nonnull ItemStack stack, @Nonnull PlayerEntity player, Hand hand) {
        if (!player.func_130014_f_().field_72995_K) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new ContainerProvider(stack));
        }
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> list, ITooltipFlag flags) {
        super.func_77624_a(stack, world, list, flags);
        list.add((ITextComponent)new TranslationTextComponent("pe.philstone.tooltip1", new Object[]{ClientKeyHelper.getKeyName(PEKeybind.EXTRA_FUNCTION)}));
    }

    public static Set<BlockPos> getAffectedPositions(World world, BlockPos pos, PlayerEntity player, Direction sideHit, int mode, int charge) {
        BlockState targeted = world.func_180495_p(pos);
        Stream stream = null;
        switch (mode) {
            case 0: {
                stream = BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-charge, -charge, -charge), (BlockPos)pos.func_177982_a(charge, charge, charge));
                break;
            }
            case 1: {
                if (sideHit == Direction.UP || sideHit == Direction.DOWN) {
                    stream = BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-charge, 0, -charge), (BlockPos)pos.func_177982_a(charge, 0, charge));
                    break;
                }
                if (sideHit == Direction.EAST || sideHit == Direction.WEST) {
                    stream = BlockPos.func_218281_b((BlockPos)pos.func_177982_a(0, -charge, -charge), (BlockPos)pos.func_177982_a(0, charge, charge));
                    break;
                }
                if (sideHit != Direction.SOUTH && sideHit != Direction.NORTH) break;
                stream = BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-charge, -charge, 0), (BlockPos)pos.func_177982_a(charge, charge, 0));
                break;
            }
            case 2: {
                Direction playerFacing = player.func_174811_aO();
                if (playerFacing.func_176740_k() == Direction.Axis.Z) {
                    stream = BlockPos.func_218281_b((BlockPos)pos.func_177982_a(0, 0, -charge), (BlockPos)pos.func_177982_a(0, 0, charge));
                    break;
                }
                if (playerFacing.func_176740_k() != Direction.Axis.X) break;
                stream = BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-charge, 0, 0), (BlockPos)pos.func_177982_a(charge, 0, 0));
            }
        }
        if (stream == null) {
            return Collections.emptySet();
        }
        return stream.filter(currentPos -> world.func_180495_p(currentPos) == targeted).map(BlockPos::func_185334_h).collect(Collectors.toSet());
    }

    private static class ContainerProvider
    implements INamedContainerProvider {
        private final ItemStack stack;

        private ContainerProvider(ItemStack stack) {
            this.stack = stack;
        }

        @Nonnull
        public Container createMenu(int windowId, @Nonnull PlayerInventory playerInventory, @Nonnull PlayerEntity playerIn) {
            return new PhilosStoneContainer(windowId, playerInventory, IWorldPosCallable.func_221488_a((World)playerIn.func_130014_f_(), (BlockPos)playerIn.func_180425_c()));
        }

        @Nonnull
        public ITextComponent func_145748_c_() {
            return this.stack.func_200301_q();
        }
    }
}

