/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.armor;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import moze_intel.projecte.gameObjs.items.IFlightProvider;
import moze_intel.projecte.gameObjs.items.IStepAssister;
import moze_intel.projecte.gameObjs.items.armor.GemArmorBase;
import moze_intel.projecte.utils.ClientKeyHelper;
import moze_intel.projecte.utils.PEKeybind;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;

public class GemFeet
extends GemArmorBase
implements IFlightProvider,
IStepAssister {
    private static final UUID MODIFIER = UUID.randomUUID();

    public GemFeet(Item.Properties props) {
        super(EquipmentSlotType.FEET, props);
    }

    public static boolean isStepAssistEnabled(ItemStack stack) {
        return stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("StepAssist") && stack.func_77978_p().func_74767_n("StepAssist");
    }

    public void toggleStepAssist(ItemStack boots, PlayerEntity player) {
        boolean value;
        CompoundNBT bootsTag = boots.func_196082_o();
        if (bootsTag.func_74764_b("StepAssist")) {
            bootsTag.func_74757_a("StepAssist", !bootsTag.func_74767_n("StepAssist"));
            value = bootsTag.func_74767_n("StepAssist");
        } else {
            bootsTag.func_74757_a("StepAssist", true);
            value = true;
        }
        player.func_145747_a(new TranslationTextComponent("pe.gem.stepassist_tooltip", new Object[0]).func_150258_a(" ").func_150257_a(new TranslationTextComponent(value ? "pe.gem.enabled" : "pe.gem.disabled", new Object[0]).func_211708_a(value ? TextFormatting.GREEN : TextFormatting.RED)));
    }

    private static boolean isJumpPressed() {
        return (Boolean)DistExecutor.runForDist(() -> () -> Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d(), () -> () -> false);
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        if (!world.field_72995_K) {
            ServerPlayerEntity playerMP = (ServerPlayerEntity)player;
            playerMP.field_70143_R = 0.0f;
        } else {
            if (!player.field_71075_bZ.field_75100_b && GemFeet.isJumpPressed()) {
                player.func_213317_d(player.func_213322_ci().func_72441_c(0.0, 0.1, 0.0));
            }
            if (!player.field_70122_E) {
                if (player.func_213322_ci().func_82617_b() <= 0.0) {
                    player.func_213317_d(player.func_213322_ci().func_216372_d(1.0, 0.9, 1.0));
                }
                if (!player.field_71075_bZ.field_75100_b) {
                    if (player.field_191988_bg < 0.0f) {
                        player.func_213317_d(player.func_213322_ci().func_216372_d(0.9, 1.0, 0.9));
                    } else if (player.field_191988_bg > 0.0f && player.func_213322_ci().func_189985_c() < 3.0) {
                        player.func_213317_d(player.func_213322_ci().func_216372_d(1.1, 1.0, 1.1));
                    }
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltips, ITooltipFlag flags) {
        tooltips.add((ITextComponent)new TranslationTextComponent("pe.gem.feet.lorename", new Object[0]));
        tooltips.add((ITextComponent)new TranslationTextComponent("pe.gem.stepassist.prompt", new Object[]{ClientKeyHelper.getKeyName(PEKeybind.ARMOR_TOGGLE)}));
        boolean enabled = GemFeet.isStepAssistEnabled(stack);
        tooltips.add(new TranslationTextComponent("pe.gem.stepassist_tooltip", new Object[0]).func_150258_a(" ").func_150257_a(new TranslationTextComponent(enabled ? "pe.gem.enabled" : "pe.gem.disabled", new Object[0]).func_211708_a(enabled ? TextFormatting.GREEN : TextFormatting.RED)));
    }

    @Nonnull
    public Multimap<String, AttributeModifier> getAttributeModifiers(@Nonnull EquipmentSlotType slot, ItemStack stack) {
        if (slot != EquipmentSlotType.FEET) {
            return super.getAttributeModifiers(slot, stack);
        }
        Multimap attributes = super.getAttributeModifiers(slot, stack);
        attributes.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(MODIFIER, "Armor modifier", 1.0, AttributeModifier.Operation.MULTIPLY_TOTAL).func_111168_a(false));
        return attributes;
    }

    @Override
    public boolean canProvideFlight(ItemStack stack, ServerPlayerEntity player) {
        return player.func_184582_a(EquipmentSlotType.FEET) == stack;
    }

    @Override
    public boolean canAssistStep(ItemStack stack, ServerPlayerEntity player) {
        return player.func_184582_a(EquipmentSlotType.FEET) == stack && GemFeet.isStepAssistEnabled(stack);
    }
}

