/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.rings;

import java.util.List;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.PESounds;
import moze_intel.projecte.api.capabilities.item.IExtraFunction;
import moze_intel.projecte.api.capabilities.item.IProjectileShooter;
import moze_intel.projecte.capability.ExtraFunctionItemCapabilityWrapper;
import moze_intel.projecte.capability.ModeChangerItemCapabilityWrapper;
import moze_intel.projecte.capability.ProjectileShooterItemCapabilityWrapper;
import moze_intel.projecte.gameObjs.entity.EntityFireProjectile;
import moze_intel.projecte.gameObjs.entity.EntitySWRGProjectile;
import moze_intel.projecte.gameObjs.items.IFireProtector;
import moze_intel.projecte.gameObjs.items.IFlightProvider;
import moze_intel.projecte.gameObjs.items.IItemMode;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.integration.IntegrationHelper;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.block.Blocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.SnowballEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Arcana
extends ItemPE
implements IItemMode,
IFlightProvider,
IFireProtector,
IExtraFunction,
IProjectileShooter {
    private static final String[] modes = new String[]{"pe.arcana.mode.0", "pe.arcana.mode.1", "pe.arcana.mode.2", "pe.arcana.mode.3"};

    public Arcana(Item.Properties props) {
        super(props);
        this.func_185043_a(ACTIVE_NAME, ACTIVE_GETTER);
        this.func_185043_a(new ResourceLocation("projecte", "mode"), MODE_GETTER);
        this.addItemCapability(ExtraFunctionItemCapabilityWrapper::new);
        this.addItemCapability(ProjectileShooterItemCapabilityWrapper::new);
        this.addItemCapability(ModeChangerItemCapabilityWrapper::new);
        this.addItemCapability("curios", IntegrationHelper.CURIO_CAP_SUPPLIER);
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        return stack.func_77946_l();
    }

    public void func_150895_a(@Nonnull ItemGroup group, @Nonnull NonNullList<ItemStack> list) {
        if (this.func_194125_a(group)) {
            for (byte i = 0; i < this.getModeCount(); i = (byte)(i + 1)) {
                ItemStack stack = new ItemStack((IItemProvider)this);
                stack.func_196082_o().func_74774_a("Mode", i);
                list.add((Object)stack);
            }
        }
    }

    @Override
    public String[] getModeTranslationKeys() {
        return modes;
    }

    private void tick(ItemStack stack, World world, ServerPlayerEntity player) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74767_n("Active")) {
            switch (this.getMode(stack)) {
                case 0: {
                    WorldHelper.freezeInBoundingBox(world, player.func_174813_aQ().func_186662_g(5.0), (PlayerEntity)player, true);
                    break;
                }
                case 1: {
                    WorldHelper.igniteNearby(world, (PlayerEntity)player);
                    break;
                }
                case 2: {
                    WorldHelper.growNearbyRandomly(true, world, player.func_180425_c(), (PlayerEntity)player);
                    break;
                }
                case 3: {
                    WorldHelper.repelEntitiesSWRG(world, player.func_174813_aQ().func_186662_g(5.0), (PlayerEntity)player);
                }
            }
        }
    }

    public void func_77663_a(@Nonnull ItemStack stack, World world, @Nonnull Entity entity, int slot, boolean held) {
        if (world.field_72995_K || slot > 8 || !(entity instanceof ServerPlayerEntity)) {
            return;
        }
        this.tick(stack, world, (ServerPlayerEntity)entity);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, @Nonnull List<ITextComponent> list, @Nonnull ITooltipFlag flags) {
        if (stack.func_77942_o()) {
            if (!stack.func_77978_p().func_74767_n("Active")) {
                list.add(new TranslationTextComponent("pe.arcana.inactive", new Object[0]).func_211708_a(TextFormatting.RED));
            } else {
                list.add(this.getToolTip(stack));
            }
        }
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        if (!world.field_72995_K) {
            CompoundNBT compound;
            compound.func_74757_a("Active", !(compound = player.func_184586_b(hand).func_196082_o()).func_74767_n("Active"));
        }
        return ActionResult.func_226248_a_((Object)player.func_184586_b(hand));
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext ctx) {
        ActionResultType result;
        if (this.getMode(ctx.func_195996_i()) == 1 && (result = WorldHelper.igniteTNT(ctx)) != ActionResultType.PASS) {
            return result;
        }
        return super.func_195939_a(ctx);
    }

    @Override
    public boolean doExtraFunction(@Nonnull ItemStack stack, @Nonnull PlayerEntity player, Hand hand) {
        World world = player.func_130014_f_();
        if (world.field_72995_K) {
            return true;
        }
        switch (this.getMode(stack)) {
            case 1: {
                switch (player.func_174811_aO()) {
                    case SOUTH: 
                    case NORTH: {
                        for (BlockPos pos : BlockPos.func_218278_a((BlockPos)player.func_180425_c().func_177982_a(-30, -5, -3), (BlockPos)player.func_180425_c().func_177982_a(30, 5, 3))) {
                            if (!world.func_175623_d(pos)) continue;
                            PlayerHelper.checkedPlaceBlock((ServerPlayerEntity)player, pos.func_185334_h(), Blocks.field_150480_ab.func_176223_P());
                        }
                        break;
                    }
                    case WEST: 
                    case EAST: {
                        for (BlockPos pos : BlockPos.func_218278_a((BlockPos)player.func_180425_c().func_177982_a(-3, -5, -30), (BlockPos)player.func_180425_c().func_177982_a(3, 5, 30))) {
                            if (!world.func_175623_d(pos)) continue;
                            PlayerHelper.checkedPlaceBlock((ServerPlayerEntity)player, pos.func_185334_h(), Blocks.field_150480_ab.func_176223_P());
                        }
                        break;
                    }
                }
                world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), PESounds.POWER, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
        }
        return true;
    }

    @Override
    public boolean shootProjectile(@Nonnull PlayerEntity player, @Nonnull ItemStack stack, Hand hand) {
        World world = player.func_130014_f_();
        if (world.field_72995_K) {
            return false;
        }
        switch (this.getMode(stack)) {
            case 0: {
                SnowballEntity snowball = new SnowballEntity(world, (LivingEntity)player);
                snowball.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 1.5f, 1.0f);
                world.func_217376_c((Entity)snowball);
                snowball.func_184185_a(SoundEvents.field_187797_fA, 1.0f, 1.0f);
                break;
            }
            case 1: {
                EntityFireProjectile fire = new EntityFireProjectile(player, world);
                fire.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 1.5f, 1.0f);
                world.func_217376_c((Entity)fire);
                fire.func_184185_a(PESounds.POWER, 1.0f, 1.0f);
                break;
            }
            case 3: {
                EntitySWRGProjectile lightning = new EntitySWRGProjectile(player, true, world);
                lightning.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 1.5f, 1.0f);
                world.func_217376_c((Entity)lightning);
            }
        }
        return true;
    }

    @Override
    public boolean canProtectAgainstFire(ItemStack stack, ServerPlayerEntity player) {
        return true;
    }

    @Override
    public boolean canProvideFlight(ItemStack stack, ServerPlayerEntity player) {
        return true;
    }
}

