/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.rings;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.capabilities.item.IPedestalItem;
import moze_intel.projecte.api.capabilities.item.IProjectileShooter;
import moze_intel.projecte.capability.PedestalItemCapabilityWrapper;
import moze_intel.projecte.capability.ProjectileShooterItemCapabilityWrapper;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.entity.EntityFireProjectile;
import moze_intel.projecte.gameObjs.items.IFireProtector;
import moze_intel.projecte.gameObjs.items.rings.PEToggleItem;
import moze_intel.projecte.gameObjs.tiles.DMPedestalTile;
import moze_intel.projecte.integration.IntegrationHelper;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.MathUtils;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class Ignition
extends PEToggleItem
implements IPedestalItem,
IFireProtector,
IProjectileShooter {
    public Ignition(Item.Properties props) {
        super(props);
        this.addItemCapability(PedestalItemCapabilityWrapper::new);
        this.addItemCapability(ProjectileShooterItemCapabilityWrapper::new);
        this.addItemCapability("curios", IntegrationHelper.CURIO_CAP_SUPPLIER);
    }

    public void func_77663_a(@Nonnull ItemStack stack, World world, @Nonnull Entity entity, int inventorySlot, boolean held) {
        if (world.field_72995_K || inventorySlot > 8 || !(entity instanceof PlayerEntity)) {
            return;
        }
        super.func_77663_a(stack, world, entity, inventorySlot, held);
        ServerPlayerEntity player = (ServerPlayerEntity)entity;
        CompoundNBT nbt = stack.func_196082_o();
        if (nbt.func_74767_n("Active")) {
            if (Ignition.getEmc(stack) == 0L && !Ignition.consumeFuel((PlayerEntity)player, stack, 64L, false)) {
                nbt.func_74757_a("Active", false);
            } else {
                WorldHelper.igniteNearby(world, (PlayerEntity)player);
                Ignition.removeEmc(stack, EMCHelper.removeFractionalEMC(stack, 0.32f));
            }
        } else {
            WorldHelper.extinguishNearby(world, (PlayerEntity)player);
        }
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext ctx) {
        return WorldHelper.igniteTNT(ctx);
    }

    @Override
    public void updateInPedestal(@Nonnull World world, @Nonnull BlockPos pos) {
        if (!world.field_72995_K && (Integer)ProjectEConfig.server.cooldown.pedestal.ignition.get() != -1) {
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof DMPedestalTile)) {
                return;
            }
            DMPedestalTile tile = (DMPedestalTile)te;
            if (tile.getActivityCooldown() == 0) {
                List list = world.func_217357_a(MobEntity.class, tile.getEffectBounds());
                for (MobEntity living : list) {
                    living.func_70097_a(DamageSource.field_76372_a, 3.0f);
                    living.func_70015_d(8);
                }
                tile.setActivityCooldown((Integer)ProjectEConfig.server.cooldown.pedestal.ignition.get());
            } else {
                tile.decrementActivityCooldown();
            }
        }
    }

    @Override
    @Nonnull
    public List<ITextComponent> getPedestalDescription() {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        if ((Integer)ProjectEConfig.server.cooldown.pedestal.ignition.get() != -1) {
            list.add(new TranslationTextComponent("pe.ignition.pedestal1", new Object[0]).func_211708_a(TextFormatting.BLUE));
            list.add(new TranslationTextComponent("pe.ignition.pedestal2", new Object[]{MathUtils.tickToSecFormatted((Integer)ProjectEConfig.server.cooldown.pedestal.ignition.get())}).func_211708_a(TextFormatting.BLUE));
        }
        return list;
    }

    @Override
    public boolean shootProjectile(@Nonnull PlayerEntity player, @Nonnull ItemStack stack, Hand hand) {
        World world = player.func_130014_f_();
        if (world.field_72995_K) {
            return false;
        }
        EntityFireProjectile fire = new EntityFireProjectile(player, world);
        fire.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 1.5f, 1.0f);
        world.func_217376_c((Entity)fire);
        return true;
    }

    @Override
    public boolean canProtectAgainstFire(ItemStack stack, ServerPlayerEntity player) {
        return true;
    }
}

