/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.rings;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.capabilities.item.IItemCharge;
import moze_intel.projecte.api.capabilities.item.IPedestalItem;
import moze_intel.projecte.capability.ChargeItemCapabilityWrapper;
import moze_intel.projecte.capability.PedestalItemCapabilityWrapper;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.items.rings.PEToggleItem;
import moze_intel.projecte.gameObjs.tiles.DMPedestalTile;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IPlantable;

public class TimeWatch
extends PEToggleItem
implements IPedestalItem,
IItemCharge {
    private static Set<TileEntityType<?>> internalBlacklist = Collections.emptySet();
    private static final Tag<Block> BLOCK_BLACKLIST_TAG = new BlockTags.Wrapper(new ResourceLocation("projecte", "time_watch_blacklist"));

    public TimeWatch(Item.Properties props) {
        super(props);
        this.addItemCapability(PedestalItemCapabilityWrapper::new);
        this.addItemCapability(ChargeItemCapabilityWrapper::new);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            if (!((Boolean)ProjectEConfig.server.items.enableTimeWatch.get()).booleanValue()) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("pe.timewatch.disabled", new Object[0]));
                return ActionResult.func_226251_d_((Object)stack);
            }
            byte current = this.getTimeBoost(stack);
            this.setTimeBoost(stack, (byte)(current == 2 ? 0 : current + 1));
            player.func_145747_a((ITextComponent)new TranslationTextComponent("pe.timewatch.mode_switch", new Object[]{new TranslationTextComponent(this.getTimeName(stack), new Object[0]).func_150261_e()}));
        }
        return ActionResult.func_226248_a_((Object)stack);
    }

    public void func_77663_a(@Nonnull ItemStack stack, @Nonnull World world, @Nonnull Entity entity, int invSlot, boolean isHeld) {
        float mobSlowdown;
        int bonusTicks;
        super.func_77663_a(stack, world, entity, invSlot, isHeld);
        if (!(entity instanceof PlayerEntity) || invSlot > 8) {
            return;
        }
        if (!((Boolean)ProjectEConfig.server.items.enableTimeWatch.get()).booleanValue()) {
            return;
        }
        byte timeControl = this.getTimeBoost(stack);
        if (world.func_82736_K().func_223586_b(GameRules.field_223607_j)) {
            if (timeControl == 1) {
                world.func_72877_b(Math.min(world.func_72820_D() + (long)((this.getCharge(stack) + 1) * 4), Long.MAX_VALUE));
            } else if (timeControl == 2) {
                if (world.func_72820_D() - (long)((this.getCharge(stack) + 1) * 4) < 0L) {
                    world.func_72877_b(0L);
                } else {
                    world.func_72877_b(world.func_72820_D() - (long)((this.getCharge(stack) + 1) * 4));
                }
            }
        }
        if (world.field_72995_K || !stack.func_77942_o() || !stack.func_77978_p().func_74767_n("Active")) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        long reqEmc = EMCHelper.removeFractionalEMC(stack, this.getEmcPerTick(this.getCharge(stack)));
        if (!TimeWatch.consumeFuel(player, stack, reqEmc, true)) {
            return;
        }
        int charge = this.getCharge(stack);
        if (charge == 0) {
            bonusTicks = 8;
            mobSlowdown = 0.25f;
        } else if (charge == 1) {
            bonusTicks = 12;
            mobSlowdown = 0.16f;
        } else {
            bonusTicks = 16;
            mobSlowdown = 0.12f;
        }
        AxisAlignedBB bBox = player.func_174813_aQ().func_186662_g(8.0);
        this.speedUpTileEntities(world, bonusTicks, bBox);
        this.speedUpRandomTicks(world, bonusTicks, bBox);
        this.slowMobs(world, bBox, mobSlowdown);
    }

    private void slowMobs(World world, AxisAlignedBB bBox, double mobSlowdown) {
        if (bBox == null) {
            return;
        }
        for (MobEntity ent : world.func_217357_a(MobEntity.class, bBox)) {
            ent.func_213317_d(ent.func_213322_ci().func_216372_d(mobSlowdown, 1.0, mobSlowdown));
        }
    }

    private void speedUpTileEntities(World world, int bonusTicks, AxisAlignedBB bBox) {
        if (bBox == null || bonusTicks == 0) {
            return;
        }
        Set blacklist = ((List)ProjectEConfig.server.effects.timeWatchTEBlacklist.get()).stream().map(ResourceLocation::new).collect(Collectors.toSet());
        List<TileEntity> list = WorldHelper.getTileEntitiesWithinAABB(world, bBox);
        for (int i = 0; i < bonusTicks; ++i) {
            for (TileEntity tile : list) {
                if (tile.func_145837_r() || !(tile instanceof ITickableTileEntity) || internalBlacklist.contains(tile.func_200662_C()) || blacklist.contains(tile.func_200662_C().getRegistryName())) continue;
                ((ITickableTileEntity)tile).func_73660_a();
            }
        }
    }

    private void speedUpRandomTicks(World world, int bonusTicks, AxisAlignedBB bBox) {
        if (bBox == null || bonusTicks == 0 || !(world instanceof ServerWorld)) {
            return;
        }
        for (BlockPos pos : WorldHelper.getPositionsFromBox(bBox)) {
            for (int i = 0; i < bonusTicks; ++i) {
                BlockState state = world.func_180495_p(pos);
                Block block = state.func_177230_c();
                if (!state.func_204519_t() || BLOCK_BLACKLIST_TAG.func_199685_a_((Object)block) || block instanceof FlowingFluidBlock || block instanceof IGrowable || block instanceof IPlantable) continue;
                state.func_227034_b_((ServerWorld)world, pos.func_185334_h(), field_77697_d);
            }
        }
    }

    private String getTimeName(ItemStack stack) {
        byte mode = this.getTimeBoost(stack);
        switch (mode) {
            case 0: {
                return "pe.timewatch.off";
            }
            case 1: {
                return "pe.timewatch.ff";
            }
            case 2: {
                return "pe.timewatch.rw";
            }
        }
        return "ERROR_INVALID_MODE";
    }

    private byte getTimeBoost(ItemStack stack) {
        return stack.func_77942_o() ? stack.func_77978_p().func_74771_c("TimeMode") : (byte)0;
    }

    private void setTimeBoost(ItemStack stack, byte time) {
        stack.func_196082_o().func_74774_a("TimeMode", (byte)MathHelper.func_76125_a((int)time, (int)0, (int)2));
    }

    public double getEmcPerTick(int charge) {
        return (double)(charge + 2) / 2.0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> list, ITooltipFlag flags) {
        list.add((ITextComponent)new TranslationTextComponent("pe.timewatch.tooltip1", new Object[0]));
        list.add((ITextComponent)new TranslationTextComponent("pe.timewatch.tooltip2", new Object[0]));
        if (stack.func_77942_o()) {
            list.add(new TranslationTextComponent("pe.timewatch.mode", new Object[0]).func_150257_a((ITextComponent)new TranslationTextComponent(this.getTimeName(stack), new Object[0])));
        }
    }

    @Override
    public void updateInPedestal(@Nonnull World world, @Nonnull BlockPos pos) {
        TileEntity te;
        if (!world.field_72995_K && ((Boolean)ProjectEConfig.server.items.enableTimeWatch.get()).booleanValue() && (te = world.func_175625_s(pos)) instanceof DMPedestalTile) {
            AxisAlignedBB bBox = ((DMPedestalTile)te).getEffectBounds();
            if ((Integer)ProjectEConfig.server.effects.timePedBonus.get() > 0) {
                this.speedUpTileEntities(world, (Integer)ProjectEConfig.server.effects.timePedBonus.get(), bBox);
                this.speedUpRandomTicks(world, (Integer)ProjectEConfig.server.effects.timePedBonus.get(), bBox);
            }
            if ((Double)ProjectEConfig.server.effects.timePedMobSlowness.get() < 1.0) {
                this.slowMobs(world, bBox, (Double)ProjectEConfig.server.effects.timePedMobSlowness.get());
            }
        }
    }

    @Override
    @Nonnull
    public List<ITextComponent> getPedestalDescription() {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        if ((Integer)ProjectEConfig.server.effects.timePedBonus.get() > 0) {
            list.add(new TranslationTextComponent("pe.timewatch.pedestal1", new Object[]{ProjectEConfig.server.effects.timePedBonus.get()}).func_211708_a(TextFormatting.BLUE));
        }
        if ((Double)ProjectEConfig.server.effects.timePedMobSlowness.get() < 1.0) {
            list.add(new TranslationTextComponent("pe.timewatch.pedestal2", new Object[]{ProjectEConfig.server.effects.timePedMobSlowness.get()}).func_211708_a(TextFormatting.BLUE));
        }
        return list;
    }

    public static void setInternalBlacklist(Set<TileEntityType<?>> types) {
        internalBlacklist = ImmutableSet.copyOf(types);
    }

    @Override
    public int getNumCharges(@Nonnull ItemStack stack) {
        return 2;
    }

    @Override
    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - this.getChargePercent(stack);
    }
}

