/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.tools;

import java.util.function.Consumer;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.capabilities.item.IItemCharge;
import moze_intel.projecte.capability.ChargeItemCapabilityWrapper;
import moze_intel.projecte.capability.ItemCapabilityWrapper;
import moze_intel.projecte.gameObjs.EnumMatterType;
import moze_intel.projecte.utils.ToolHelper;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.ShovelItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class PEShovel
extends ShovelItem
implements IItemCharge {
    private final EnumMatterType matterType;
    private final int numCharges;

    public PEShovel(EnumMatterType matterType, int numCharges, Item.Properties props) {
        super((IItemTier)matterType, 2.0f, -3.0f, props);
        this.matterType = matterType;
        this.numCharges = numCharges;
    }

    public boolean isBookEnchantable(@Nonnull ItemStack stack, @Nonnull ItemStack book) {
        return false;
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return 0;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - this.getChargePercent(stack);
    }

    public float func_150893_a(@Nonnull ItemStack stack, @Nonnull BlockState state) {
        return ToolHelper.getDestroySpeed(super.func_150893_a(stack, state), this.matterType, this.getCharge(stack));
    }

    @Override
    public int getNumCharges(@Nonnull ItemStack stack) {
        return this.numCharges;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return new ItemCapabilityWrapper(stack, new ChargeItemCapabilityWrapper());
    }

    public boolean func_150897_b(BlockState state) {
        if (state.getHarvestTool() == ToolType.SHOVEL) {
            return this.func_200891_e().func_200925_d() >= state.getHarvestLevel();
        }
        return super.func_150897_b(state);
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        if (player == null) {
            return ActionResultType.PASS;
        }
        Hand hand = context.func_221531_n();
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        Direction sideHit = context.func_196000_l();
        BlockState state = world.func_180495_p(pos);
        return ToolHelper.performActions(ToolHelper.tillShovelAOE(context, 0L), () -> {
            if (state.func_203425_a(Tags.Blocks.GRAVEL) || state.func_177230_c() == Blocks.field_150435_aG) {
                return ToolHelper.tryVeinMine(hand, player, pos, sideHit);
            }
            return ActionResultType.PASS;
        }, () -> ToolHelper.digAOE(world, player, hand, pos, sideHit, false, 0L));
    }
}

