/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.tools;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.capabilities.item.IExtraFunction;
import moze_intel.projecte.api.capabilities.item.IItemCharge;
import moze_intel.projecte.capability.ChargeItemCapabilityWrapper;
import moze_intel.projecte.capability.ExtraFunctionItemCapabilityWrapper;
import moze_intel.projecte.capability.ItemCapability;
import moze_intel.projecte.capability.ItemCapabilityWrapper;
import moze_intel.projecte.gameObjs.EnumMatterType;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.ToolHelper;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class PESword
extends SwordItem
implements IExtraFunction,
IItemCharge {
    private final List<Supplier<ItemCapability<?>>> supportedCapabilities = new ArrayList();
    private final EnumMatterType matterType;
    private final int numCharges;

    public PESword(EnumMatterType matterType, int numCharges, int damage, Item.Properties props) {
        super((IItemTier)matterType, damage, -2.4f, props);
        this.matterType = matterType;
        this.numCharges = numCharges;
        this.addItemCapability(ChargeItemCapabilityWrapper::new);
        this.addItemCapability(ExtraFunctionItemCapabilityWrapper::new);
    }

    protected void addItemCapability(Supplier<ItemCapability<?>> capabilitySupplier) {
        this.supportedCapabilities.add(capabilitySupplier);
    }

    public boolean isBookEnchantable(@Nonnull ItemStack stack, @Nonnull ItemStack book) {
        return false;
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return 0;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - this.getChargePercent(stack);
    }

    public float func_150893_a(@Nonnull ItemStack stack, @Nonnull BlockState state) {
        return ToolHelper.getDestroySpeed(super.func_150893_a(stack, state), this.matterType, this.getCharge(stack));
    }

    @Override
    public int getNumCharges(@Nonnull ItemStack stack) {
        return this.numCharges;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        if (this.supportedCapabilities.isEmpty()) {
            return super.initCapabilities(stack, nbt);
        }
        return new ItemCapabilityWrapper(stack, this.supportedCapabilities);
    }

    public boolean func_77644_a(@Nonnull ItemStack stack, @Nonnull LivingEntity damaged, @Nonnull LivingEntity damager) {
        ToolHelper.attackWithCharge(stack, damaged, damager, 1.0f);
        return true;
    }

    @Override
    public boolean doExtraFunction(@Nonnull ItemStack stack, @Nonnull PlayerEntity player, Hand hand) {
        if (player.func_184825_o(0.0f) == 1.0f) {
            ToolHelper.attackAOE(stack, player, this.slayAll(stack), this.func_200894_d(), 0L, hand);
            PlayerHelper.resetCooldown(player);
            return true;
        }
        return false;
    }

    protected boolean slayAll(@Nonnull ItemStack stack) {
        return false;
    }

    @Nonnull
    public Multimap<String, AttributeModifier> getAttributeModifiers(@Nonnull EquipmentSlotType slot, ItemStack stack) {
        return ToolHelper.addChargeAttributeModifier((Multimap<String, AttributeModifier>)super.getAttributeModifiers(slot, stack), slot, stack);
    }
}

