/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.tiles;

import javax.annotation.Nonnull;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.gameObjs.ObjHandler;
import moze_intel.projecte.gameObjs.container.AlchChestContainer;
import moze_intel.projecte.gameObjs.tiles.ChestTileEmc;
import moze_intel.projecte.gameObjs.tiles.TileEmc;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class AlchChestTile
extends ChestTileEmc
implements INamedContainerProvider {
    private final ItemStackHandler inventory = new TileEmc.StackHandler(this, 104);
    private final LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);

    public AlchChestTile() {
        super(ObjHandler.ALCH_CHEST_TILE);
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.inventoryCap.invalidate();
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void func_145839_a(@Nonnull CompoundNBT nbt) {
        super.func_145839_a(nbt);
        this.inventory.deserializeNBT(nbt);
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT nbt) {
        nbt = super.func_189515_b(nbt);
        nbt.func_197643_a(this.inventory.serializeNBT());
        return nbt;
    }

    public void func_73660_a() {
        this.updateChest();
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            stack.getCapability(ProjectEAPI.ALCH_CHEST_ITEM_CAPABILITY).ifPresent(alchChestItem -> alchChestItem.updateInAlchChest(this.field_145850_b, this.field_174879_c, stack));
        }
    }

    @Nonnull
    public Container createMenu(int windowId, @Nonnull PlayerInventory playerInventory, @Nonnull PlayerEntity playerIn) {
        return new AlchChestContainer(windowId, playerInventory, this);
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(ObjHandler.alchChest.func_149739_a(), new Object[0]);
    }
}

