/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.tiles;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.capabilities.tile.IEmcStorage;
import moze_intel.projecte.api.event.PlayerAttemptCondenserSetEvent;
import moze_intel.projecte.emc.nbt.NBTManager;
import moze_intel.projecte.gameObjs.ObjHandler;
import moze_intel.projecte.gameObjs.container.CondenserContainer;
import moze_intel.projecte.gameObjs.container.slots.SlotPredicates;
import moze_intel.projecte.gameObjs.tiles.ChestTileEmc;
import moze_intel.projecte.gameObjs.tiles.TileEmc;
import moze_intel.projecte.gameObjs.tiles.WrappedItemHandler;
import moze_intel.projecte.utils.EMCHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class CondenserTile
extends ChestTileEmc
implements INamedContainerProvider {
    protected final ItemStackHandler inputInventory = this.createInput();
    private final ItemStackHandler outputInventory = this.createOutput();
    private final LazyOptional<IItemHandler> automationInventory = LazyOptional.of(this::createAutomationInventory);
    @Nullable
    private ItemInfo lockInfo;
    private boolean isAcceptingEmc;
    public long displayEmc;
    public long requiredEmc;

    public CondenserTile() {
        this(ObjHandler.CONDENSER_TILE);
    }

    protected CondenserTile(TileEntityType<?> type) {
        super(type);
    }

    @Override
    protected boolean canAcceptEmc() {
        return this.isAcceptingEmc;
    }

    @Override
    protected boolean canProvideEmc() {
        return false;
    }

    @Nullable
    public ItemInfo getLockInfo() {
        return this.lockInfo;
    }

    public ItemStackHandler getInput() {
        return this.inputInventory;
    }

    public ItemStackHandler getOutput() {
        return this.outputInventory;
    }

    protected ItemStackHandler createInput() {
        return new TileEmc.StackHandler(this, 91);
    }

    protected ItemStackHandler createOutput() {
        return this.inputInventory;
    }

    @Nonnull
    protected IItemHandler createAutomationInventory() {
        return new WrappedItemHandler((IItemHandlerModifiable)this.inputInventory, WrappedItemHandler.WriteMode.IN_OUT){

            @Override
            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                return SlotPredicates.HAS_EMC.test(stack) && !CondenserTile.this.isStackEqualToLock(stack) ? super.insertItem(slot, stack, simulate) : stack;
            }

            @Override
            @Nonnull
            public ItemStack extractItem(int slot, int max, boolean simulate) {
                if (!this.getStackInSlot(slot).func_190926_b() && CondenserTile.this.isStackEqualToLock(this.getStackInSlot(slot))) {
                    return super.extractItem(slot, max, simulate);
                }
                return ItemStack.field_190927_a;
            }
        };
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.automationInventory.invalidate();
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.automationInventory.cast();
        }
        return super.getCapability(cap, side);
    }

    public void func_73660_a() {
        this.updateChest();
        if (!this.func_145831_w().field_72995_K) {
            this.checkLockAndUpdate();
            this.displayEmc = this.getStoredEmc();
            if (this.lockInfo != null && this.requiredEmc != 0L) {
                this.condense();
            }
        }
    }

    private void checkLockAndUpdate() {
        if (this.lockInfo == null) {
            this.displayEmc = 0L;
            this.requiredEmc = 0L;
            this.isAcceptingEmc = false;
            return;
        }
        long lockEmc = EMCHelper.getEmcValue(this.lockInfo);
        if (lockEmc > 0L) {
            if (this.requiredEmc != lockEmc) {
                this.requiredEmc = lockEmc;
                this.isAcceptingEmc = true;
            }
        } else {
            this.lockInfo = null;
            this.displayEmc = 0L;
            this.requiredEmc = 0L;
            this.isAcceptingEmc = false;
        }
    }

    protected void condense() {
        for (int i = 0; i < this.inputInventory.getSlots(); ++i) {
            ItemStack stack = this.inputInventory.getStackInSlot(i);
            if (stack.func_190926_b() || this.isStackEqualToLock(stack)) continue;
            this.inputInventory.extractItem(i, 1, false);
            this.forceInsertEmc(EMCHelper.getEmcSellValue(stack), IEmcStorage.EmcAction.EXECUTE);
            break;
        }
        if (this.getStoredEmc() >= this.requiredEmc && this.hasSpace()) {
            this.forceExtractEmc(this.requiredEmc, IEmcStorage.EmcAction.EXECUTE);
            this.pushStack();
        }
    }

    protected void pushStack() {
        if (this.lockInfo != null) {
            ItemHandlerHelper.insertItemStacked((IItemHandler)this.outputInventory, (ItemStack)this.lockInfo.createStack(), (boolean)false);
        }
    }

    protected boolean hasSpace() {
        for (int i = 0; i < this.outputInventory.getSlots(); ++i) {
            ItemStack stack = this.outputInventory.getStackInSlot(i);
            if (!stack.func_190926_b() && (!this.isStackEqualToLock(stack) || stack.func_190916_E() >= stack.func_77976_d())) continue;
            return true;
        }
        return false;
    }

    public boolean isStackEqualToLock(ItemStack stack) {
        if (this.lockInfo == null || stack.func_190926_b()) {
            return false;
        }
        return this.lockInfo.equals(NBTManager.getPersistentInfo(ItemInfo.fromStack(stack)));
    }

    public boolean attemptCondenserSet(PlayerEntity player) {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return false;
        }
        if (this.lockInfo == null) {
            ItemInfo reducedInfo;
            ItemInfo sourceInfo;
            ItemStack stack = player.field_71071_by.func_70445_o();
            if (!stack.func_190926_b() && !MinecraftForge.EVENT_BUS.post((Event)new PlayerAttemptCondenserSetEvent(player, sourceInfo = ItemInfo.fromStack(stack), reducedInfo = NBTManager.getPersistentInfo(sourceInfo)))) {
                this.lockInfo = reducedInfo;
                this.func_70296_d();
                return true;
            }
            return false;
        }
        this.lockInfo = null;
        this.func_70296_d();
        return true;
    }

    @Override
    public void func_145839_a(@Nonnull CompoundNBT nbt) {
        super.func_145839_a(nbt);
        this.inputInventory.deserializeNBT(nbt.func_74775_l("Input"));
        this.lockInfo = ItemInfo.read(nbt.func_74775_l("LockInfo"));
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT nbt) {
        nbt = super.func_189515_b(nbt);
        nbt.func_218657_a("Input", (INBT)this.inputInventory.serializeNBT());
        if (this.lockInfo != null) {
            nbt.func_218657_a("LockInfo", (INBT)this.lockInfo.write(new CompoundNBT()));
        }
        return nbt;
    }

    public Container createMenu(int windowId, @Nonnull PlayerInventory playerInventory, @Nonnull PlayerEntity playerIn) {
        return new CondenserContainer(ObjHandler.CONDENSER_CONTAINER, windowId, playerInventory, this);
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(ObjHandler.condenser.func_149739_a(), new Object[0]);
    }
}

