/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.tiles;

import java.util.Optional;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.capabilities.item.IItemEmcHolder;
import moze_intel.projecte.api.capabilities.tile.IEmcStorage;
import moze_intel.projecte.gameObjs.EnumRelayTier;
import moze_intel.projecte.gameObjs.ObjHandler;
import moze_intel.projecte.gameObjs.container.RelayMK1Container;
import moze_intel.projecte.gameObjs.container.slots.SlotPredicates;
import moze_intel.projecte.gameObjs.tiles.TileEmc;
import moze_intel.projecte.gameObjs.tiles.WrappedItemHandler;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.LazyOptionalHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class RelayMK1Tile
extends TileEmc
implements INamedContainerProvider {
    private final ItemStackHandler input;
    private final ItemStackHandler output = new TileEmc.StackHandler(this, 1);
    private final LazyOptional<IItemHandler> automationInput;
    private final LazyOptional<IItemHandler> automationOutput = LazyOptional.of(() -> new WrappedItemHandler((IItemHandlerModifiable)this.output, WrappedItemHandler.WriteMode.IN_OUT){

        @Override
        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return SlotPredicates.EMC_HOLDER.test(stack) ? super.insertItem(slot, stack, simulate) : stack;
        }

        @Override
        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            Optional holderCapability;
            ItemStack stack = this.getStackInSlot(slot);
            if (!stack.func_190926_b() && (holderCapability = LazyOptionalHelper.toOptional(stack.getCapability(ProjectEAPI.EMC_HOLDER_ITEM_CAPABILITY))).isPresent()) {
                IItemEmcHolder emcHolder = (IItemEmcHolder)holderCapability.get();
                if (emcHolder.getNeededEmc(stack) == 0L) {
                    return super.extractItem(slot, amount, simulate);
                }
                return ItemStack.field_190927_a;
            }
            return super.extractItem(slot, amount, simulate);
        }
    });
    private final long chargeRate;
    private double bonusEMC;

    public RelayMK1Tile() {
        this(ObjHandler.RELAY_MK1_TILE, 7, EnumRelayTier.MK1);
    }

    RelayMK1Tile(TileEntityType<?> type, int sizeInv, EnumRelayTier tier) {
        super(type, tier.getStorage());
        this.chargeRate = tier.getChargeRate();
        this.input = new TileEmc.StackHandler(sizeInv){

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                return SlotPredicates.RELAY_INV.test(stack) ? super.insertItem(slot, stack, simulate) : stack;
            }
        };
        this.automationInput = LazyOptional.of(() -> new WrappedItemHandler((IItemHandlerModifiable)this.input, WrappedItemHandler.WriteMode.IN));
    }

    @Override
    public boolean isRelay() {
        return true;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.automationInput.invalidate();
        this.automationOutput.invalidate();
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (side == Direction.DOWN) {
                return this.automationOutput.cast();
            }
            return this.automationInput.cast();
        }
        return super.getCapability(cap, side);
    }

    private ItemStack getCharging() {
        return this.output.getStackInSlot(0);
    }

    private ItemStack getBurn() {
        return this.input.getStackInSlot(0);
    }

    public IItemHandler getInput() {
        return this.input;
    }

    public IItemHandler getOutput() {
        return this.output;
    }

    public void func_73660_a() {
        ItemStack chargeable;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.sendEmc();
        ItemHelper.compactInventory((IItemHandlerModifiable)this.input);
        ItemStack stack = this.getBurn();
        if (!stack.func_190926_b()) {
            Optional holderCapability = LazyOptionalHelper.toOptional(stack.getCapability(ProjectEAPI.EMC_HOLDER_ITEM_CAPABILITY));
            if (holderCapability.isPresent()) {
                IItemEmcHolder emcHolder2 = (IItemEmcHolder)holderCapability.get();
                long simulatedVal = this.forceInsertEmc(emcHolder2.extractEmc(stack, this.chargeRate, IEmcStorage.EmcAction.SIMULATE), IEmcStorage.EmcAction.SIMULATE);
                if (simulatedVal > 0L) {
                    this.forceInsertEmc(emcHolder2.extractEmc(stack, simulatedVal, IEmcStorage.EmcAction.EXECUTE), IEmcStorage.EmcAction.EXECUTE);
                }
            } else {
                long emcVal = EMCHelper.getEmcSellValue(stack);
                if (emcVal > 0L && emcVal <= this.getNeededEmc()) {
                    this.forceInsertEmc(emcVal, IEmcStorage.EmcAction.EXECUTE);
                    this.getBurn().func_190918_g(1);
                }
            }
        }
        if (!(chargeable = this.getCharging()).func_190926_b() && this.getStoredEmc() > 0L) {
            chargeable.getCapability(ProjectEAPI.EMC_HOLDER_ITEM_CAPABILITY).ifPresent(emcHolder -> {
                long actualSent = emcHolder.insertEmc(chargeable, Math.min(this.getStoredEmc(), this.chargeRate), IEmcStorage.EmcAction.EXECUTE);
                this.forceExtractEmc(actualSent, IEmcStorage.EmcAction.EXECUTE);
            });
        }
    }

    private void sendEmc() {
        if (this.getStoredEmc() == 0L) {
            return;
        }
        if (this.getStoredEmc() <= this.chargeRate) {
            this.sendToAllAcceptors(this.getStoredEmc());
        } else {
            this.sendToAllAcceptors(this.chargeRate);
        }
    }

    public double getItemChargeProportion() {
        Optional holderCapability;
        ItemStack charging = this.getCharging();
        if (!charging.func_190926_b() && (holderCapability = LazyOptionalHelper.toOptional(charging.getCapability(ProjectEAPI.EMC_HOLDER_ITEM_CAPABILITY))).isPresent()) {
            IItemEmcHolder emcHolder = (IItemEmcHolder)holderCapability.get();
            return (double)emcHolder.getStoredEmc(charging) / (double)emcHolder.getMaximumEmc(charging);
        }
        return 0.0;
    }

    public double getInputBurnProportion() {
        ItemStack burn = this.getBurn();
        if (burn.func_190926_b()) {
            return 0.0;
        }
        Optional holderCapability = LazyOptionalHelper.toOptional(burn.getCapability(ProjectEAPI.EMC_HOLDER_ITEM_CAPABILITY));
        if (holderCapability.isPresent()) {
            IItemEmcHolder emcHolder = (IItemEmcHolder)holderCapability.get();
            return (double)emcHolder.getStoredEmc(burn) / (double)emcHolder.getMaximumEmc(burn);
        }
        return (double)burn.func_190916_E() / (double)burn.func_77976_d();
    }

    @Override
    public void func_145839_a(@Nonnull CompoundNBT nbt) {
        super.func_145839_a(nbt);
        this.input.deserializeNBT(nbt.func_74775_l("Input"));
        this.output.deserializeNBT(nbt.func_74775_l("Output"));
        this.bonusEMC = nbt.func_74769_h("BonusEMC");
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT nbt) {
        nbt = super.func_189515_b(nbt);
        nbt.func_218657_a("Input", (INBT)this.input.serializeNBT());
        nbt.func_218657_a("Output", (INBT)this.output.serializeNBT());
        nbt.func_74780_a("BonusEMC", this.bonusEMC);
        return nbt;
    }

    protected double getBonusToAdd() {
        return 0.05;
    }

    public void addBonus() {
        this.bonusEMC += this.getBonusToAdd();
        if (this.bonusEMC >= 1.0) {
            long emcToInsert = (long)this.bonusEMC;
            this.forceInsertEmc(emcToInsert, IEmcStorage.EmcAction.EXECUTE);
            this.bonusEMC -= (double)emcToInsert;
        }
    }

    @Nonnull
    public Container createMenu(int windowId, @Nonnull PlayerInventory playerInventory, @Nonnull PlayerEntity player) {
        return new RelayMK1Container(windowId, playerInventory, this);
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(ObjHandler.relay.func_149739_a(), new Object[0]);
    }
}

