/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.tiles;

import java.util.ArrayList;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.capabilities.tile.IEmcStorage;
import moze_intel.projecte.api.tile.TileEmcBase;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.ItemStackHandler;

public abstract class TileEmc
extends TileEmcBase
implements ITickableTileEntity {
    public TileEmc(TileEntityType<?> type) {
        super(type);
        this.setMaximumEMC(Long.MAX_VALUE);
    }

    public TileEmc(TileEntityType<?> type, long maxAmount) {
        super(type);
        this.setMaximumEMC(maxAmount);
    }

    public final CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    protected long sendToAllAcceptors(long emc) {
        if (this.field_145850_b == null || !this.canProvideEmc()) {
            return 0L;
        }
        emc = Math.min(this.getEmcExtractLimit(), emc);
        long sentEmc = 0L;
        ArrayList targets = new ArrayList();
        for (Direction dir : Direction.values()) {
            TileEntity neighboringTile;
            BlockPos neighboringPos = this.func_174877_v().func_177972_a(dir);
            if (!this.field_145850_b.func_195588_v(neighboringPos) || (neighboringTile = this.field_145850_b.func_175625_s(neighboringPos)) == null) continue;
            neighboringTile.getCapability(ProjectEAPI.EMC_STORAGE_CAPABILITY, dir.func_176734_d()).ifPresent(theirEmcStorage -> {
                if (!(this.isRelay() && theirEmcStorage.isRelay() || theirEmcStorage.insertEmc(1L, IEmcStorage.EmcAction.SIMULATE) <= 0L)) {
                    targets.add(theirEmcStorage);
                }
            });
        }
        if (!targets.isEmpty()) {
            long emcPer = emc / (long)targets.size();
            for (IEmcStorage target : targets) {
                long emcCanProvide = this.extractEmc(emcPer, IEmcStorage.EmcAction.SIMULATE);
                long acceptedEmc = target.insertEmc(emcCanProvide, IEmcStorage.EmcAction.EXECUTE);
                this.extractEmc(acceptedEmc, IEmcStorage.EmcAction.EXECUTE);
                sentEmc += acceptedEmc;
            }
        }
        return sentEmc;
    }

    class StackHandler
    extends ItemStackHandler {
        StackHandler(int size) {
            super(size);
        }

        public void onContentsChanged(int slot) {
            TileEmc.this.func_70296_d();
        }
    }
}

