/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.handlers;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.ObjHandler;
import moze_intel.projecte.gameObjs.items.IFlightProvider;
import moze_intel.projecte.gameObjs.items.IStepAssister;
import moze_intel.projecte.utils.PlayerHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public final class InternalAbilities {
    @CapabilityInject(value=InternalAbilities.class)
    public static Capability<InternalAbilities> CAPABILITY = null;
    public static final ResourceLocation NAME = new ResourceLocation("projecte", "internal_abilities");
    private final ServerPlayerEntity player;
    private boolean swrgOverride = false;
    private boolean gemArmorReady = false;
    private boolean stepAssisted = false;
    private boolean hadFlightItem = false;
    private boolean wasFlyingGamemode = false;
    private boolean isFlyingGamemode = false;
    private boolean wasFlying = false;
    private int projectileCooldown = 0;
    private int gemChestCooldown = 0;

    public InternalAbilities(ServerPlayerEntity player) {
        this.player = player;
    }

    public void resetProjectileCooldown() {
        this.projectileCooldown = (Integer)ProjectEConfig.server.cooldown.player.projectile.get();
    }

    public int getProjectileCooldown() {
        return this.projectileCooldown;
    }

    public void resetGemCooldown() {
        this.gemChestCooldown = (Integer)ProjectEConfig.server.cooldown.player.gemChest.get();
    }

    public int getGemCooldown() {
        return this.gemChestCooldown;
    }

    public void setGemState(boolean state) {
        this.gemArmorReady = state;
    }

    public boolean getGemState() {
        return this.gemArmorReady;
    }

    public void tick() {
        if (this.projectileCooldown > 0) {
            --this.projectileCooldown;
        }
        if (this.gemChestCooldown > 0) {
            --this.gemChestCooldown;
        }
        if (!this.shouldPlayerFly()) {
            if (this.hadFlightItem) {
                if (this.player.field_71075_bZ.field_75101_c) {
                    PlayerHelper.updateClientServerFlight(this.player, false);
                }
                this.hadFlightItem = false;
            }
            this.wasFlyingGamemode = false;
            this.wasFlying = false;
        } else {
            if (!this.hadFlightItem) {
                if (!this.player.field_71075_bZ.field_75101_c) {
                    PlayerHelper.updateClientServerFlight(this.player, true);
                }
                this.hadFlightItem = true;
            } else if (this.wasFlyingGamemode && !this.isFlyingGamemode) {
                PlayerHelper.updateClientServerFlight(this.player, true, this.wasFlying);
            }
            this.wasFlyingGamemode = this.isFlyingGamemode;
            this.wasFlying = this.player.field_71075_bZ.field_75100_b;
        }
        if (!this.shouldPlayerStep()) {
            if (this.stepAssisted) {
                this.stepAssisted = false;
                PlayerHelper.updateClientServerStepHeight(this.player, 0.6f);
            }
        } else if (!this.stepAssisted) {
            this.stepAssisted = true;
            PlayerHelper.updateClientServerStepHeight(this.player, 1.0f);
        }
    }

    public void onDimensionChange() {
        PlayerHelper.updateClientServerFlight(this.player, this.player.field_71075_bZ.field_75101_c);
        PlayerHelper.updateClientServerStepHeight(this.player, this.stepAssisted ? 1.0f : 0.6f);
    }

    private boolean shouldPlayerFly() {
        if (!this.hasSwrg()) {
            this.disableSwrgFlightOverride();
        }
        boolean bl = this.isFlyingGamemode = this.player.field_71075_bZ.field_75098_d || this.player.func_175149_v();
        if (this.isFlyingGamemode || this.swrgOverride) {
            return true;
        }
        return this.checkArmorHotbarCurios(stack -> !stack.func_190926_b() && stack.func_77973_b() instanceof IFlightProvider && ((IFlightProvider)stack.func_77973_b()).canProvideFlight((ItemStack)stack, this.player));
    }

    private boolean shouldPlayerStep() {
        return this.checkArmorHotbarCurios(stack -> !stack.func_190926_b() && stack.func_77973_b() instanceof IStepAssister && ((IStepAssister)stack.func_77973_b()).canAssistStep((ItemStack)stack, this.player));
    }

    private boolean hasSwrg() {
        return this.checkHotbarCurios(stack -> !stack.func_190926_b() && stack.func_77973_b() == ObjHandler.swrg);
    }

    private boolean checkArmorHotbarCurios(Predicate<ItemStack> checker) {
        for (ItemStack stack : this.player.field_71071_by.field_70460_b) {
            if (!checker.test(stack)) continue;
            return true;
        }
        return this.checkHotbarCurios(checker);
    }

    private boolean checkHotbarCurios(Predicate<ItemStack> checker) {
        for (int i = 0; i < PlayerInventory.func_70451_h(); ++i) {
            if (!checker.test(this.player.field_71071_by.func_70301_a(i))) continue;
            return true;
        }
        IItemHandler curios = PlayerHelper.getCurios((PlayerEntity)this.player);
        if (curios != null) {
            for (int i = 0; i < curios.getSlots(); ++i) {
                if (!checker.test(curios.getStackInSlot(i))) continue;
                return true;
            }
        }
        return false;
    }

    public void enableSwrgFlightOverride() {
        this.swrgOverride = true;
    }

    public void disableSwrgFlightOverride() {
        this.swrgOverride = false;
    }

    public static class Provider
    implements ICapabilityProvider {
        private final LazyOptional<InternalAbilities> capInstance = LazyOptional.of(() -> new InternalAbilities(player));

        public Provider(ServerPlayerEntity player) {
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
            if (capability == CAPABILITY) {
                return this.capInstance.cast();
            }
            return LazyOptional.empty();
        }
    }
}

