/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.impl.capability.KnowledgeImpl;
import moze_intel.projecte.utils.ItemHelper;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.INBT;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.thread.SidedThreadGroups;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TransmutationOffline {
    private static final IKnowledgeProvider NOT_FOUND_PROVIDER = TransmutationOffline.immutableCopy((IKnowledgeProvider)ProjectEAPI.KNOWLEDGE_CAPABILITY.getDefaultInstance());
    private static final Map<UUID, IKnowledgeProvider> cachedKnowledgeProviders = new HashMap<UUID, IKnowledgeProvider>();

    public static void cleanAll() {
        cachedKnowledgeProviders.clear();
    }

    public static void clear(UUID playerUUID) {
        cachedKnowledgeProviders.remove(playerUUID);
    }

    static IKnowledgeProvider forPlayer(UUID playerUUID) {
        if (!cachedKnowledgeProviders.containsKey(playerUUID) && !TransmutationOffline.cacheOfflineData(playerUUID)) {
            cachedKnowledgeProviders.put(playerUUID, NOT_FOUND_PROVIDER);
        }
        return cachedKnowledgeProviders.get(playerUUID);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean cacheOfflineData(UUID playerUUID) {
        Preconditions.checkState((Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER ? 1 : 0) != 0, (Object)"CRITICAL: Trying to read filesystem on client!!");
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        File playerData = server.func_71254_M().func_186352_b(server.func_71270_I(), "playerdata");
        if (!playerData.exists()) return false;
        File player = new File(playerData, playerUUID.toString() + ".dat");
        if (!player.exists()) return false;
        if (!player.isFile()) return false;
        try (FileInputStream in = new FileInputStream(player);){
            CompoundNBT playerDat = CompressedStreamTools.func_74796_a((InputStream)in);
            CompoundNBT knowledgeProvider = playerDat.func_74775_l("ForgeCaps").func_74775_l(KnowledgeImpl.Provider.NAME.toString());
            IKnowledgeProvider provider = (IKnowledgeProvider)ProjectEAPI.KNOWLEDGE_CAPABILITY.getDefaultInstance();
            ProjectEAPI.KNOWLEDGE_CAPABILITY.readNBT((Object)provider, null, (INBT)knowledgeProvider);
            cachedKnowledgeProviders.put(playerUUID, TransmutationOffline.immutableCopy(provider));
            PECore.debugLog("Caching offline data for UUID: {}", playerUUID);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            PECore.LOGGER.warn("Failed to cache offline data for API calls for UUID: {}", (Object)playerUUID);
        }
        return false;
    }

    private static IKnowledgeProvider immutableCopy(final IKnowledgeProvider toCopy) {
        return new IKnowledgeProvider(){
            final Set<ItemInfo> immutableKnowledge;
            final IItemHandlerModifiable immutableInputLocks;
            {
                this.immutableKnowledge = ImmutableSet.copyOf(toCopy.getKnowledge());
                this.immutableInputLocks = ItemHelper.immutableCopy(toCopy.getInputAndLocks());
            }

            @Override
            public boolean hasFullKnowledge() {
                return toCopy.hasFullKnowledge();
            }

            @Override
            public void setFullKnowledge(boolean fullKnowledge) {
            }

            @Override
            public void clearKnowledge() {
            }

            @Override
            public boolean hasKnowledge(@Nonnull ItemInfo info) {
                return toCopy.hasKnowledge(info);
            }

            @Override
            public boolean addKnowledge(@Nonnull ItemInfo info) {
                return false;
            }

            @Override
            public boolean removeKnowledge(@Nonnull ItemInfo info) {
                return false;
            }

            @Override
            @Nonnull
            public Set<ItemInfo> getKnowledge() {
                return this.immutableKnowledge;
            }

            @Override
            @Nonnull
            public IItemHandler getInputAndLocks() {
                return this.immutableInputLocks;
            }

            @Override
            public BigInteger getEmc() {
                return toCopy.getEmc();
            }

            @Override
            public void setEmc(BigInteger emc) {
            }

            @Override
            public void sync(@Nonnull ServerPlayerEntity player) {
                toCopy.sync(player);
            }

            public CompoundNBT serializeNBT() {
                return (CompoundNBT)toCopy.serializeNBT();
            }

            public void deserializeNBT(CompoundNBT nbt) {
            }
        };
    }
}

