/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.impl.capability;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.api.event.PlayerKnowledgeChangeEvent;
import moze_intel.projecte.emc.EMCMappingHandler;
import moze_intel.projecte.emc.nbt.NBTManager;
import moze_intel.projecte.gameObjs.ObjHandler;
import moze_intel.projecte.network.PacketHandler;
import moze_intel.projecte.network.packets.KnowledgeSyncPKT;
import moze_intel.projecte.utils.EMCHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public final class KnowledgeImpl {
    public static void init() {
        CapabilityManager.INSTANCE.register(IKnowledgeProvider.class, (Capability.IStorage)new Capability.IStorage<IKnowledgeProvider>(){

            public CompoundNBT writeNBT(Capability<IKnowledgeProvider> capability, IKnowledgeProvider instance, Direction side) {
                return (CompoundNBT)instance.serializeNBT();
            }

            public void readNBT(Capability<IKnowledgeProvider> capability, IKnowledgeProvider instance, Direction side, INBT nbt) {
                if (nbt instanceof CompoundNBT) {
                    instance.deserializeNBT((INBT)((CompoundNBT)nbt));
                }
            }
        }, () -> new DefaultImpl(null));
    }

    private KnowledgeImpl() {
    }

    public static class Provider
    implements ICapabilitySerializable<CompoundNBT> {
        public static final ResourceLocation NAME = new ResourceLocation("projecte", "knowledge");
        private final DefaultImpl impl;
        private final LazyOptional<IKnowledgeProvider> cap;

        public Provider(PlayerEntity player) {
            this.impl = new DefaultImpl(player);
            this.cap = LazyOptional.of(() -> this.impl);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
            if (capability == ProjectEAPI.KNOWLEDGE_CAPABILITY) {
                return this.cap.cast();
            }
            return LazyOptional.empty();
        }

        public CompoundNBT serializeNBT() {
            return this.impl.serializeNBT();
        }

        public void deserializeNBT(CompoundNBT nbt) {
            this.impl.deserializeNBT(nbt);
        }
    }

    private static class DefaultImpl
    implements IKnowledgeProvider {
        @Nullable
        private final PlayerEntity player;
        private final Set<ItemInfo> knowledge = new HashSet<ItemInfo>();
        private final IItemHandlerModifiable inputLocks = new ItemStackHandler(9);
        private BigInteger emc = BigInteger.ZERO;
        private boolean fullKnowledge = false;

        private DefaultImpl(@Nullable PlayerEntity player) {
            this.player = player;
        }

        private void fireChangedEvent() {
            if (this.player != null && !this.player.field_70170_p.field_72995_K) {
                MinecraftForge.EVENT_BUS.post((Event)new PlayerKnowledgeChangeEvent(this.player));
            }
        }

        @Override
        public boolean hasFullKnowledge() {
            return this.fullKnowledge;
        }

        @Override
        public void setFullKnowledge(boolean fullKnowledge) {
            boolean changed = this.fullKnowledge != fullKnowledge;
            this.fullKnowledge = fullKnowledge;
            if (changed) {
                this.fireChangedEvent();
            }
        }

        @Override
        public void clearKnowledge() {
            this.knowledge.clear();
            this.fullKnowledge = false;
            this.fireChangedEvent();
        }

        @Override
        public boolean hasKnowledge(@Nonnull ItemInfo info) {
            if (this.fullKnowledge) {
                return true;
            }
            return this.knowledge.contains(NBTManager.getPersistentInfo(info));
        }

        @Override
        public boolean addKnowledge(@Nonnull ItemInfo info) {
            if (this.fullKnowledge) {
                return false;
            }
            if (info.getItem() == ObjHandler.tome) {
                if (info.hasNBT()) {
                    info = ItemInfo.fromItem(info.getItem());
                }
                if (!this.hasKnowledge(info)) {
                    this.knowledge.add(info);
                }
                this.fullKnowledge = true;
                this.fireChangedEvent();
                return true;
            }
            ItemInfo cleanedInfo = NBTManager.getPersistentInfo(info);
            if (!this.hasKnowledge(cleanedInfo)) {
                this.knowledge.add(cleanedInfo);
                this.fireChangedEvent();
                return true;
            }
            return false;
        }

        @Override
        public boolean removeKnowledge(@Nonnull ItemInfo info) {
            if (info.getItem() == ObjHandler.tome) {
                this.setFullKnowledge(false);
                return true;
            }
            if (this.fullKnowledge) {
                return false;
            }
            ItemInfo cleanedInfo = NBTManager.getPersistentInfo(info);
            if (this.knowledge.remove(cleanedInfo)) {
                this.fireChangedEvent();
                return true;
            }
            return false;
        }

        @Override
        @Nonnull
        public Set<ItemInfo> getKnowledge() {
            if (this.fullKnowledge) {
                Set<ItemInfo> allKnowledge = EMCMappingHandler.getMappedItems();
                allKnowledge.addAll(this.knowledge);
                return Collections.unmodifiableSet(allKnowledge);
            }
            return Collections.unmodifiableSet(this.knowledge);
        }

        @Nonnull
        public IItemHandlerModifiable getInputAndLocks() {
            return this.inputLocks;
        }

        @Override
        public BigInteger getEmc() {
            return this.emc;
        }

        @Override
        public void setEmc(BigInteger emc) {
            this.emc = emc;
        }

        @Override
        public void sync(@Nonnull ServerPlayerEntity player) {
            PacketHandler.sendTo(new KnowledgeSyncPKT(this.serializeNBT()), player);
        }

        public CompoundNBT serializeNBT() {
            CompoundNBT properties = new CompoundNBT();
            properties.func_74778_a("transmutationEmc", this.emc.toString());
            ListNBT knowledgeWrite = new ListNBT();
            for (ItemInfo i : this.knowledge) {
                CompoundNBT tag = i.write(new CompoundNBT());
                knowledgeWrite.add((Object)tag);
            }
            properties.func_218657_a("knowledge", (INBT)knowledgeWrite);
            properties.func_218657_a("inputlock", CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.writeNBT((Object)this.inputLocks, null));
            properties.func_74757_a("fullknowledge", this.fullKnowledge);
            return properties;
        }

        public void deserializeNBT(CompoundNBT properties) {
            int i;
            String transmutationEmc = properties.func_74779_i("transmutationEmc");
            this.emc = transmutationEmc.isEmpty() ? BigInteger.ZERO : new BigInteger(transmutationEmc);
            ListNBT list = properties.func_150295_c("knowledge", 10);
            for (i = 0; i < list.size(); ++i) {
                ItemInfo info = ItemInfo.read(list.func_150305_b(i));
                if (info == null) continue;
                this.knowledge.add(info);
            }
            this.pruneStaleKnowledge();
            for (i = 0; i < this.inputLocks.getSlots(); ++i) {
                this.inputLocks.setStackInSlot(i, ItemStack.field_190927_a);
            }
            CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.readNBT((Object)this.inputLocks, null, (INBT)properties.func_150295_c("inputlock", 10));
            this.fullKnowledge = properties.func_74767_n("fullknowledge");
        }

        private void pruneStaleKnowledge() {
            ArrayList<ItemInfo> toRemove = new ArrayList<ItemInfo>();
            ArrayList<ItemInfo> toAdd = new ArrayList<ItemInfo>();
            for (ItemInfo info : this.knowledge) {
                ItemInfo persistentInfo;
                if (!info.equals(persistentInfo = NBTManager.getPersistentInfo(info))) {
                    toRemove.add(info);
                    if (!EMCHelper.doesItemHaveEmc(persistentInfo)) continue;
                    toAdd.add(persistentInfo);
                    continue;
                }
                if (EMCHelper.doesItemHaveEmc(info)) continue;
                toRemove.add(info);
            }
            this.knowledge.removeAll(toRemove);
            this.knowledge.addAll(toAdd);
        }
    }
}

