/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.integration.crafttweaker.actions;

import com.blamejared.crafttweaker.api.actions.IUndoableAction;
import com.blamejared.crafttweaker.impl.blocks.MCBlockState;
import moze_intel.projecte.utils.WorldTransmutations;
import net.minecraft.block.BlockState;

public abstract class WorldTransmuteAction
implements IUndoableAction {
    protected final BlockState input;
    protected final BlockState output;
    protected final BlockState sneakOutput;

    private WorldTransmuteAction(MCBlockState input, MCBlockState output, MCBlockState sneakOutput) {
        this(input.getInternal(), output.getInternal(), sneakOutput.getInternal());
    }

    private WorldTransmuteAction(BlockState input, BlockState output, BlockState sneakOutput) {
        this.input = input;
        this.output = output;
        this.sneakOutput = sneakOutput;
    }

    protected void apply(boolean add) {
        if (add) {
            WorldTransmutations.register(this.input, this.output, this.sneakOutput);
        } else {
            WorldTransmutations.getWorldTransmutations().removeIf(entry -> entry.getOrigin() == this.input && entry.getResult() == this.output && entry.getAltResult() == this.sneakOutput);
        }
    }

    public static class RemoveAll
    implements IUndoableAction {
        public void apply() {
            WorldTransmutations.getWorldTransmutations().clear();
        }

        public String describe() {
            return "Removing all world transmutation recipes";
        }

        public void undo() {
            WorldTransmutations.resetWorldTransmutations();
        }

        public String describeUndo() {
            return "Restored world transmutation recipes to default";
        }
    }

    public static class Remove
    extends WorldTransmuteAction {
        public Remove(MCBlockState input, MCBlockState output, MCBlockState sneakOutput) {
            super(input, output, sneakOutput);
        }

        public void apply() {
            this.apply(false);
        }

        public String describe() {
            if (this.sneakOutput == null) {
                return "Removing world transmutation recipe for: " + this.input + " with output: " + this.output;
            }
            return "Removing world transmutation recipe for: " + this.input + " with output: " + this.output + " and secondary output: " + this.sneakOutput;
        }

        public void undo() {
            this.apply(true);
        }

        public String describeUndo() {
            if (this.sneakOutput == null) {
                return "Undoing removal of world transmutation recipe for: " + this.input + " with output: " + this.output;
            }
            return "Undoing removal of world transmutation recipe for: " + this.input + " with output: " + this.output + " and secondary output: " + this.sneakOutput;
        }
    }

    public static class Add
    extends WorldTransmuteAction {
        public Add(MCBlockState input, MCBlockState output, MCBlockState sneakOutput) {
            super(input, output, sneakOutput);
        }

        public void apply() {
            this.apply(true);
        }

        public String describe() {
            if (this.sneakOutput == null) {
                return "Adding world transmutation recipe for: " + this.input + " with output: " + this.output;
            }
            return "Adding world transmutation recipe for: " + this.input + " with output: " + this.output + " and secondary output: " + this.sneakOutput;
        }

        public void undo() {
            this.apply(false);
        }

        public String describeUndo() {
            if (this.sneakOutput == null) {
                return "Undoing addition of world transmutation recipe for: " + this.input + " with output: " + this.output;
            }
            return "Undoing addition of world transmutation recipe for: " + this.input + " with output: " + this.output + " and secondary output: " + this.sneakOutput;
        }
    }
}

