/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.integration.crafttweaker.nss;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.impl.tag.MCTag;
import com.google.gson.JsonParseException;
import moze_intel.projecte.api.nss.NSSItem;
import moze_intel.projecte.emc.json.NSSSerializer;
import moze_intel.projecte.integration.crafttweaker.nss.NSSCrT;
import net.minecraft.item.Item;
import net.minecraft.tags.Tag;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.projecte.NSSResolver")
public class CrTNSSResolver {
    @ZenCodeType.Method
    public static NSSCrT deserialize(String representation) {
        if (CrTNSSResolver.checkNonNull(representation)) {
            try {
                return new NSSCrT(NSSSerializer.INSTANCE.deserialize(representation));
            }
            catch (JsonParseException e) {
                CraftTweakerAPI.logError((String)("Error deserializing NSS string representation: " + e.getMessage()), (Object[])new Object[0]);
            }
        }
        return null;
    }

    @ZenCodeType.Method
    public static NSSCrT fromItem(IItemStack stack) {
        if (CrTNSSResolver.checkNonNull(stack)) {
            return new NSSCrT(NSSItem.createItem(stack.getInternal()));
        }
        return null;
    }

    @ZenCodeType.Method
    public static NSSCrT fromItemTag(MCTag tag) {
        Tag itemTag;
        if (CrTNSSResolver.checkNonNull(tag) && CrTNSSResolver.checkNonNull(itemTag = tag.getItemTag())) {
            return new NSSCrT(NSSItem.createTag((Tag<Item>)itemTag));
        }
        return null;
    }

    private static boolean checkNonNull(Object object) {
        if (object == null) {
            CraftTweakerAPI.logError((String)"The NSS Representation cannot be null.", (Object[])new Object[0]);
            return false;
        }
        return true;
    }
}

