/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.integration.jei.collectors;

import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import moze_intel.projecte.gameObjs.ObjHandler;
import moze_intel.projecte.integration.jei.collectors.FuelUpgradeRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class CollectorRecipeCategory
implements IRecipeCategory<FuelUpgradeRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("projecte", "collector");
    private final IDrawable background;
    private final IDrawable arrow;
    private final IDrawable icon;
    private final String localizedName;

    public CollectorRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(135, 48);
        this.arrow = guiHelper.drawableBuilder(new ResourceLocation("projecte", "textures/gui/arrow.png"), 0, 0, 22, 15).setTextureSize(32, 32).build();
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ObjHandler.collectorMK1));
        this.localizedName = I18n.func_135052_a((String)"pe.jei.collector", (Object[])new Object[0]);
    }

    @Nonnull
    public ResourceLocation getUid() {
        return UID;
    }

    @Nonnull
    public Class<FuelUpgradeRecipe> getRecipeClass() {
        return FuelUpgradeRecipe.class;
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(@Nonnull FuelUpgradeRecipe o, @Nonnull IIngredients ingredients) {
        ingredients.setInput(VanillaTypes.ITEM, (Object)o.getInput());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)o.getOutput());
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull FuelUpgradeRecipe o, @Nonnull IIngredients ingredients) {
        int itemSlots = 0;
        int xPos = 16;
        for (List s : ingredients.getInputs(VanillaTypes.ITEM)) {
            recipeLayout.getItemStacks().init(itemSlots, true, xPos, 16);
            recipeLayout.getItemStacks().set(itemSlots, s);
            ++itemSlots;
            xPos += 16;
        }
        xPos = 104;
        for (List stacks : ingredients.getOutputs(VanillaTypes.ITEM)) {
            recipeLayout.getItemStacks().init(itemSlots, false, xPos, 16);
            recipeLayout.getItemStacks().set(itemSlots, stacks);
            ++itemSlots;
            xPos += 16;
        }
    }

    public void draw(FuelUpgradeRecipe recipe, double mouseX, double mouseY) {
        String emc = recipe.getUpgradeEMC() + " EMC";
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int stringWidth = fontRenderer.func_78256_a(emc);
        fontRenderer.func_211126_b(emc, (float)(this.getBackground().getWidth() - stringWidth) / 2.0f, 5.0f, 0x808080);
        this.arrow.draw(55, 18);
    }
}

