/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.integration.jei.world_transmute;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import moze_intel.projecte.api.imc.WorldTransmutationEntry;
import moze_intel.projecte.gameObjs.ObjHandler;
import moze_intel.projecte.integration.jei.world_transmute.WorldTransmuteEntry;
import moze_intel.projecte.utils.WorldTransmutations;
import net.minecraft.client.resources.I18n;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class WorldTransmuteRecipeCategory
implements IRecipeCategory<WorldTransmuteEntry> {
    public static final ResourceLocation UID = new ResourceLocation("projecte", "world_transmutation");
    private final IDrawable background;
    private final IDrawable arrow;
    private final IDrawable icon;
    private final String localizedName;

    public WorldTransmuteRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(135, 48);
        this.arrow = guiHelper.drawableBuilder(new ResourceLocation("projecte", "textures/gui/arrow.png"), 0, 0, 22, 15).setTextureSize(32, 32).build();
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ObjHandler.philosStone));
        this.localizedName = I18n.func_135052_a((String)"pe.jei.worldtransmute", (Object[])new Object[0]);
    }

    @Nonnull
    public ResourceLocation getUid() {
        return UID;
    }

    @Nonnull
    public Class<WorldTransmuteEntry> getRecipeClass() {
        return WorldTransmuteEntry.class;
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(@Nonnull WorldTransmuteEntry recipe, double mouseX, double mouseY) {
        this.arrow.draw(55, 18);
    }

    public void setIngredients(WorldTransmuteEntry recipe, @Nonnull IIngredients ingredients) {
        recipe.setIngredients(ingredients);
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull WorldTransmuteEntry recipeWrapper, @Nonnull IIngredients ingredients) {
        int itemSlots = 0;
        int fluidSlots = 0;
        int xPos = 16;
        for (List s : ingredients.getInputs(VanillaTypes.FLUID)) {
            recipeLayout.getFluidStacks().init(fluidSlots, true, xPos, 16, 16, 16, 1000, false, null);
            recipeLayout.getFluidStacks().set(fluidSlots, s);
            ++fluidSlots;
            xPos += 16;
        }
        xPos = 16;
        for (List s : ingredients.getInputs(VanillaTypes.ITEM)) {
            recipeLayout.getItemStacks().init(itemSlots, true, xPos, 16);
            recipeLayout.getItemStacks().set(itemSlots, s);
            ++itemSlots;
            xPos += 16;
        }
        xPos = 96;
        for (List stacks : ingredients.getOutputs(VanillaTypes.ITEM)) {
            recipeLayout.getItemStacks().init(itemSlots, false, xPos, 16);
            recipeLayout.getItemStacks().set(itemSlots, stacks);
            ++itemSlots;
            xPos += 16;
        }
        xPos = 96;
        for (List stacks : ingredients.getOutputs(VanillaTypes.FLUID)) {
            recipeLayout.getFluidStacks().init(fluidSlots, false, xPos, 16, 16, 16, 1000, false, null);
            recipeLayout.getFluidStacks().set(fluidSlots, stacks);
            ++fluidSlots;
            xPos += 16;
        }
    }

    @Nonnull
    public List<String> getTooltipStrings(@Nonnull WorldTransmuteEntry recipe, double mouseX, double mouseY) {
        if (mouseX > 67.0 && mouseX < 107.0 && mouseY > 18.0 && mouseY < 38.0) {
            return Collections.singletonList(I18n.func_135052_a((String)"pe.jei.worldtransmute.description", (Object[])new Object[0]));
        }
        return Collections.emptyList();
    }

    public static List<WorldTransmuteEntry> getAllTransmutations() {
        List<WorldTransmutationEntry> allWorldTransmutations = WorldTransmutations.getWorldTransmutations();
        ArrayList<WorldTransmuteEntry> visible = new ArrayList<WorldTransmuteEntry>();
        allWorldTransmutations.forEach(entry -> {
            WorldTransmuteEntry e = new WorldTransmuteEntry((WorldTransmutationEntry)entry);
            if (e.isRenderable()) {
                boolean alreadyHas;
                FluidStack inputFluid = e.getInputFluid();
                if (inputFluid != null) {
                    Fluid fluid = inputFluid.getFluid();
                    alreadyHas = visible.stream().map(WorldTransmuteEntry::getInputFluid).anyMatch(otherInputFluid -> otherInputFluid != null && fluid == otherInputFluid.getFluid());
                } else {
                    ItemStack inputItem = e.getInputItem();
                    alreadyHas = visible.stream().anyMatch(otherEntry -> inputItem.func_77969_a(otherEntry.getInputItem()));
                }
                if (!alreadyHas) {
                    visible.add(e);
                }
            }
        });
        return visible;
    }
}

