/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.network;

import io.netty.buffer.Unpooled;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.emc.EMCMappingHandler;
import moze_intel.projecte.network.packets.CooldownResetPKT;
import moze_intel.projecte.network.packets.KeyPressPKT;
import moze_intel.projecte.network.packets.KnowledgeClearPKT;
import moze_intel.projecte.network.packets.KnowledgeSyncPKT;
import moze_intel.projecte.network.packets.LeftClickArchangelPKT;
import moze_intel.projecte.network.packets.SearchUpdatePKT;
import moze_intel.projecte.network.packets.SetFlyPKT;
import moze_intel.projecte.network.packets.StepHeightPKT;
import moze_intel.projecte.network.packets.SyncBagDataPKT;
import moze_intel.projecte.network.packets.SyncEmcPKT;
import moze_intel.projecte.network.packets.UpdateCondenserLockPKT;
import moze_intel.projecte.network.packets.UpdateGemModePKT;
import moze_intel.projecte.network.packets.UpdateWindowIntPKT;
import moze_intel.projecte.network.packets.UpdateWindowLongPKT;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public final class PacketHandler {
    private static final String PROTOCOL_VERSION = Integer.toString(1);
    private static final SimpleChannel HANDLER = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("projecte", "main_channel")).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();
    private static int index;

    public static void register() {
        PacketHandler.registerMessage(CooldownResetPKT.class, CooldownResetPKT::encode, CooldownResetPKT::decode, CooldownResetPKT.Handler::handle);
        PacketHandler.registerMessage(KeyPressPKT.class, KeyPressPKT::encode, KeyPressPKT::decode, KeyPressPKT.Handler::handle);
        PacketHandler.registerMessage(KnowledgeClearPKT.class, KnowledgeClearPKT::encode, KnowledgeClearPKT::decode, KnowledgeClearPKT.Handler::handle);
        PacketHandler.registerMessage(KnowledgeSyncPKT.class, KnowledgeSyncPKT::encode, KnowledgeSyncPKT::decode, KnowledgeSyncPKT.Handler::handle);
        PacketHandler.registerMessage(LeftClickArchangelPKT.class, LeftClickArchangelPKT::encode, LeftClickArchangelPKT::decode, LeftClickArchangelPKT.Handler::handle);
        PacketHandler.registerMessage(SearchUpdatePKT.class, SearchUpdatePKT::encode, SearchUpdatePKT::decode, SearchUpdatePKT.Handler::handle);
        PacketHandler.registerMessage(SetFlyPKT.class, SetFlyPKT::encode, SetFlyPKT::decode, SetFlyPKT.Handler::handle);
        PacketHandler.registerMessage(StepHeightPKT.class, StepHeightPKT::encode, StepHeightPKT::decode, StepHeightPKT.Handler::handle);
        PacketHandler.registerMessage(SyncBagDataPKT.class, SyncBagDataPKT::encode, SyncBagDataPKT::decode, SyncBagDataPKT.Handler::handle);
        PacketHandler.registerMessage(SyncEmcPKT.class, SyncEmcPKT::encode, SyncEmcPKT::decode, SyncEmcPKT.Handler::handle);
        PacketHandler.registerMessage(UpdateCondenserLockPKT.class, UpdateCondenserLockPKT::encode, UpdateCondenserLockPKT::decode, UpdateCondenserLockPKT.Handler::handle);
        PacketHandler.registerMessage(UpdateGemModePKT.class, UpdateGemModePKT::encode, UpdateGemModePKT::decode, UpdateGemModePKT.Handler::handle);
        PacketHandler.registerMessage(UpdateWindowIntPKT.class, UpdateWindowIntPKT::encode, UpdateWindowIntPKT::decode, UpdateWindowIntPKT.Handler::handle);
        PacketHandler.registerMessage(UpdateWindowLongPKT.class, UpdateWindowLongPKT::encode, UpdateWindowLongPKT::decode, UpdateWindowLongPKT.Handler::handle);
    }

    private static <MSG> void registerMessage(Class<MSG> type, BiConsumer<MSG, PacketBuffer> encoder, Function<PacketBuffer, MSG> decoder, BiConsumer<MSG, Supplier<NetworkEvent.Context>> consumer) {
        HANDLER.registerMessage(index++, type, encoder, decoder, consumer);
    }

    public static void sendProgressBarUpdateInt(IContainerListener listener, Container container, int propId, int propVal) {
        if (listener instanceof ServerPlayerEntity) {
            PacketHandler.sendTo(new UpdateWindowIntPKT((short)container.field_75152_c, (short)propId, propVal), (ServerPlayerEntity)listener);
        }
    }

    public static void sendProgressBarUpdateLong(IContainerListener listener, Container container, int propId, long propVal) {
        if (listener instanceof ServerPlayerEntity) {
            PacketHandler.sendTo(new UpdateWindowLongPKT((short)container.field_75152_c, (short)propId, propVal), (ServerPlayerEntity)listener);
        }
    }

    public static void sendLockSlotUpdate(IContainerListener listener, Container container, ItemInfo lockInfo) {
        if (listener instanceof ServerPlayerEntity) {
            PacketHandler.sendTo(new UpdateCondenserLockPKT((short)container.field_75152_c, lockInfo), (ServerPlayerEntity)listener);
        }
    }

    public static void sendNonLocal(Object msg, ServerPlayerEntity player) {
        if (player.field_71133_b.func_71262_S() || !player.func_146103_bH().getName().equals(player.field_71133_b.func_71214_G())) {
            HANDLER.sendTo(msg, player.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public static void sendFragmentedEmcPacket(ServerPlayerEntity player) {
        PacketHandler.sendNonLocal(new SyncEmcPKT(PacketHandler.serializeEmcData()), player);
    }

    public static void sendFragmentedEmcPacketToAll() {
        SyncEmcPKT pkt = new SyncEmcPKT(PacketHandler.serializeEmcData());
        for (ServerPlayerEntity player : ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v()) {
            PacketHandler.sendNonLocal(pkt, player);
        }
    }

    private static SyncEmcPKT.EmcPKTInfo[] serializeEmcData() {
        SyncEmcPKT.EmcPKTInfo[] data = EMCMappingHandler.createPacketData();
        PacketBuffer buf = new PacketBuffer(Unpooled.buffer());
        int index = buf.writerIndex();
        SyncEmcPKT.encode(new SyncEmcPKT(data), buf);
        PECore.debugLog("EMC data size: {} bytes", buf.writerIndex() - index);
        buf.release();
        return data;
    }

    public static void sendToServer(Object msg) {
        HANDLER.sendToServer(msg);
    }

    public static void sendTo(Object msg, ServerPlayerEntity player) {
        if (!(player instanceof FakePlayer)) {
            HANDLER.sendTo(msg, player.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
        }
    }
}

