/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.network.packets;

import java.util.function.Supplier;
import moze_intel.projecte.PECore;
import moze_intel.projecte.emc.EMCMappingHandler;
import moze_intel.projecte.emc.FuelMapper;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class SyncEmcPKT {
    private final EmcPKTInfo[] data;

    public SyncEmcPKT(EmcPKTInfo[] data) {
        this.data = data;
    }

    public static void encode(SyncEmcPKT pkt, PacketBuffer buf) {
        buf.func_150787_b(pkt.data.length);
        for (EmcPKTInfo info : pkt.data) {
            buf.writeRegistryId((IForgeRegistryEntry)info.getItem());
            buf.func_150786_a(info.getNbt());
            buf.func_179254_b(info.getEmc());
        }
    }

    public static SyncEmcPKT decode(PacketBuffer buf) {
        int size = buf.func_150792_a();
        EmcPKTInfo[] data = new EmcPKTInfo[size];
        for (int i = 0; i < size; ++i) {
            data[i] = new EmcPKTInfo((Item)buf.readRegistryId(), buf.func_150793_b(), buf.func_179260_f());
        }
        return new SyncEmcPKT(data);
    }

    public static class EmcPKTInfo {
        private Item item;
        private long emc;
        private CompoundNBT nbt;

        public EmcPKTInfo(Item item, CompoundNBT nbt, long emc) {
            this.item = item;
            this.emc = emc;
            this.nbt = nbt;
        }

        public Item getItem() {
            return this.item;
        }

        public long getEmc() {
            return this.emc;
        }

        public CompoundNBT getNbt() {
            return this.nbt;
        }
    }

    public static class Handler {
        public static void handle(SyncEmcPKT pkt, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                PECore.LOGGER.info("Receiving EMC data from server.");
                EMCMappingHandler.fromPacket(pkt.data);
                FuelMapper.loadMap();
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

