/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.network.packets;

import java.util.function.Supplier;
import moze_intel.projecte.gameObjs.container.PEContainer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;

public class UpdateWindowLongPKT {
    private final short windowId;
    private final short propId;
    private final long propVal;

    public UpdateWindowLongPKT(short windowId, short propId, long propVal) {
        this.windowId = windowId;
        this.propId = propId;
        this.propVal = propVal;
    }

    public static void encode(UpdateWindowLongPKT msg, PacketBuffer buf) {
        buf.writeShort((int)msg.windowId);
        buf.writeShort((int)msg.propId);
        buf.writeLong(msg.propVal);
    }

    public static UpdateWindowLongPKT decode(PacketBuffer buf) {
        return new UpdateWindowLongPKT(buf.readShort(), buf.readShort(), buf.readLong());
    }

    public static class Handler {
        public static void handle(UpdateWindowLongPKT msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> Handler.handleClient(msg));
            ctx.get().setPacketHandled(true);
        }

        @OnlyIn(value=Dist.CLIENT)
        private static void handleClient(UpdateWindowLongPKT msg) {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (player.field_71070_bA instanceof PEContainer && player.field_71070_bA.field_75152_c == msg.windowId) {
                ((PEContainer)player.field_71070_bA).updateProgressBarLong(msg.propId, msg.propVal);
            }
        }
    }
}

