/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.rendering;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import moze_intel.projecte.gameObjs.tiles.ChestTileEmc;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.tileentity.ChestTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;

public class ChestRenderer
extends ChestTileEntityRenderer<ChestTileEmc> {
    private final ModelRenderer lid;
    private final ModelRenderer base;
    private final ModelRenderer latch;
    private final Predicate<Block> blockChecker;
    private final ResourceLocation texture;

    public ChestRenderer(TileEntityRendererDispatcher dispatcher, ResourceLocation texture, Predicate<Block> blockChecker) {
        super(dispatcher);
        this.texture = texture;
        this.blockChecker = blockChecker;
        this.base = new ModelRenderer(64, 64, 0, 19);
        this.base.func_228301_a_(1.0f, 0.0f, 1.0f, 14.0f, 10.0f, 14.0f, 0.0f);
        this.lid = new ModelRenderer(64, 64, 0, 0);
        this.lid.func_228301_a_(1.0f, 0.0f, 0.0f, 14.0f, 5.0f, 14.0f, 0.0f);
        this.lid.field_78797_d = 9.0f;
        this.lid.field_78798_e = 1.0f;
        this.latch = new ModelRenderer(64, 64, 0, 0);
        this.latch.func_228301_a_(7.0f, -1.0f, 15.0f, 2.0f, 4.0f, 1.0f, 0.0f);
        this.latch.field_78797_d = 8.0f;
    }

    public void render(@Nonnull ChestTileEmc chestTile, float partialTick, @Nonnull MatrixStack matrix, @Nonnull IRenderTypeBuffer renderer, int light, int overlayLight) {
        BlockState state;
        matrix.func_227860_a_();
        if (chestTile.func_145831_w() != null && !chestTile.func_145837_r() && this.blockChecker.test((state = chestTile.func_145831_w().func_180495_p(chestTile.func_174877_v())).func_177230_c())) {
            matrix.func_227861_a_(0.5, 0.5, 0.5);
            matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-((Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208157_J)).func_185119_l()));
            matrix.func_227861_a_(-0.5, -0.5, -0.5);
        }
        float lidAngle = 1.0f - chestTile.func_195480_a(partialTick);
        lidAngle = 1.0f - lidAngle * lidAngle * lidAngle;
        IVertexBuilder builder = renderer.getBuffer(RenderType.func_228638_b_((ResourceLocation)this.texture));
        this.latch.field_78795_f = this.lid.field_78795_f = -(lidAngle * 1.5707964f);
        this.lid.func_228308_a_(matrix, builder, light, overlayLight);
        this.latch.func_228308_a_(matrix, builder, light, overlayLight);
        this.base.func_228308_a_(matrix, builder, light, overlayLight);
        matrix.func_227865_b_();
    }
}

