/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.utils;

import com.google.common.collect.ImmutableBiMap;
import java.util.Locale;
import moze_intel.projecte.network.PacketHandler;
import moze_intel.projecte.network.packets.KeyPressPKT;
import moze_intel.projecte.utils.PEKeybind;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="projecte", value={Dist.CLIENT})
public class ClientKeyHelper {
    private static ImmutableBiMap<KeyBinding, PEKeybind> mcToPe = ImmutableBiMap.of();
    private static ImmutableBiMap<PEKeybind, KeyBinding> peToMc = ImmutableBiMap.of();

    @SubscribeEvent
    public static void keyPress(TickEvent.ClientTickEvent event) {
        for (KeyBinding k : mcToPe.keySet()) {
            while (k.func_151468_f()) {
                PacketHandler.sendToServer(new KeyPressPKT((PEKeybind)((Object)mcToPe.get((Object)k))));
            }
        }
    }

    public static void registerKeyBindings() {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        builder.put((Object)new KeyBinding("key.projecte.armor_toggle", 88, "projecte"), (Object)PEKeybind.ARMOR_TOGGLE);
        builder.put((Object)new KeyBinding("key.projecte.charge", 86, "projecte"), (Object)PEKeybind.CHARGE);
        builder.put((Object)new KeyBinding("key.projecte.extra_function", 67, "projecte"), (Object)PEKeybind.EXTRA_FUNCTION);
        builder.put((Object)new KeyBinding("key.projecte.fire_projectile", 82, "projecte"), (Object)PEKeybind.FIRE_PROJECTILE);
        builder.put((Object)new KeyBinding("key.projecte.mode", 71, "projecte"), (Object)PEKeybind.MODE);
        mcToPe = builder.build();
        peToMc = mcToPe.inverse();
        for (KeyBinding k : mcToPe.keySet()) {
            ClientRegistry.registerKeyBinding((KeyBinding)k);
        }
    }

    public static String getKeyTranslationKey(PEKeybind k) {
        return "key.projecte." + k.name().toLowerCase(Locale.ROOT);
    }

    public static ITextComponent getKeyName(PEKeybind k) {
        if (peToMc.containsKey((Object)k)) {
            return new StringTextComponent(((KeyBinding)peToMc.get((Object)k)).func_197978_k());
        }
        return new TranslationTextComponent(ClientKeyHelper.getKeyTranslationKey(k), new Object[0]);
    }
}

