/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.utils;

import java.math.BigInteger;
import java.util.Arrays;
import javax.annotation.Nullable;
import moze_intel.projecte.integration.curios.CuriosIntegration;
import moze_intel.projecte.network.PacketHandler;
import moze_intel.projecte.network.packets.CooldownResetPKT;
import moze_intel.projecte.network.packets.SetFlyPKT;
import moze_intel.projecte.network.packets.StepHeightPKT;
import moze_intel.projecte.utils.Constants;
import moze_intel.projecte.utils.ReadOnlyScoreCriteria;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.scoreboard.ScoreCriteria;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.GameType;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public final class PlayerHelper {
    public static final ScoreCriteria SCOREBOARD_EMC = new ReadOnlyScoreCriteria("projecte:emc_score");

    public static boolean checkedPlaceBlock(ServerPlayerEntity player, BlockPos pos, BlockState state) {
        if (!PlayerHelper.hasEditPermission(player, pos)) {
            return false;
        }
        World world = player.func_130014_f_();
        BlockSnapshot before = BlockSnapshot.getBlockSnapshot((IWorld)world, (BlockPos)pos);
        world.func_175656_a(pos, state);
        BlockEvent.EntityPlaceEvent evt = new BlockEvent.EntityPlaceEvent(before, Blocks.field_150350_a.func_176223_P(), (Entity)player);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        if (evt.isCanceled()) {
            world.restoringBlockSnapshots = true;
            before.restore(true, false);
            world.restoringBlockSnapshots = false;
            return false;
        }
        return true;
    }

    public static boolean checkedReplaceBlock(ServerPlayerEntity player, BlockPos pos, BlockState state) {
        return PlayerHelper.hasBreakPermission(player, pos) && PlayerHelper.checkedPlaceBlock(player, pos, state);
    }

    public static ItemStack findFirstItem(PlayerEntity player, Item consumeFrom) {
        return player.field_71071_by.field_70462_a.stream().filter(s -> !s.func_190926_b() && s.func_77973_b() == consumeFrom).findFirst().orElse(ItemStack.field_190927_a);
    }

    @Nullable
    public static IItemHandler getCurios(PlayerEntity player) {
        if (ModList.get().isLoaded("curios")) {
            return CuriosIntegration.getAll((LivingEntity)player);
        }
        return null;
    }

    public static BlockRayTraceResult getBlockLookingAt(PlayerEntity player, double maxDistance) {
        Pair<Vec3d, Vec3d> vecs = PlayerHelper.getLookVec(player, maxDistance);
        RayTraceContext ctx = new RayTraceContext((Vec3d)vecs.getLeft(), (Vec3d)vecs.getRight(), RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)player);
        return player.func_130014_f_().func_217299_a(ctx);
    }

    public static Pair<Vec3d, Vec3d> getLookVec(PlayerEntity player, double maxDistance) {
        Vec3d look = player.func_70676_i(1.0f);
        Vec3d playerPos = new Vec3d(player.func_226277_ct_(), player.func_226278_cu_() + (double)player.func_70047_e(), player.func_226281_cx_());
        Vec3d src = playerPos.func_72441_c(0.0, (double)player.func_70047_e(), 0.0);
        Vec3d dest = src.func_72441_c(look.field_72450_a * maxDistance, look.field_72448_b * maxDistance, look.field_72449_c * maxDistance);
        return ImmutablePair.of((Object)src, (Object)dest);
    }

    public static boolean hasBreakPermission(ServerPlayerEntity player, BlockPos pos) {
        return PlayerHelper.hasEditPermission(player, pos) && ForgeHooks.onBlockBreakEvent((World)player.func_130014_f_(), (GameType)player.field_71134_c.func_73081_b(), (ServerPlayerEntity)player, (BlockPos)pos) != -1;
    }

    public static boolean hasEditPermission(ServerPlayerEntity player, BlockPos pos) {
        if (ServerLifecycleHooks.getCurrentServer().func_175579_a(player.func_130014_f_(), pos, (PlayerEntity)player)) {
            return false;
        }
        return Arrays.stream(Direction.values()).allMatch(e -> player.func_175151_a(pos, e, ItemStack.field_190927_a));
    }

    public static void resetCooldown(PlayerEntity player) {
        player.func_184821_cY();
        PacketHandler.sendTo(new CooldownResetPKT(), (ServerPlayerEntity)player);
    }

    public static void swingItem(PlayerEntity player, Hand hand) {
        if (player.func_130014_f_() instanceof ServerWorld) {
            ((ServerWorld)player.func_130014_f_()).func_72863_F().func_217216_a((Entity)player, (IPacket)new SAnimateHandPacket((Entity)player, hand == Hand.MAIN_HAND ? 0 : 3));
        }
    }

    public static void updateClientServerFlight(ServerPlayerEntity player, boolean allowFlying) {
        PlayerHelper.updateClientServerFlight(player, allowFlying, allowFlying && player.field_71075_bZ.field_75100_b);
    }

    public static void updateClientServerFlight(ServerPlayerEntity player, boolean allowFlying, boolean isFlying) {
        PacketHandler.sendTo(new SetFlyPKT(allowFlying, isFlying), player);
        player.field_71075_bZ.field_75101_c = allowFlying;
        player.field_71075_bZ.field_75100_b = isFlying;
    }

    public static void updateClientServerStepHeight(ServerPlayerEntity player, float value) {
        player.field_70138_W = value;
        PacketHandler.sendTo(new StepHeightPKT(value), player);
    }

    public static void updateScore(ServerPlayerEntity player, ScoreCriteria objective, BigInteger value) {
        PlayerHelper.updateScore(player, objective, value.compareTo(Constants.MAX_INTEGER) > 0 ? Integer.MAX_VALUE : value.intValueExact());
    }

    public static void updateScore(ServerPlayerEntity player, ScoreCriteria objective, int value) {
        player.func_96123_co().func_197893_a(objective, player.func_195047_I_(), obj -> obj.func_96647_c(value));
    }
}

