/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.utils;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.PESounds;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.EnumMatterType;
import moze_intel.projecte.gameObjs.blocks.IMatterBlock;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.LazyOptionalHelper;
import moze_intel.projecte.utils.MathUtils;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.AxeItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.HoeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.ShovelItem;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IProperty;
import net.minecraft.stats.Stats;
import net.minecraft.tags.Tag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;

public class ToolHelper {
    public static final ToolType TOOL_TYPE_HOE = ToolType.get((String)"hoe");
    public static final ToolType TOOL_TYPE_SHEARS = ToolType.get((String)"shears");
    public static final ToolType TOOL_TYPE_HAMMER = ToolType.get((String)"hammer");
    public static final ToolType TOOL_TYPE_KATAR = ToolType.get((String)"katar");
    public static final ToolType TOOL_TYPE_MORNING_STAR = ToolType.get((String)"morning_star");
    private static final UUID CHARGE_MODIFIER = UUID.fromString("69ADE509-46FF-3725-92AC-F59FB052BEC7");
    private static final Predicate<Entity> SHEARABLE = entity -> !entity.func_175149_v() && entity instanceof IShearable;
    private static final Predicate<Entity> SLAY_MOB = entity -> !entity.func_175149_v() && entity instanceof IMob;
    private static final Predicate<Entity> SLAY_ALL = entity -> !entity.func_175149_v() && (entity instanceof IMob || entity instanceof LivingEntity);

    public static Multimap<String, AttributeModifier> addChargeAttributeModifier(Multimap<String, AttributeModifier> currentModifiers, @Nonnull EquipmentSlotType slot, ItemStack stack) {
        int charge;
        if (slot == EquipmentSlotType.MAINHAND && (charge = ToolHelper.getCharge(stack)) > 0) {
            currentModifiers.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(CHARGE_MODIFIER, "Charge modifier", (double)charge, AttributeModifier.Operation.ADDITION));
        }
        return currentModifiers;
    }

    public static ActionResultType performActions(ActionResultType firstAction, ActionSupplier ... secondaryActions) {
        if (firstAction == ActionResultType.SUCCESS) {
            return ActionResultType.SUCCESS;
        }
        ActionResultType result = firstAction;
        boolean hasFailed = result == ActionResultType.FAIL;
        for (ActionSupplier secondaryAction : secondaryActions) {
            result = (ActionResultType)secondaryAction.get();
            if (result == ActionResultType.SUCCESS) {
                return ActionResultType.SUCCESS;
            }
            hasFailed &= result == ActionResultType.FAIL;
        }
        if (hasFailed) {
            return ActionResultType.FAIL;
        }
        return ActionResultType.PASS;
    }

    public static ActionResultType clearTagAOE(World world, PlayerEntity player, Hand hand, long emcCost, Tag<Block> tag) {
        if (((Boolean)ProjectEConfig.server.items.disableAllRadiusMining.get()).booleanValue()) {
            return ActionResultType.PASS;
        }
        ItemStack stack = player.func_184586_b(hand);
        int charge = ToolHelper.getCharge(stack);
        if (charge == 0) {
            return ActionResultType.PASS;
        }
        int scaled1 = 5 * charge;
        int scaled2 = 10 * charge;
        BlockPos corner1 = player.func_180425_c().func_177982_a(-scaled1, -scaled2, -scaled1);
        BlockPos corner2 = player.func_180425_c().func_177982_a(scaled1, scaled2, scaled1);
        boolean hasAction = false;
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (BlockPos pos : WorldHelper.getPositionsFromBox(corner1, corner2)) {
            BlockState state = world.func_180495_p(pos);
            if (!state.func_203425_a(tag)) continue;
            if (world.field_72995_K) {
                return ActionResultType.SUCCESS;
            }
            if (!PlayerHelper.hasBreakPermission((ServerPlayerEntity)player, pos = pos.func_185334_h())) continue;
            if (!ItemPE.consumeFuel(player, stack, emcCost, true)) break;
            drops.addAll(Block.func_220077_a((BlockState)state, (ServerWorld)((ServerWorld)world), (BlockPos)pos, (TileEntity)world.func_175625_s(pos), (Entity)player, (ItemStack)stack));
            world.func_217377_a(pos, false);
            hasAction = true;
            if (world.field_73012_v.nextInt(5) != 0) continue;
            ((ServerWorld)world).func_195598_a((IParticleData)ParticleTypes.field_197594_E, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 2, 0.0, 0.0, 0.0, 0.0);
        }
        if (hasAction) {
            WorldHelper.createLootDrop(drops, world, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
            PlayerHelper.swingItem(player, hand);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public static ActionResultType tillHoeAOE(ItemUseContext context, long emcCost) {
        return ToolHelper.tillAOE(context, emcCost, HoeItem.field_195973_b, ForgeEventFactory::onHoeUse, SoundEvents.field_187693_cj);
    }

    public static ActionResultType tillShovelAOE(ItemUseContext context, long emcCost) {
        return ToolHelper.tillAOE(context, emcCost, ShovelItem.field_195955_e, ctx -> ToolHelper.onToolUse(ctx.func_195999_j(), ctx.func_221531_n(), ctx.func_195995_a(), ctx.func_196000_l()) ? 0 : -1, SoundEvents.field_187771_eN);
    }

    private static ActionResultType tillAOE(ItemUseContext context, long emcCost, Map<Block, BlockState> lookup, ToIntFunction<ItemUseContext> onItemUse, SoundEvent sound) {
        Hand hand;
        ItemStack stack;
        int charge;
        BlockPos pos;
        PlayerEntity player = context.func_195999_j();
        if (player == null) {
            return ActionResultType.PASS;
        }
        Direction sideHit = context.func_196000_l();
        if (sideHit == Direction.DOWN) {
            return ActionResultType.PASS;
        }
        World world = context.func_195991_k();
        BlockState tilledState = lookup.get(world.func_180495_p(pos = context.func_195995_a()).func_177230_c());
        if (tilledState == null) {
            return ActionResultType.PASS;
        }
        BlockPos abovePos = pos.func_177984_a();
        BlockState aboveState = world.func_180495_p(abovePos);
        if (aboveState.func_200015_d((IBlockReader)world, abovePos)) {
            return ActionResultType.PASS;
        }
        int useResult = onItemUse.applyAsInt(context);
        if (useResult < 0) {
            return ActionResultType.PASS;
        }
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        if (useResult == 0) {
            world.func_180501_a(pos, tilledState, 11);
            Material aboveMaterial = aboveState.func_185904_a();
            if ((aboveMaterial == Material.field_151585_k || aboveMaterial == Material.field_151582_l) && !aboveState.func_177230_c().hasTileEntity(aboveState) && PlayerHelper.hasBreakPermission((ServerPlayerEntity)player, abovePos)) {
                world.func_175655_b(abovePos, true);
            }
            world.func_184133_a(null, pos, sound, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        if ((charge = ToolHelper.getCharge(stack = player.func_184586_b(hand = context.func_221531_n()))) > 0) {
            for (BlockPos newPos : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-charge, 0, -charge), (BlockPos)pos.func_177982_a(charge, 0, charge))) {
                BlockState stateAbove;
                if (pos.equals((Object)newPos) || (stateAbove = world.func_180495_p(newPos.func_177984_a())).func_200015_d((IBlockReader)world, newPos.func_177984_a()) || tilledState != lookup.get(world.func_180495_p(newPos).func_177230_c()) || (useResult = onItemUse.applyAsInt(new ItemUseContext(player, hand, new BlockRayTraceResult(Vec3d.field_186680_a, Direction.UP, newPos = newPos.func_185334_h(), false)))) < 0) continue;
                if (useResult > 0) {
                    if (ItemPE.consumeFuel(player, stack, emcCost, true)) continue;
                    break;
                }
                if (!ItemPE.consumeFuel(player, stack, emcCost, true)) break;
                world.func_180501_a(newPos, tilledState, 11);
                Material aboveMaterial = stateAbove.func_185904_a();
                if (aboveMaterial != Material.field_151585_k && aboveMaterial != Material.field_151582_l || stateAbove.func_177230_c().hasTileEntity(stateAbove) || !PlayerHelper.hasBreakPermission((ServerPlayerEntity)player, newPos.func_177984_a())) continue;
                world.func_175655_b(newPos.func_177984_a(), true);
            }
        }
        player.func_130014_f_().func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), PESounds.CHARGE, SoundCategory.PLAYERS, 1.0f, 1.0f);
        return ActionResultType.SUCCESS;
    }

    public static ActionResultType stripLogsAOE(ItemUseContext context, long emcCost) {
        BlockPos pos;
        PlayerEntity player = context.func_195999_j();
        if (player == null) {
            return ActionResultType.PASS;
        }
        Map lookup = AxeItem.field_203176_a;
        World world = context.func_195991_k();
        BlockState clickedState = world.func_180495_p(pos = context.func_195995_a());
        Block strippedBlock = (Block)lookup.get(clickedState.func_177230_c());
        if (strippedBlock == null) {
            return ActionResultType.PASS;
        }
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        Direction.Axis axis = (Direction.Axis)clickedState.func_177229_b((IProperty)RotatedPillarBlock.field_176298_M);
        BlockState strippedState = (BlockState)strippedBlock.func_176223_P().func_206870_a((IProperty)RotatedPillarBlock.field_176298_M, (Comparable)axis);
        world.func_180501_a(pos, strippedState, 11);
        world.func_184133_a(null, pos, SoundEvents.field_203255_y, SoundCategory.BLOCKS, 1.0f, 1.0f);
        Hand hand = context.func_221531_n();
        ItemStack stack = player.func_184586_b(hand);
        int charge = ToolHelper.getCharge(stack);
        if (charge > 0) {
            Direction side = context.func_196000_l();
            for (BlockPos newPos : WorldHelper.getPositionsFromBox(WorldHelper.getBroadBox(pos, side, charge))) {
                BlockState state;
                if (pos.equals((Object)newPos) || strippedBlock != lookup.get((state = world.func_180495_p(newPos)).func_177230_c()) || axis != state.func_177229_b((IProperty)RotatedPillarBlock.field_176298_M) || !ToolHelper.onToolUse(player, hand, newPos = newPos.func_185334_h(), side)) continue;
                if (!ItemPE.consumeFuel(player, stack, emcCost, true)) break;
                world.func_180501_a(newPos, strippedState, 11);
            }
        }
        player.func_130014_f_().func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), PESounds.CHARGE, SoundCategory.PLAYERS, 1.0f, 1.0f);
        return ActionResultType.SUCCESS;
    }

    private static boolean onToolUse(PlayerEntity player, Hand hand, BlockPos pos, Direction face) {
        PlayerInteractEvent.RightClickBlock event = ForgeHooks.onRightClickBlock((PlayerEntity)player, (Hand)hand, (BlockPos)pos, (Direction)face);
        return !event.isCanceled() && event.getUseItem() != Event.Result.DENY;
    }

    public static void digBasedOnMode(ItemStack stack, World world, BlockPos pos, LivingEntity living, RayTracePointer tracePointer) {
        if (world.field_72995_K || ((Boolean)ProjectEConfig.server.items.disableAllRadiusMining.get()).booleanValue() || !(living instanceof PlayerEntity)) {
            return;
        }
        byte mode = ToolHelper.getMode(stack);
        if (mode == 0) {
            return;
        }
        PlayerEntity player = (PlayerEntity)living;
        RayTraceResult mop = tracePointer.rayTrace(world, player, RayTraceContext.FluidMode.NONE);
        if (!(mop instanceof BlockRayTraceResult)) {
            return;
        }
        BlockRayTraceResult rayTraceResult = (BlockRayTraceResult)mop;
        if (rayTraceResult.func_216346_c() == RayTraceResult.Type.MISS || !pos.equals((Object)rayTraceResult.func_216350_a())) {
            return;
        }
        Direction sideHit = rayTraceResult.func_216354_b();
        AxisAlignedBB box = new AxisAlignedBB(pos, pos);
        switch (mode) {
            case 1: {
                box = new AxisAlignedBB(pos.func_177977_b(), pos.func_177984_a());
                break;
            }
            case 2: {
                switch (sideHit.func_176740_k()) {
                    case X: {
                        box = new AxisAlignedBB(pos.func_177968_d(), pos.func_177978_c());
                        break;
                    }
                    case Y: {
                        switch (player.func_174811_aO().func_176740_k()) {
                            case X: {
                                box = new AxisAlignedBB(pos.func_177968_d(), pos.func_177978_c());
                                break;
                            }
                            case Z: {
                                box = new AxisAlignedBB(pos.func_177976_e(), pos.func_177974_f());
                            }
                        }
                        break;
                    }
                    case Z: {
                        box = new AxisAlignedBB(pos.func_177976_e(), pos.func_177974_f());
                    }
                }
                break;
            }
            case 3: {
                box = new AxisAlignedBB(pos, pos.func_177967_a(sideHit.func_176734_d(), 2));
            }
        }
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (BlockPos digPos : WorldHelper.getPositionsFromBox(box)) {
            BlockState state;
            if (world.func_175623_d(digPos) || (state = world.func_180495_p(digPos)).func_185887_b((IBlockReader)world, digPos) == -1.0f || !stack.func_150998_b(state) || !PlayerHelper.hasBreakPermission((ServerPlayerEntity)player, digPos = digPos.func_185334_h())) continue;
            drops.addAll(Block.func_220077_a((BlockState)state, (ServerWorld)((ServerWorld)world), (BlockPos)digPos, (TileEntity)world.func_175625_s(digPos), (Entity)player, (ItemStack)stack));
            world.func_217377_a(digPos, false);
        }
        WorldHelper.createLootDrop(drops, world, pos);
    }

    public static ActionResultType digAOE(World world, PlayerEntity player, Hand hand, BlockPos pos, Direction sideHit, boolean affectDepth, long emcCost) {
        if (((Boolean)ProjectEConfig.server.items.disableAllRadiusMining.get()).booleanValue()) {
            return ActionResultType.PASS;
        }
        ItemStack stack = player.func_184586_b(hand);
        int charge = ToolHelper.getCharge(stack);
        if (charge == 0) {
            return ActionResultType.PASS;
        }
        AxisAlignedBB box = affectDepth ? WorldHelper.getBroadDeepBox(pos, sideHit, charge) : WorldHelper.getFlatYBox(pos, charge);
        boolean hasAction = false;
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (BlockPos newPos : WorldHelper.getPositionsFromBox(box)) {
            BlockState state;
            if (world.func_175623_d(newPos) || (state = world.func_180495_p(newPos)).func_185887_b((IBlockReader)world, newPos) == -1.0f || !stack.func_150998_b(state)) continue;
            if (world.field_72995_K) {
                return ActionResultType.SUCCESS;
            }
            if (!PlayerHelper.hasBreakPermission((ServerPlayerEntity)player, newPos = newPos.func_185334_h())) continue;
            if (!ItemPE.consumeFuel(player, stack, emcCost, true)) break;
            drops.addAll(Block.func_220077_a((BlockState)state, (ServerWorld)((ServerWorld)world), (BlockPos)newPos, (TileEntity)world.func_175625_s(newPos), (Entity)player, (ItemStack)stack));
            world.func_217377_a(newPos, false);
            hasAction = true;
        }
        if (hasAction) {
            WorldHelper.createLootDrop(drops, world, pos);
            PlayerHelper.swingItem(player, hand);
            player.func_130014_f_().func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), PESounds.DESTRUCT, SoundCategory.PLAYERS, 1.0f, 1.0f);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public static void attackWithCharge(ItemStack stack, LivingEntity damaged, LivingEntity damager, float baseDmg) {
        if (!(damager instanceof PlayerEntity) || damager.func_130014_f_().field_72995_K) {
            return;
        }
        DamageSource dmg = DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)damager));
        int charge = ToolHelper.getCharge(stack);
        float totalDmg = baseDmg;
        if (charge > 0) {
            dmg.func_76348_h();
            totalDmg += (float)charge;
        }
        damaged.func_70097_a(dmg, totalDmg);
    }

    public static void attackAOE(ItemStack stack, PlayerEntity player, boolean slayAll, float damage, long emcCost, Hand hand) {
        World world = player.func_130014_f_();
        if (world.field_72995_K) {
            return;
        }
        int charge = ToolHelper.getCharge(stack);
        List toAttack = world.func_175674_a((Entity)player, player.func_174813_aQ().func_186662_g((double)(2.5f * (float)charge)), slayAll ? SLAY_ALL : SLAY_MOB);
        DamageSource src = DamageSource.func_76365_a((PlayerEntity)player).func_76348_h();
        boolean hasAction = false;
        for (Entity entity : toAttack) {
            if (!ItemPE.consumeFuel(player, stack, emcCost, true)) break;
            entity.func_70097_a(src, damage);
            hasAction = true;
        }
        if (hasAction) {
            world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), PESounds.CHARGE, SoundCategory.PLAYERS, 1.0f, 1.0f);
            PlayerHelper.swingItem(player, hand);
        }
    }

    public static ActionResultType shearBlock(ItemStack stack, BlockPos pos, PlayerEntity player) {
        List drops;
        IShearable target;
        World world = player.func_130014_f_();
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block instanceof IShearable && (target = (IShearable)block).isShearable(stack, (IWorldReader)world, pos) && (world.field_72995_K || PlayerHelper.hasBreakPermission((ServerPlayerEntity)player, pos)) && !(drops = target.onSheared(stack, (IWorld)world, pos, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack))).isEmpty()) {
            if (!world.field_72995_K) {
                WorldHelper.createLootDrop(drops, world, pos);
                player.func_71064_a(Stats.field_188065_ae.func_199076_b((Object)block), 1);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public static ActionResultType shearEntityAOE(PlayerEntity player, Hand hand, long emcCost) {
        World world = player.func_130014_f_();
        ItemStack stack = player.func_184586_b(hand);
        int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
        int offset = (int)Math.pow(2.0, 2 + ToolHelper.getCharge(stack));
        List list = world.func_175647_a(Entity.class, player.func_174813_aQ().func_72314_b((double)offset, (double)offset / 2.0, (double)offset), SHEARABLE);
        boolean hasAction = false;
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (Entity ent : list) {
            Entity e;
            BlockPos entityPosition;
            IShearable target = (IShearable)ent;
            if (target.isShearable(stack, (IWorldReader)world, entityPosition = ent.func_180425_c())) {
                if (world.field_72995_K) {
                    return ActionResultType.SUCCESS;
                }
                if (!ItemPE.consumeFuel(player, stack, emcCost, true)) break;
                List entDrops = target.onSheared(stack, (IWorld)world, entityPosition, fortune);
                if (!entDrops.isEmpty()) {
                    drops.addAll(entDrops);
                    drops.addAll(entDrops);
                }
                hasAction = true;
            }
            if (world.field_72995_K || !(Math.random() < 0.01) || (e = ent.func_200600_R().func_200721_a(world)) == null) continue;
            e.func_70107_b(ent.func_226277_ct_(), ent.func_226278_cu_(), ent.func_226281_cx_());
            if (e instanceof MobEntity) {
                ((MobEntity)e).func_213386_a((IWorld)world, world.func_175649_E(entityPosition), SpawnReason.EVENT, null, null);
            }
            if (e instanceof SheepEntity) {
                ((SheepEntity)e).func_175512_b(DyeColor.func_196056_a((int)MathUtils.randomIntInRange(0, 15)));
            }
            if (e instanceof AgeableEntity) {
                ((AgeableEntity)e).func_70873_a(-24000);
            }
            world.func_217376_c(e);
        }
        if (hasAction) {
            WorldHelper.createLootDrop(drops, world, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
            PlayerHelper.swingItem(player, hand);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public static ActionResultType tryVeinMine(Hand hand, PlayerEntity player, BlockPos pos, Direction sideHit) {
        if (((Boolean)ProjectEConfig.server.items.disableAllRadiusMining.get()).booleanValue()) {
            return ActionResultType.PASS;
        }
        World world = player.func_130014_f_();
        ItemStack stack = player.func_184586_b(hand);
        BlockState target = world.func_180495_p(pos);
        if (target.func_185887_b((IBlockReader)world, pos) <= -1.0f || !stack.func_150998_b(target)) {
            return ActionResultType.FAIL;
        }
        boolean hasAction = false;
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (BlockPos newPos : WorldHelper.getPositionsFromBox(WorldHelper.getBroadDeepBox(pos, sideHit, ToolHelper.getCharge(stack)))) {
            if (world.func_175623_d(newPos)) continue;
            BlockState state = world.func_180495_p(newPos);
            if (target.func_177230_c() != state.func_177230_c()) continue;
            if (world.field_72995_K) {
                return ActionResultType.SUCCESS;
            }
            if (WorldHelper.harvestVein(world, player, stack, newPos.func_185334_h(), state.func_177230_c(), drops, 0) <= 0) continue;
            hasAction = true;
        }
        if (hasAction) {
            WorldHelper.createLootDrop(drops, world, pos);
            world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), PESounds.DESTRUCT, SoundCategory.PLAYERS, 1.0f, 1.0f);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public static ActionResultType mineOreVeinsInAOE(PlayerEntity player, Hand hand) {
        if (((Boolean)ProjectEConfig.server.items.disableAllRadiusMining.get()).booleanValue()) {
            return ActionResultType.PASS;
        }
        World world = player.func_130014_f_();
        ItemStack stack = player.func_184586_b(hand);
        boolean hasAction = false;
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (BlockPos pos : WorldHelper.getPositionsFromBox(player.func_174813_aQ().func_186662_g((double)(ToolHelper.getCharge(stack) + 3)))) {
            BlockState state;
            if (world.func_175623_d(pos) || !ItemHelper.isOre(state = world.func_180495_p(pos)) || state.func_185887_b((IBlockReader)world, pos) == -1.0f || !stack.func_150998_b(state)) continue;
            if (world.field_72995_K) {
                return ActionResultType.SUCCESS;
            }
            if (WorldHelper.harvestVein(world, player, stack, pos.func_185334_h(), state.func_177230_c(), drops, 0) <= 0) continue;
            hasAction = true;
        }
        if (hasAction) {
            WorldHelper.createLootDrop(drops, world, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
            PlayerHelper.swingItem(player, hand);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public static float getDestroySpeed(float parentDestroySpeed, EnumMatterType matterType, int charge) {
        if (parentDestroySpeed == 1.0f) {
            return parentDestroySpeed;
        }
        return parentDestroySpeed + matterType.getChargeModifier() * (float)charge;
    }

    public static boolean canMatterMine(EnumMatterType matterType, Block block) {
        return block instanceof IMatterBlock && ((IMatterBlock)block).getMatterType().getMatterTier() <= matterType.getMatterTier();
    }

    private static int getCharge(ItemStack stack) {
        return LazyOptionalHelper.toOptional(stack.getCapability(ProjectEAPI.CHARGE_ITEM_CAPABILITY)).map(itemCharge -> itemCharge.getCharge(stack)).orElse(0);
    }

    private static byte getMode(ItemStack stack) {
        return LazyOptionalHelper.toOptional(stack.getCapability(ProjectEAPI.MODE_CHANGER_ITEM_CAPABILITY)).map(itemMode -> itemMode.getMode(stack)).orElse((byte)0);
    }

    public static interface ActionSupplier
    extends Supplier<ActionResultType> {
    }

    @FunctionalInterface
    public static interface RayTracePointer {
        public RayTraceResult rayTrace(World var1, PlayerEntity var2, RayTraceContext.FluidMode var3);
    }
}

