/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.utils;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import moze_intel.projecte.api.imc.WorldTransmutationEntry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fml.InterModComms;

public final class WorldTransmutations {
    private static List<WorldTransmutationEntry> DEFAULT_ENTRIES = Collections.emptyList();
    private static List<WorldTransmutationEntry> ENTRIES = Collections.emptyList();

    public static void init() {
        WorldTransmutations.registerDefault(Blocks.field_150348_b, Blocks.field_150347_e, Blocks.field_196658_i);
        WorldTransmutations.registerDefault(Blocks.field_150347_e, Blocks.field_150348_b, Blocks.field_196658_i);
        WorldTransmutations.registerDefault(Blocks.field_196658_i, Blocks.field_150354_m, Blocks.field_150347_e);
        WorldTransmutations.registerDefault(Blocks.field_150346_d, Blocks.field_150354_m, Blocks.field_150347_e);
        WorldTransmutations.registerDefault(Blocks.field_150354_m, Blocks.field_196658_i, Blocks.field_150347_e);
        WorldTransmutations.registerDefault(Blocks.field_150351_n, Blocks.field_150322_A, null);
        WorldTransmutations.registerDefault(Blocks.field_150322_A, Blocks.field_150351_n, null);
        WorldTransmutations.registerDefault(Blocks.field_150355_j, Blocks.field_150432_aD, null);
        WorldTransmutations.registerDefault(Blocks.field_150432_aD, Blocks.field_150355_j, null);
        WorldTransmutations.registerDefault(Blocks.field_150353_l, Blocks.field_150343_Z, null);
        WorldTransmutations.registerDefault(Blocks.field_150343_Z, Blocks.field_150353_l, null);
        WorldTransmutations.registerDefault(Blocks.field_150440_ba, Blocks.field_150423_aK, null);
        WorldTransmutations.registerDefault(Blocks.field_150423_aK, Blocks.field_150440_ba, null);
        WorldTransmutations.registerDefault(Blocks.field_196650_c, Blocks.field_196654_e, Blocks.field_196656_g);
        WorldTransmutations.registerDefault(Blocks.field_196654_e, Blocks.field_196656_g, Blocks.field_196650_c);
        WorldTransmutations.registerDefault(Blocks.field_196656_g, Blocks.field_196650_c, Blocks.field_196654_e);
        Block[] logs = new Block[]{Blocks.field_196617_K, Blocks.field_196619_M, Blocks.field_196618_L, Blocks.field_196620_N, Blocks.field_196621_O, Blocks.field_196623_P};
        WorldTransmutations.registerConsecutivePairs(logs);
        Block[] leaves = new Block[]{Blocks.field_196642_W, Blocks.field_196647_Y, Blocks.field_196645_X, Blocks.field_196648_Z, Blocks.field_196572_aa, Blocks.field_196574_ab};
        WorldTransmutations.registerConsecutivePairs(leaves);
        Block[] saplings = new Block[]{Blocks.field_196674_t, Blocks.field_196676_v, Blocks.field_196675_u, Blocks.field_196678_w, Blocks.field_196679_x, Blocks.field_196680_y};
        WorldTransmutations.registerConsecutivePairs(saplings);
        Block[] wools = new Block[]{Blocks.field_196556_aL, Blocks.field_196557_aM, Blocks.field_196558_aN, Blocks.field_196559_aO, Blocks.field_196560_aP, Blocks.field_196561_aQ, Blocks.field_196562_aR, Blocks.field_196563_aS, Blocks.field_196564_aT, Blocks.field_196565_aU, Blocks.field_196566_aV, Blocks.field_196567_aW, Blocks.field_196568_aX, Blocks.field_196569_aY, Blocks.field_196570_aZ, Blocks.field_196602_ba};
        WorldTransmutations.registerConsecutivePairs(wools);
        Block[] terracottas = new Block[]{Blocks.field_196777_fo, Blocks.field_196778_fp, Blocks.field_196780_fq, Blocks.field_196782_fr, Blocks.field_196783_fs, Blocks.field_196785_ft, Blocks.field_196787_fu, Blocks.field_196789_fv, Blocks.field_196791_fw, Blocks.field_196793_fx, Blocks.field_196795_fy, Blocks.field_196797_fz, Blocks.field_196719_fA, Blocks.field_196720_fB, Blocks.field_196721_fC, Blocks.field_196722_fD};
        WorldTransmutations.registerConsecutivePairs(terracottas);
        Block[] carpets = new Block[]{Blocks.field_196724_fH, Blocks.field_196725_fI, Blocks.field_196727_fJ, Blocks.field_196729_fK, Blocks.field_196731_fL, Blocks.field_196733_fM, Blocks.field_196735_fN, Blocks.field_196737_fO, Blocks.field_196739_fP, Blocks.field_196741_fQ, Blocks.field_196743_fR, Blocks.field_196745_fS, Blocks.field_196747_fT, Blocks.field_196749_fU, Blocks.field_196751_fV, Blocks.field_196753_fW};
        WorldTransmutations.registerConsecutivePairs(carpets);
    }

    public static BlockState getWorldTransmutation(IBlockReader world, BlockPos pos, boolean isSneaking) {
        return WorldTransmutations.getWorldTransmutation(world.func_180495_p(pos), isSneaking);
    }

    public static BlockState getWorldTransmutation(BlockState current, boolean isSneaking) {
        for (WorldTransmutationEntry e : ENTRIES) {
            if (e.getOrigin() != current) continue;
            return isSneaking ? e.getAltResult() : e.getResult();
        }
        return null;
    }

    public static List<WorldTransmutationEntry> getWorldTransmutations() {
        return ENTRIES;
    }

    public static void setWorldTransmutation(List<WorldTransmutationEntry> entries) {
        DEFAULT_ENTRIES = ImmutableList.copyOf(entries);
        WorldTransmutations.resetWorldTransmutations();
    }

    public static void resetWorldTransmutations() {
        ENTRIES = new ArrayList<WorldTransmutationEntry>(DEFAULT_ENTRIES);
    }

    public static void register(BlockState from, BlockState result, @Nullable BlockState altResult) {
        ENTRIES.add(new WorldTransmutationEntry(from, result, altResult));
    }

    private static void registerDefault(Block from, Block result, Block altResult) {
        InterModComms.sendTo((String)"projecte", (String)"register_world_transmutation", () -> new WorldTransmutationEntry(from.func_176223_P(), result.func_176223_P(), altResult == null ? null : altResult.func_176223_P()));
    }

    private static void registerConsecutivePairs(Block[] blocks) {
        for (int i = 0; i < blocks.length; ++i) {
            Block prev = i == 0 ? blocks[blocks.length - 1] : blocks[i - 1];
            Block cur = blocks[i];
            Block next = i == blocks.length - 1 ? blocks[0] : blocks[i + 1];
            WorldTransmutations.registerDefault(cur, next, prev);
        }
    }
}

