/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import moze_intel.projecte.api.item.IPedestalItem;
import moze_intel.projecte.api.item.IProjectileShooter;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.entity.EntityLavaProjectile;
import moze_intel.projecte.gameObjs.items.IFireProtector;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.gameObjs.tiles.DMPedestalTile;
import moze_intel.projecte.utils.ClientKeyHelper;
import moze_intel.projecte.utils.FluidHelper;
import moze_intel.projecte.utils.MathUtils;
import moze_intel.projecte.utils.PEKeybind;
import moze_intel.projecte.utils.PlayerHelper;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidHandler;

@Optional.Interface(iface="baubles.api.IBauble", modid="Baubles")
public class VolcaniteAmulet
extends ItemPE
implements IProjectileShooter,
IBauble,
IPedestalItem,
IFireProtector {
    public VolcaniteAmulet() {
        this.func_77655_b("volcanite_amulet");
        this.func_77625_d(1);
        this.func_77642_a(this);
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int sideHit, float f1, float f2, float f3) {
        IFluidHandler tank;
        TileEntity tile;
        if (!world.field_72995_K && PlayerHelper.hasEditPermission((EntityPlayerMP)player, x, y, z) && (tile = world.func_147438_o(x, y, z)) instanceof IFluidHandler && FluidHelper.canFillTank(tank = (IFluidHandler)tile, FluidRegistry.LAVA, sideHit) && VolcaniteAmulet.consumeFuel(player, stack, 32.0, true)) {
            FluidHelper.fillTank(tank, FluidRegistry.LAVA, sideHit, 1000);
            return true;
        }
        return false;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        int k;
        int j;
        int i;
        MovingObjectPosition mop;
        if (!world.field_72995_K && (mop = this.func_77621_a(world, player, false)) != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && !(world.func_147438_o(i = mop.field_72311_b, j = mop.field_72312_c, k = mop.field_72309_d) instanceof IFluidHandler)) {
            switch (mop.field_72310_e) {
                case 0: {
                    --j;
                    break;
                }
                case 1: {
                    ++j;
                    break;
                }
                case 2: {
                    --k;
                    break;
                }
                case 3: {
                    ++k;
                    break;
                }
                case 4: {
                    --i;
                    break;
                }
                case 5: {
                    ++i;
                    break;
                }
            }
            if (world.func_147437_c(i, j, k) && VolcaniteAmulet.consumeFuel(player, stack, 32.0, true)) {
                this.placeLava(world, player, i, j, k);
                world.func_72956_a((Entity)player, "projecte:item.petransmute", 1.0f, 1.0f);
                PlayerHelper.swingItem(player);
            }
        }
        return stack;
    }

    private void placeLava(World world, EntityPlayer player, int i, int j, int k) {
        PlayerHelper.checkedPlaceBlock((EntityPlayerMP)player, i, j, k, (Block)Blocks.field_150356_k, 0);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int invSlot, boolean par5) {
        int z;
        int y;
        if (invSlot > 8 || !(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        int x = (int)Math.floor(player.field_70165_t);
        if ((world.func_147439_a(x, (y = (int)(player.field_70163_u - player.func_70033_W())) - 1, z = (int)Math.floor(player.field_70161_v)) == Blocks.field_150353_l || world.func_147439_a(x, y - 1, z) == Blocks.field_150356_k) && world.func_147439_a(x, y, z) == Blocks.field_150350_a) {
            if (!player.func_70093_af()) {
                player.field_70181_x = 0.0;
                player.field_70143_R = 0.0f;
                player.field_70122_E = true;
            }
            if (!world.field_72995_K && player.field_71075_bZ.func_75094_b() < 0.25f) {
                PlayerHelper.setPlayerWalkSpeed(player, 0.25f);
            }
        } else if (!world.field_72995_K && player.field_71075_bZ.func_75094_b() != 0.1f) {
            PlayerHelper.setPlayerWalkSpeed(player, 0.1f);
        }
    }

    public boolean func_77630_h(ItemStack stack) {
        return false;
    }

    @Override
    public boolean shootProjectile(EntityPlayer player, ItemStack stack) {
        player.field_70170_p.func_72956_a((Entity)player, "projecte:item.petransmute", 1.0f, 1.0f);
        player.field_70170_p.func_72838_d((Entity)new EntityLavaProjectile(player.field_70170_p, player));
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.field_77791_bV = register.func_94245_a(this.getTexture("rings", "volcanite_amulet"));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        list.add(String.format(StatCollector.func_74838_a((String)"pe.volcanite.tooltip1"), ClientKeyHelper.getKeyName(PEKeybind.FIRE_PROJECTILE)));
        list.add(StatCollector.func_74838_a((String)"pe.volcanite.tooltip2"));
        list.add(StatCollector.func_74838_a((String)"pe.volcanite.tooltip3"));
        list.add(StatCollector.func_74838_a((String)"pe.volcanite.tooltip4"));
    }

    @Optional.Method(modid="Baubles")
    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.AMULET;
    }

    @Optional.Method(modid="Baubles")
    public void onWornTick(ItemStack stack, EntityLivingBase ent) {
        int z;
        int y;
        if (!(ent instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)ent;
        World world = player.field_70170_p;
        int x = (int)Math.floor(player.field_70165_t);
        if ((world.func_147439_a(x, (y = (int)(player.field_70163_u - player.func_70033_W())) - 1, z = (int)Math.floor(player.field_70161_v)) == Blocks.field_150353_l || world.func_147439_a(x, y - 1, z) == Blocks.field_150356_k) && world.func_147439_a(x, y, z) == Blocks.field_150350_a) {
            if (!player.func_70093_af()) {
                player.field_70181_x = 0.0;
                player.field_70143_R = 0.0f;
                player.field_70122_E = true;
            }
            if (!world.field_72995_K && player.field_71075_bZ.func_75094_b() < 0.25f) {
                PlayerHelper.setPlayerWalkSpeed(player, 0.25f);
            }
        } else if (!world.field_72995_K && player.field_71075_bZ.func_75094_b() != 0.1f) {
            PlayerHelper.setPlayerWalkSpeed(player, 0.1f);
        }
    }

    @Optional.Method(modid="Baubles")
    public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
    }

    @Optional.Method(modid="Baubles")
    public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
    }

    @Optional.Method(modid="Baubles")
    public boolean canEquip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Optional.Method(modid="Baubles")
    public boolean canUnequip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Override
    public void updateInPedestal(World world, int x, int y, int z) {
        if (!world.field_72995_K && ProjectEConfig.volcanitePedCooldown != -1) {
            DMPedestalTile tile = (DMPedestalTile)world.func_147438_o(x, y, z);
            if (tile.getActivityCooldown() == 0) {
                world.func_72912_H().func_76080_g(0);
                world.func_72912_H().func_76090_f(0);
                world.func_72912_H().func_76084_b(false);
                world.func_72912_H().func_76069_a(false);
                tile.setActivityCooldown(ProjectEConfig.volcanitePedCooldown);
            } else {
                tile.decrementActivityCooldown();
            }
        }
    }

    @Override
    public List<String> getPedestalDescription() {
        ArrayList list = Lists.newArrayList();
        if (ProjectEConfig.volcanitePedCooldown != -1) {
            list.add(EnumChatFormatting.BLUE + StatCollector.func_74838_a((String)"pe.volcanite.pedestal1"));
            list.add(EnumChatFormatting.BLUE + String.format(StatCollector.func_74838_a((String)"pe.volcanite.pedestal2"), MathUtils.tickToSecFormatted(ProjectEConfig.volcanitePedCooldown)));
        }
        return list;
    }

    @Override
    public boolean canProtectAgainstFire(ItemStack stack, EntityPlayerMP player) {
        return true;
    }
}

