/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.events;

import com.google.common.math.LongMath;
import java.util.List;
import moze_intel.projecte.api.item.IItemEmc;
import moze_intel.projecte.api.item.IPedestalItem;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.ObjHandler;
import moze_intel.projecte.gameObjs.gui.GUIPedestal;
import moze_intel.projecte.utils.Constants;
import moze_intel.projecte.utils.EMCHelper;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

@SideOnly(value=Side.CLIENT)
public class ToolTipEvent {
    @SubscribeEvent
    public void tTipEvent(ItemTooltipEvent event) {
        ItemStack current = event.itemStack;
        Item currentItem = current.func_77973_b();
        Block currentBlock = Block.func_149634_a((Item)currentItem);
        if (current == null) {
            return;
        }
        if (currentBlock == ObjHandler.dmPedestal) {
            event.toolTip.add(StatCollector.func_74838_a((String)"pe.pedestal.tooltip1"));
            event.toolTip.add(StatCollector.func_74838_a((String)"pe.pedestal.tooltip2"));
        }
        if (currentItem == ObjHandler.manual) {
            event.toolTip.add(StatCollector.func_74838_a((String)"pe.manual.tooltip1"));
        }
        if (ProjectEConfig.showPedestalTooltip && currentItem instanceof IPedestalItem) {
            List<String> description;
            if (ProjectEConfig.showPedestalTooltipInGUI) {
                if (Minecraft.func_71410_x().field_71462_r instanceof GUIPedestal) {
                    event.toolTip.add(EnumChatFormatting.DARK_PURPLE + StatCollector.func_74838_a((String)"pe.pedestal.on_pedestal") + " ");
                    description = ((IPedestalItem)currentItem).getPedestalDescription();
                    if (description.isEmpty()) {
                        event.toolTip.add(IPedestalItem.TOOLTIPDISABLED);
                    } else {
                        event.toolTip.addAll(((IPedestalItem)currentItem).getPedestalDescription());
                    }
                }
            } else {
                event.toolTip.add(EnumChatFormatting.DARK_PURPLE + StatCollector.func_74838_a((String)"pe.pedestal.on_pedestal") + " ");
                description = ((IPedestalItem)currentItem).getPedestalDescription();
                if (description.isEmpty()) {
                    event.toolTip.add(IPedestalItem.TOOLTIPDISABLED);
                } else {
                    event.toolTip.addAll(((IPedestalItem)currentItem).getPedestalDescription());
                }
            }
        }
        if (ProjectEConfig.showUnlocalizedNames) {
            event.toolTip.add("UN: " + Item.field_150901_e.func_177774_c((Object)current.func_77973_b()));
        }
        if (ProjectEConfig.showODNames) {
            for (int id : OreDictionary.getOreIDs((ItemStack)current)) {
                event.toolTip.add("OD: " + OreDictionary.getOreName((int)id));
            }
            if (currentBlock instanceof BlockFluidBase) {
                event.toolTip.add("Fluid: " + ((BlockFluidBase)currentBlock).getFluid().getName());
            }
        }
        if (ProjectEConfig.showEMCTooltip && EMCHelper.doesItemHaveEmc(current)) {
            int value = EMCHelper.getEmcValue(current);
            event.toolTip.add(EnumChatFormatting.YELLOW + StatCollector.func_74838_a((String)"pe.emc.emc_tooltip_prefix") + " " + EnumChatFormatting.WHITE + String.format("%,d", value));
            if (current.field_77994_a > 1) {
                long total;
                try {
                    total = LongMath.checkedMultiply((long)value, (long)current.field_77994_a);
                }
                catch (ArithmeticException e) {
                    total = Long.MAX_VALUE;
                }
                if (total < 0L || total <= (long)value || total > Integer.MAX_VALUE) {
                    event.toolTip.add(EnumChatFormatting.YELLOW + StatCollector.func_74838_a((String)"pe.emc.stackemc_tooltip_prefix") + " " + EnumChatFormatting.OBFUSCATED + StatCollector.func_74838_a((String)"pe.emc.too_much"));
                } else {
                    event.toolTip.add(EnumChatFormatting.YELLOW + StatCollector.func_74838_a((String)"pe.emc.stackemc_tooltip_prefix") + " " + EnumChatFormatting.WHITE + String.format("%,d", value * current.field_77994_a));
                }
            }
        }
        if (ProjectEConfig.showStatTooltip) {
            String unit = StatCollector.func_74838_a((String)"pe.emc.name");
            String rate = StatCollector.func_74838_a((String)"pe.emc.rate");
            if (currentBlock == ObjHandler.energyCollector) {
                event.toolTip.add(EnumChatFormatting.DARK_PURPLE + String.format(StatCollector.func_74838_a((String)"pe.emc.maxgenrate_tooltip") + EnumChatFormatting.BLUE + " %d " + rate, 4));
                event.toolTip.add(EnumChatFormatting.DARK_PURPLE + String.format(StatCollector.func_74838_a((String)"pe.emc.maxstorage_tooltip") + EnumChatFormatting.BLUE + " %d " + unit, 10000));
            }
            if (currentBlock == ObjHandler.collectorMK2) {
                event.toolTip.add(EnumChatFormatting.DARK_PURPLE + String.format(StatCollector.func_74838_a((String)"pe.emc.maxgenrate_tooltip") + EnumChatFormatting.BLUE + " %d " + rate, 12));
                event.toolTip.add(EnumChatFormatting.DARK_PURPLE + String.format(StatCollector.func_74838_a((String)"pe.emc.maxstorage_tooltip") + EnumChatFormatting.BLUE + " %d " + unit, 30000));
            }
            if (currentBlock == ObjHandler.collectorMK3) {
                event.toolTip.add(EnumChatFormatting.DARK_PURPLE + String.format(StatCollector.func_74838_a((String)"pe.emc.maxgenrate_tooltip") + EnumChatFormatting.BLUE + " %d " + rate, 40));
                event.toolTip.add(EnumChatFormatting.DARK_PURPLE + String.format(StatCollector.func_74838_a((String)"pe.emc.maxstorage_tooltip") + EnumChatFormatting.BLUE + " %d " + unit, 60000));
            }
            if (currentBlock == ObjHandler.relay) {
                event.toolTip.add(EnumChatFormatting.DARK_PURPLE + String.format(StatCollector.func_74838_a((String)"pe.emc.maxoutrate_tooltip") + EnumChatFormatting.BLUE + " %d " + rate, 64));
                event.toolTip.add(EnumChatFormatting.DARK_PURPLE + String.format(StatCollector.func_74838_a((String)"pe.emc.maxstorage_tooltip") + EnumChatFormatting.BLUE + " %d " + unit, 100000));
            }
            if (currentBlock == ObjHandler.relayMK2) {
                event.toolTip.add(EnumChatFormatting.DARK_PURPLE + String.format(StatCollector.func_74838_a((String)"pe.emc.maxoutrate_tooltip") + EnumChatFormatting.BLUE + " %d " + rate, 192));
                event.toolTip.add(EnumChatFormatting.DARK_PURPLE + String.format(StatCollector.func_74838_a((String)"pe.emc.maxstorage_tooltip") + EnumChatFormatting.BLUE + " %d " + unit, 1000000));
            }
            if (currentBlock == ObjHandler.relayMK3) {
                event.toolTip.add(EnumChatFormatting.DARK_PURPLE + String.format(StatCollector.func_74838_a((String)"pe.emc.maxoutrate_tooltip") + EnumChatFormatting.BLUE + " %d " + rate, 640));
                event.toolTip.add(EnumChatFormatting.DARK_PURPLE + String.format(StatCollector.func_74838_a((String)"pe.emc.maxstorage_tooltip") + EnumChatFormatting.BLUE + " %d " + unit, 10000000));
            }
        }
        if (current.func_77942_o()) {
            if (current.func_77978_p().func_74767_n("ProjectEBlock")) {
                event.toolTip.add(EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"pe.misc.wrenched_block"));
                if (current.func_77978_p().func_74769_h("EMC") > 0.0) {
                    event.toolTip.add(EnumChatFormatting.YELLOW + String.format(StatCollector.func_74838_a((String)"pe.emc.storedemc_tooltip") + " " + EnumChatFormatting.RESET + "%,d", (int)current.func_77978_p().func_74769_h("EMC")));
                }
            }
            if (current.func_77973_b() instanceof IItemEmc || current.func_77978_p().func_74764_b("StoredEMC")) {
                double value = 0.0;
                value = current.func_77978_p().func_74764_b("StoredEMC") ? current.func_77978_p().func_74769_h("StoredEMC") : ((IItemEmc)current.func_77973_b()).getStoredEmc(current);
                event.toolTip.add(EnumChatFormatting.YELLOW + StatCollector.func_74838_a((String)"pe.emc.storedemc_tooltip") + " " + EnumChatFormatting.RESET + Constants.EMC_FORMATTER.format(value));
            }
            if (current.func_77978_p().func_74764_b("StoredXP")) {
                event.toolTip.add(String.format(EnumChatFormatting.DARK_GREEN + StatCollector.func_74838_a((String)"pe.misc.storedxp_tooltip") + " " + EnumChatFormatting.GREEN + "%,d", current.func_77978_p().func_74762_e("StoredXP")));
            }
        }
    }
}

