/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.customRecipes;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import moze_intel.projecte.gameObjs.ObjHandler;
import moze_intel.projecte.gameObjs.items.KleinStar;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.oredict.OreDictionary;

public class RecipeShapelessHidden
implements IRecipe {
    protected ItemStack output = null;
    protected ArrayList<Object> input = new ArrayList();

    public RecipeShapelessHidden(Block result, Object ... recipe) {
        this(new ItemStack(result), recipe);
    }

    public RecipeShapelessHidden(Item result, Object ... recipe) {
        this(new ItemStack(result), recipe);
    }

    public RecipeShapelessHidden(ItemStack result, Object ... recipe) {
        this.output = result.func_77946_l();
        for (Object in : recipe) {
            if (in instanceof ItemStack) {
                this.input.add(((ItemStack)in).func_77946_l());
                continue;
            }
            if (in instanceof Item) {
                this.input.add(new ItemStack((Item)in));
                continue;
            }
            if (in instanceof Block) {
                this.input.add(new ItemStack((Block)in));
                continue;
            }
            if (in instanceof String) {
                this.input.add(OreDictionary.getOres((String)((String)in)));
                continue;
            }
            String ret = "Invalid shapeless ore recipe: ";
            for (Object tmp : recipe) {
                ret = ret + tmp + ", ";
            }
            ret = ret + this.output;
            throw new RuntimeException(ret);
        }
    }

    RecipeShapelessHidden(ShapelessRecipes recipe, Map<ItemStack, String> replacements) {
        this.output = recipe.func_77571_b();
        Iterator i$ = recipe.field_77579_b.iterator();
        while (i$.hasNext()) {
            ItemStack ingred;
            Object finalObj = ingred = (ItemStack)i$.next();
            for (Map.Entry<ItemStack, String> replace : replacements.entrySet()) {
                if (!OreDictionary.itemMatches((ItemStack)replace.getKey(), (ItemStack)ingred, (boolean)false)) continue;
                finalObj = OreDictionary.getOres((String)replace.getValue());
                break;
            }
            this.input.add(finalObj);
        }
    }

    public int func_77570_a() {
        return this.input.size();
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public ItemStack func_77572_b(InventoryCrafting var1) {
        return this.output.func_77946_l();
    }

    public boolean func_77569_a(InventoryCrafting inv, World world) {
        ArrayList<Object> required = new ArrayList<Object>(this.input);
        double storedEMC = 0.0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack == null || stack.func_77973_b() != ObjHandler.kleinStars) continue;
            storedEMC += KleinStar.getEmc(stack);
        }
        if (this.output.func_77973_b() == ObjHandler.kleinStars) {
            if (!this.output.func_77942_o()) {
                this.output.func_77982_d(new NBTTagCompound());
            }
            KleinStar.setEmc(this.output, storedEMC);
        }
        for (int x = 0; x < inv.func_70302_i_(); ++x) {
            ItemStack slot = inv.func_70301_a(x);
            if (slot == null) continue;
            boolean inRecipe = false;
            Iterator<Object> req = required.iterator();
            while (req.hasNext()) {
                boolean match = false;
                Object next = req.next();
                if (next instanceof ItemStack) {
                    match = OreDictionary.itemMatches((ItemStack)((ItemStack)next), (ItemStack)slot, (boolean)false);
                } else if (next instanceof List) {
                    Iterator itr = ((List)next).iterator();
                    while (itr.hasNext() && !match) {
                        match = OreDictionary.itemMatches((ItemStack)((ItemStack)itr.next()), (ItemStack)slot, (boolean)false);
                    }
                }
                if (!match) continue;
                inRecipe = true;
                required.remove(next);
                break;
            }
            if (inRecipe) continue;
            return false;
        }
        return required.isEmpty();
    }

    public ArrayList<Object> getInput() {
        return this.input;
    }

    public ItemStack[] func_179532_b(InventoryCrafting inv) {
        return ForgeHooks.defaultRecipeGetRemainingItems((InventoryCrafting)inv);
    }
}

