/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import moze_intel.projecte.api.item.IModeChanger;
import moze_intel.projecte.api.item.IPedestalItem;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.items.ItemCharge;
import moze_intel.projecte.gameObjs.tiles.DMPedestalTile;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ITickable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.Interface(iface="baubles.api.IBauble", modid="Baubles")
public class TimeWatch
extends ItemCharge
implements IModeChanger,
IBauble,
IPedestalItem {
    private static Set<String> internalBlacklist = Sets.newHashSet((Object[])new String[]{"moze_intel.projecte.gameObjs.tiles.DMPedestalTile", "Reika.ChromatiCraft.TileEntity.AOE.TileEntityAccelerator", "com.sci.torcherino.tile.TileTorcherino", "com.sci.torcherino.tile.TileCompressedTorcherino", "thaumcraft.common.tiles.crafting.TileSmelter"});

    public TimeWatch() {
        super("time_watch", (byte)2);
        this.setNoRepair();
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            byte current;
            if (!ProjectEConfig.enableTimeWatch) {
                player.func_146105_b((IChatComponent)new ChatComponentTranslation("pe.timewatch.disabled", new Object[0]));
                return stack;
            }
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            this.setTimeBoost(stack, (byte)((current = this.getTimeBoost(stack)) == 2 ? 0 : current + 1));
            player.func_146105_b((IChatComponent)new ChatComponentTranslation("pe.timewatch.mode_switch", new Object[]{new ChatComponentTranslation(this.getTimeName(stack), new Object[0]).func_150261_e()}));
        }
        return stack;
    }

    @Override
    public void func_77663_a(ItemStack stack, World world, Entity entity, int invSlot, boolean isHeld) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!(entity instanceof EntityPlayer) || invSlot > 8) {
            return;
        }
        if (!ProjectEConfig.enableTimeWatch) {
            return;
        }
        byte timeControl = this.getTimeBoost(stack);
        if (world.func_82736_K().func_82766_b("doDaylightCycle")) {
            if (timeControl == 1) {
                if (world.func_72820_D() + (long)((this.getCharge(stack) + 1) * 4) > Long.MAX_VALUE) {
                    world.func_72877_b(Long.MAX_VALUE);
                } else {
                    world.func_72877_b(world.func_72820_D() + (long)((this.getCharge(stack) + 1) * 4));
                }
            } else if (timeControl == 2) {
                if (world.func_72820_D() - (long)((this.getCharge(stack) + 1) * 4) < 0L) {
                    world.func_72877_b(0L);
                } else {
                    world.func_72877_b(world.func_72820_D() - (long)((this.getCharge(stack) + 1) * 4));
                }
            }
        }
        if (world.field_72995_K || stack.func_77952_i() == 0) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        double reqEmc = this.getEmcPerTick(this.getCharge(stack));
        if (!TimeWatch.consumeFuel(player, stack, reqEmc, true)) {
            return;
        }
        byte charge = this.getCharge(stack);
        int bonusTicks = 0;
        float mobSlowdown = 0.0f;
        if (charge == 0) {
            bonusTicks = 8;
            mobSlowdown = 0.25f;
        } else if (charge == 1) {
            bonusTicks = 12;
            mobSlowdown = 0.16f;
        } else {
            bonusTicks = 16;
            mobSlowdown = 0.12f;
        }
        AxisAlignedBB bBox = player.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0);
        this.speedUpTileEntities(world, bonusTicks, bBox);
        this.speedUpRandomTicks(world, bonusTicks, bBox);
        this.slowMobs(world, bBox, mobSlowdown);
    }

    private void slowMobs(World world, AxisAlignedBB bBox, float mobSlowdown) {
        if (bBox == null) {
            return;
        }
        for (Object obj : world.func_72872_a(EntityLiving.class, bBox)) {
            Entity ent = (Entity)obj;
            if (ent.field_70159_w != 0.0) {
                ent.field_70159_w *= (double)mobSlowdown;
            }
            if (ent.field_70179_y == 0.0) continue;
            ent.field_70179_y *= (double)mobSlowdown;
        }
    }

    private void speedUpTileEntities(World world, int bonusTicks, AxisAlignedBB bBox) {
        if (bBox == null || bonusTicks == 0) {
            return;
        }
        Iterator<TileEntity> iter = WorldHelper.getTileEntitiesWithinAABB(world, bBox).iterator();
        while (iter.hasNext()) {
            TileEntity tile = iter.next();
            if (internalBlacklist.contains(tile.getClass().getName())) {
                iter.remove();
                continue;
            }
            for (int i = 0; i < bonusTicks; ++i) {
                if (tile.func_145837_r() || !(tile instanceof ITickable)) continue;
                ((ITickable)tile).func_73660_a();
            }
        }
    }

    private void speedUpRandomTicks(World world, int bonusTicks, AxisAlignedBB bBox) {
        if (bBox == null || bonusTicks == 0) {
            return;
        }
        for (BlockPos pos : WorldHelper.getPositionsFromBox(bBox)) {
            IBlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            if (!block.func_149653_t() || block instanceof BlockLiquid || block instanceof BlockFluidBase || block instanceof IGrowable || block instanceof IPlantable) continue;
            for (int i = 0; i < bonusTicks; ++i) {
                block.func_180650_b(world, pos, state, field_77697_d);
            }
        }
    }

    private String getTimeName(ItemStack stack) {
        byte mode = this.getTimeBoost(stack);
        switch (mode) {
            case 0: {
                return "pe.timewatch.off";
            }
            case 1: {
                return "pe.timewatch.ff";
            }
            case 2: {
                return "pe.timewatch.rw";
            }
        }
        return "ERROR_INVALID_MODE";
    }

    private byte getTimeBoost(ItemStack stack) {
        return stack.func_77978_p().func_74771_c("TimeMode");
    }

    private void setTimeBoost(ItemStack stack, byte time) {
        stack.func_77978_p().func_74774_a("TimeMode", (byte)MathHelper.func_76125_a((int)time, (int)0, (int)2));
    }

    public double getEmcPerTick(int charge) {
        int actualCharge = charge + 1;
        return 10.0 * (double)actualCharge / 20.0;
    }

    @Override
    public byte getMode(ItemStack stack) {
        return (byte)stack.func_77952_i();
    }

    @Override
    public void changeMode(EntityPlayer player, ItemStack stack) {
        if (stack.func_77952_i() == 0) {
            stack.func_77964_b(1);
            this.playChargeSound(player);
        } else {
            stack.func_77964_b(0);
            this.playUnChargeSound(player);
        }
    }

    public void playChargeSound(EntityPlayer player) {
        player.field_70170_p.func_72956_a((Entity)player, "projecte:clock", 0.8f, 1.25f);
    }

    public void playUnChargeSound(EntityPlayer player) {
        player.field_70170_p.func_72956_a((Entity)player, "projecte:clock", 0.8f, 0.85f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        list.add(StatCollector.func_74838_a((String)"pe.timewatch.tooltip1"));
        list.add(StatCollector.func_74838_a((String)"pe.timewatch.tooltip2"));
        if (stack.func_77942_o()) {
            list.add(String.format(StatCollector.func_74838_a((String)"pe.timewatch.mode"), StatCollector.func_74838_a((String)this.getTimeName(stack))));
        }
    }

    @Optional.Method(modid="Baubles")
    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.BELT;
    }

    @Optional.Method(modid="Baubles")
    public void onWornTick(ItemStack stack, EntityLivingBase player) {
        this.func_77663_a(stack, player.field_70170_p, (Entity)player, 0, false);
    }

    @Optional.Method(modid="Baubles")
    public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
    }

    @Optional.Method(modid="Baubles")
    public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
    }

    @Optional.Method(modid="Baubles")
    public boolean canEquip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Optional.Method(modid="Baubles")
    public boolean canUnequip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Override
    public void updateInPedestal(World world, BlockPos pos) {
        if (!world.field_72995_K && ProjectEConfig.enableTimeWatch) {
            AxisAlignedBB bBox = ((DMPedestalTile)world.func_175625_s(pos)).getEffectBounds();
            if (ProjectEConfig.timePedBonus > 0) {
                this.speedUpTileEntities(world, ProjectEConfig.timePedBonus, bBox);
                this.speedUpRandomTicks(world, ProjectEConfig.timePedBonus, bBox);
            }
            if (ProjectEConfig.timePedMobSlowness < 1.0f) {
                this.slowMobs(world, bBox, ProjectEConfig.timePedMobSlowness);
            }
        }
    }

    @Override
    public List<String> getPedestalDescription() {
        ArrayList list = Lists.newArrayList();
        if (ProjectEConfig.timePedBonus > 0) {
            list.add(EnumChatFormatting.BLUE + String.format(StatCollector.func_74838_a((String)"pe.timewatch.pedestal1"), ProjectEConfig.timePedBonus));
        }
        if (ProjectEConfig.timePedMobSlowness < 1.0f) {
            list.add(EnumChatFormatting.BLUE + String.format(StatCollector.func_74838_a((String)"pe.timewatch.pedestal2"), Float.valueOf(ProjectEConfig.timePedMobSlowness)));
        }
        return list;
    }

    public static void blacklist(Class<? extends TileEntity> clazz) {
        internalBlacklist.add(clazz.getName());
    }
}

