/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import moze_intel.projecte.PECore;
import moze_intel.projecte.emc.NormalizedSimpleStack;
import moze_intel.projecte.utils.FileHelper;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.PELogger;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public final class CustomEMCParser {
    private static final String VERSION = "#0.2";
    private static File CONFIG;
    private static boolean loaded;
    public static Map<NormalizedSimpleStack, Integer> userValues;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void init() {
        BufferedReader reader;
        block7: {
            CONFIG = new File(PECore.CONFIG_DIR, "custom_emc.cfg");
            loaded = false;
            if (!CONFIG.exists()) {
                try {
                    if (!CONFIG.createNewFile()) return;
                    CustomEMCParser.writeDefaultFile();
                    loaded = true;
                    return;
                }
                catch (IOException e) {
                    PELogger.logFatal("Exception in file I/O: couldn't create custom configuration files.");
                    e.printStackTrace();
                    return;
                }
            }
            reader = null;
            try {
                reader = new BufferedReader(new FileReader(CONFIG));
                String line = reader.readLine();
                if (line != null && line.equals(VERSION)) break block7;
                PELogger.logFatal("Found old custom EMC file: resetting.");
                CustomEMCParser.writeDefaultFile();
            }
            catch (IOException e) {
                try {
                    PELogger.logFatal("Exception in file I/O: couldn't create custom configuration files.");
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    FileHelper.closeStream(reader);
                    throw throwable;
                }
                FileHelper.closeStream(reader);
            }
        }
        FileHelper.closeStream(reader);
        loaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readUserData() {
        if (!loaded) {
            PELogger.logFatal("ERROR: configurations files are not loaded!");
            return;
        }
        LineNumberReader reader = null;
        userValues.clear();
        try {
            Entry entry;
            reader = new LineNumberReader(new FileReader(CONFIG));
            while ((entry = CustomEMCParser.getNextEntry(reader)) != null) {
                if (entry.name.contains(":")) {
                    ItemStack stack = ItemHelper.getStackFromString(entry.name, entry.meta);
                    if (stack == null) {
                        PELogger.logFatal("Error in custom EMC file: couldn't find item: " + entry.name);
                        PELogger.logFatal("At line number: " + reader.getLineNumber());
                        continue;
                    }
                    if (entry.emc <= 0) {
                        PELogger.logInfo("Removed " + entry.name + " from EMC mapping");
                    } else {
                        PELogger.logInfo("Registered custom EMC for: " + entry.name + "(" + entry.emc + ")");
                    }
                    userValues.put(NormalizedSimpleStack.getFor(stack), entry.emc > 0 ? entry.emc : 0);
                    continue;
                }
                if (OreDictionary.getOres((String)entry.name).isEmpty()) {
                    PELogger.logFatal("Error in custom EMC file: no OD entry for " + entry.name);
                    PELogger.logFatal("At line number: " + reader.getLineNumber());
                    continue;
                }
                if (entry.emc <= 0) {
                    PELogger.logInfo("Removed " + entry.name + " from EMC mapping");
                } else {
                    PELogger.logInfo("Registered custom EMC for: " + entry.name + "(" + entry.emc + ")");
                }
                for (ItemStack stack : ItemHelper.getODItems(entry.name)) {
                    userValues.put(NormalizedSimpleStack.getFor(stack), entry.emc > 0 ? entry.emc : 0);
                }
            }
            FileHelper.closeStream(reader);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            FileHelper.closeStream(reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addToFile(String toAdd, int meta, int emc) {
        if (!loaded) {
            PELogger.logFatal("ERROR: configurations files are not loaded!");
            return false;
        }
        PrintWriter writer = null;
        boolean result = false;
        try {
            List<String> file = CustomEMCParser.readAllFile();
            List<Entry> entries = CustomEMCParser.getAllEntries();
            boolean hasFound = false;
            boolean isOD = !toAdd.contains(":");
            for (Entry e : entries) {
                if (!e.name.equals(toAdd) || !isOD && e.meta != meta) continue;
                file.set(e.emcIndex - 1, "E:" + emc);
                hasFound = true;
                break;
            }
            if (hasFound) {
                writer = new PrintWriter(new FileOutputStream(CONFIG, false));
                for (String s : file) {
                    writer.println(s);
                }
                result = true;
            } else {
                writer = new PrintWriter(new FileOutputStream(CONFIG, true));
                writer.append("\n");
                writer.append("S:" + toAdd + "\n");
                if (toAdd.contains(":")) {
                    writer.append("M:" + meta + "\n");
                }
                writer.append("E:" + emc + "\n");
                result = true;
            }
            FileHelper.closeStream(writer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            FileHelper.closeStream(writer);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeFromFile(String toRemove, int meta) {
        if (!loaded) {
            PELogger.logFatal("ERROR: configurations files are not loaded!");
            return false;
        }
        PrintWriter writer = null;
        boolean result = false;
        try {
            List<String> file = CustomEMCParser.readAllFile();
            List<Entry> entries = CustomEMCParser.getAllEntries();
            boolean isOD = !toRemove.contains(":");
            for (Entry e : entries) {
                if (!e.name.equals(toRemove) || !isOD && e.meta != meta) continue;
                file.remove(e.emcIndex - 1);
                if (!isOD) {
                    file.remove(e.metaIndex - 1);
                }
                file.remove(e.nameIndex - 1);
                result = true;
                break;
            }
            if (result) {
                writer = new PrintWriter(new FileOutputStream(CONFIG, false));
                for (String s : file) {
                    writer.println(s);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            FileHelper.closeStream(writer);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> readAllFile() {
        ArrayList list = Lists.newArrayList();
        BufferedReader reader = null;
        try {
            String s;
            reader = new BufferedReader(new FileReader(CONFIG));
            while ((s = reader.readLine()) != null) {
                list.add(s);
            }
            ArrayList arrayList = list;
            FileHelper.closeStream(reader);
            return arrayList;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            FileHelper.closeStream(reader);
        }
        return Lists.newArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Entry> getAllEntries() {
        ArrayList list = Lists.newArrayList();
        LineNumberReader reader = null;
        try {
            Entry e;
            reader = new LineNumberReader(new FileReader(CONFIG));
            while ((e = CustomEMCParser.getNextEntry(reader)) != null) {
                list.add(e);
            }
            ArrayList arrayList = list;
            FileHelper.closeStream(reader);
            return arrayList;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            FileHelper.closeStream(reader);
        }
        return Lists.newArrayList();
    }

    private static Entry getNextEntry(LineNumberReader reader) throws IOException {
        String line;
        while ((line = CustomEMCParser.getNextLine(reader)) != null) {
            if (line.charAt(0) != 'S') continue;
            String name = line.substring(2);
            int nameIndex = reader.getLineNumber();
            line = CustomEMCParser.getNextLine(reader);
            int meta = -1;
            int metaIndex = -1;
            if (name.contains(":")) {
                if (line == null || line.charAt(0) != 'M') continue;
                meta = 0;
                metaIndex = reader.getLineNumber();
                try {
                    meta = Integer.valueOf(line.substring(2));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                    continue;
                }
                line = CustomEMCParser.getNextLine(reader);
            }
            if (line == null || line.charAt(0) != 'E') continue;
            int emc = 0;
            int emcIndex = reader.getLineNumber();
            try {
                emc = Integer.valueOf(line.substring(2));
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                continue;
            }
            return new Entry(name, meta, emc, nameIndex, metaIndex, emcIndex);
        }
        return null;
    }

    private static String getNextLine(LineNumberReader reader) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).isEmpty() || line.length() < 3 || line.charAt(0) == '#' || line.charAt(1) != ':') continue;
            return line;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeDefaultFile() throws IOException {
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(CONFIG);
            writer.println(VERSION);
            writer.println("Custom EMC file");
            writer.println("This file is used for custom EMC registration, it is recommended that you do not modify it manually.");
            writer.println("In game commands are avaliable to set custom values. Type /projecte in game for usage info.");
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                FileHelper.closeStream(writer);
                throw throwable;
            }
            FileHelper.closeStream(writer);
        }
        FileHelper.closeStream(writer);
    }

    static {
        userValues = Maps.newHashMap();
    }

    private static class Entry {
        public String name;
        public int meta;
        public int emc;
        public int nameIndex;
        public int metaIndex;
        public int emcIndex;

        public Entry(String name, int meta, int emc, int nameIndex, int metaIndex, int emcIndex) {
            this.name = name;
            this.meta = meta;
            this.emc = emc;
            this.nameIndex = nameIndex;
            this.metaIndex = metaIndex;
            this.emcIndex = emcIndex;
        }
    }
}

