/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import moze_intel.projecte.emc.collector.IMappingCollector;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.PELogger;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.oredict.OreDictionary;

public abstract class NormalizedSimpleStack {
    public static Map<Integer, Set<Integer>> idWithUsedMetaData = Maps.newHashMap();
    private static Map<String, NormalizedSimpleStack> oreDictStacks = Maps.newHashMap();

    public static NormalizedSimpleStack getFor(int id, int damage) {
        Set<Object> usedMetadata;
        if (id < 0) {
            return null;
        }
        NSSItem normStack = new NSSItem(id, damage);
        if (!idWithUsedMetaData.containsKey(normStack.id)) {
            usedMetadata = Sets.newHashSet();
            idWithUsedMetaData.put(normStack.id, (Set<Integer>)usedMetadata);
        } else {
            usedMetadata = idWithUsedMetaData.get(normStack.id);
        }
        usedMetadata.add(normStack.damage);
        return normStack;
    }

    public static NormalizedSimpleStack getFor(Block block) {
        return NormalizedSimpleStack.getFor(new ItemStack(block));
    }

    public static NormalizedSimpleStack getFor(Item item) {
        return NormalizedSimpleStack.getFor(Item.field_150901_e.func_148757_b((Object)item), 0);
    }

    public static NormalizedSimpleStack getFor(Item item, int meta) {
        return NormalizedSimpleStack.getFor(Item.field_150901_e.func_148757_b((Object)item), meta);
    }

    public static NormalizedSimpleStack getFor(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return null;
        }
        int id = Item.field_150901_e.func_148757_b((Object)stack.func_77973_b());
        if (id < 0) {
            PELogger.logWarn(String.format("Could not get id for stack %s with item %s (Class: %s)", stack, stack.func_77973_b(), stack.func_77973_b().getClass()));
            return null;
        }
        return NormalizedSimpleStack.getFor(id, stack.func_77952_i());
    }

    public static NormalizedSimpleStack getFor(Fluid fluid) {
        return new NSSFluid(fluid);
    }

    public static <V extends Comparable<V>> void addMappings(IMappingCollector<NormalizedSimpleStack, V> mapper) {
        for (Map.Entry<Integer, Set<Integer>> entry : idWithUsedMetaData.entrySet()) {
            entry.getValue().remove(Short.MAX_VALUE);
            entry.getValue().add(0);
            NSSItem stackWildcard = new NSSItem(entry.getKey(), Short.MAX_VALUE);
            for (int metadata : entry.getValue()) {
                mapper.addConversion(1, (NormalizedSimpleStack)stackWildcard, Arrays.asList(new NSSItem(entry.getKey(), metadata)));
            }
        }
        for (Map.Entry<Object, Object> entry : oreDictStacks.entrySet()) {
            NormalizedSimpleStack oreDictStack = (NormalizedSimpleStack)entry.getValue();
            List<ItemStack> list = ItemHelper.getODItems((String)entry.getKey());
            for (ItemStack i : list) {
                mapper.addConversion(1, oreDictStack, Arrays.asList(NormalizedSimpleStack.getFor(i)));
                mapper.addConversion(1, NormalizedSimpleStack.getFor(i), Arrays.asList(oreDictStack));
            }
        }
    }

    public abstract boolean equals(Object var1);

    public abstract String json();

    public static NormalizedSimpleStack forOreDictionary(String oreDictionaryName) {
        if (oreDictStacks.containsKey(oreDictionaryName)) {
            return oreDictStacks.get(oreDictionaryName);
        }
        List list = OreDictionary.getOres((String)oreDictionaryName);
        if (list == null || list.size() == 0) {
            return null;
        }
        NSSOreDictionary nss = new NSSOreDictionary(oreDictionaryName);
        oreDictStacks.put(oreDictionaryName, nss);
        return nss;
    }

    public static NormalizedSimpleStack createFake(String description) {
        return new NSSFake(description);
    }

    public static NormalizedSimpleStack fromSerializedItem(String serializedItem) throws Exception {
        int itemDamage;
        int pipeIndex = serializedItem.lastIndexOf(124);
        if (pipeIndex < 0) {
            throw new IllegalArgumentException(String.format("Cannot parse '%s' as itemstack. Missing | to separate metadata.", serializedItem));
        }
        String itemName = serializedItem.substring(0, pipeIndex);
        String itemDamageString = serializedItem.substring(pipeIndex + 1);
        if (itemDamageString.equals("*")) {
            itemDamage = Short.MAX_VALUE;
        } else {
            try {
                itemDamage = Integer.parseInt(itemDamageString);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("Could not parse '%s' to metadata-integer", itemDamageString), e);
            }
        }
        Object itemObject = Item.field_150901_e.func_82594_a((Object)itemName);
        if (itemObject != null) {
            int id = Item.field_150901_e.func_148757_b(itemObject);
            return NormalizedSimpleStack.getFor(id, itemDamage);
        }
        PELogger.logWarn(String.format("Could not get Item-Object for Item with name: '%s'", itemName));
        return null;
    }

    public static class NSSOreDictionary
    extends NormalizedSimpleStack {
        public final String od;

        private NSSOreDictionary(String od) {
            this.od = od;
        }

        public int hashCode() {
            return this.od.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof NSSOreDictionary) {
                return this.od.equals(((NSSOreDictionary)o).od);
            }
            return false;
        }

        @Override
        public String json() {
            return "OD|" + this.od;
        }

        public String toString() {
            return "OD: " + this.od;
        }
    }

    public static class NSSFluid
    extends NormalizedSimpleStack {
        public final String name;

        private NSSFluid(Fluid f) {
            this.name = f.getName();
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof NSSFluid) {
                return this.name.equals(((NSSFluid)o).name);
            }
            return false;
        }

        @Override
        public String json() {
            return "FLUID|" + this.name;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return "Fluid: " + this.name;
        }
    }

    public static class NSSFake
    extends NormalizedSimpleStack {
        public final String description;
        public final int counter = fakeItemCounter++;
        private static int fakeItemCounter = 0;

        public NSSFake(String description) {
            this.description = description;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof NSSFake) {
                return o == this;
            }
            return false;
        }

        @Override
        public String json() {
            return "FAKE|" + this.counter + " " + this.description;
        }

        public String toString() {
            return "NSSFAKE" + this.counter + ": " + this.description;
        }
    }

    public static class NSSItem
    extends NormalizedSimpleStack {
        public int id;
        public int damage;

        private NSSItem(int id, int damage) {
            this.id = id;
            if (this.id == -1) {
                throw new IllegalArgumentException("Invalid Item with getIDForObject() == -1");
            }
            this.damage = damage;
        }

        public ItemStack toItemStack() {
            Item item = Item.func_150899_d((int)this.id);
            if (item != null) {
                return new ItemStack(Item.func_150899_d((int)this.id), 1, this.damage);
            }
            return null;
        }

        public NormalizedSimpleStack copy() {
            return new NSSItem(this.id, this.damage);
        }

        public int hashCode() {
            return this.id;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof NSSItem) {
                NSSItem other = (NSSItem)obj;
                return this.id == other.id && this.damage == other.damage;
            }
            return false;
        }

        @Override
        public String json() {
            Object obj = Item.field_150901_e.func_148754_a(this.id);
            if (obj != null) {
                return String.format("%s|%s", Item.field_150901_e.func_177774_c(obj), this.damage == Short.MAX_VALUE ? "*" : Integer.valueOf(this.damage));
            }
            throw new IllegalArgumentException("Cannot get json Representation for  " + this.toString());
        }

        public String toString() {
            Object obj = Item.field_150901_e.func_148754_a(this.id);
            if (obj != null) {
                return String.format("%s(%s:%s)", Item.field_150901_e.func_177774_c(obj), this.id, this.damage == Short.MAX_VALUE ? "*" : Integer.valueOf(this.damage));
            }
            return "id:" + this.id + " damage:" + (this.damage == Short.MAX_VALUE ? "*" : Integer.valueOf(this.damage));
        }
    }
}

