/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.mappers;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import moze_intel.projecte.emc.NormalizedSimpleStack;
import moze_intel.projecte.emc.collector.IMappingCollector;
import moze_intel.projecte.emc.mappers.IEMCMapper;
import moze_intel.projecte.impl.ConversionProxyImpl;
import moze_intel.projecte.utils.PELogger;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public class APICustomEMCMapper
implements IEMCMapper<NormalizedSimpleStack, Integer> {
    public static APICustomEMCMapper instance = new APICustomEMCMapper();
    public static final int PRIORITY_MIN_VALUE = 0;
    public static final int PRIORITY_MAX_VALUE = 512;
    public static final int PRIORITY_DEFAULT_VALUE = 1;
    Map<String, Map<String, Integer>> customEMCforMod = new HashMap<String, Map<String, Integer>>();
    Map<String, Map<NormalizedSimpleStack, Integer>> customNonItemEMCforMod = Maps.newHashMap();

    private APICustomEMCMapper() {
    }

    public void registerCustomEMC(ItemStack stack, int emcValue) {
        Map<Object, Object> modMap;
        ModContainer activeMod;
        String modId;
        if (stack == null || stack.func_77973_b() == null) {
            return;
        }
        if (emcValue < 0) {
            emcValue = 0;
        }
        String string = modId = (activeMod = Loader.instance().activeModContainer()) == null ? null : activeMod.getModId();
        if (this.customEMCforMod.containsKey(modId)) {
            modMap = this.customEMCforMod.get(modId);
        } else {
            modMap = new HashMap();
            this.customEMCforMod.put(modId, modMap);
        }
        modMap.put(this.serializeToString(stack), emcValue);
    }

    public void registerCustomEMC(Object o, int emcValue) {
        Map<Object, Object> modMap;
        ModContainer activeMod;
        String modId;
        NormalizedSimpleStack stack = ConversionProxyImpl.instance.objectToNSS(o);
        if (stack == null) {
            return;
        }
        if (emcValue < 0) {
            emcValue = 0;
        }
        String string = modId = (activeMod = Loader.instance().activeModContainer()) == null ? null : activeMod.getModId();
        if (this.customNonItemEMCforMod.containsKey(modId)) {
            modMap = this.customNonItemEMCforMod.get(modId);
        } else {
            modMap = Maps.newHashMap();
            this.customNonItemEMCforMod.put(modId, (Map<NormalizedSimpleStack, Integer>)modMap);
        }
        modMap.put(stack, emcValue);
    }

    protected String serializeToString(ItemStack stack) {
        String name = (String)Item.field_150901_e.func_177774_c((Object)stack.func_77973_b());
        return String.format("%d@%s", stack.func_77952_i(), name);
    }

    protected NormalizedSimpleStack deserializeFromString(String s) {
        String[] splits = s.split("@", 2);
        return NormalizedSimpleStack.getFor((Item)Item.field_150901_e.func_82594_a((Object)splits[1]), Integer.parseInt(splits[0]));
    }

    @Override
    public String getName() {
        return "APICustomEMCMapper";
    }

    @Override
    public String getDescription() {
        return "Allows other mods to set EMC values using the ProjectEAPI";
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public void addMappings(IMappingCollector<NormalizedSimpleStack, Integer> mapper, Configuration config) {
        final HashMap<String, Integer> priorityMap = new HashMap<String, Integer>();
        HashSet modIdSet = Sets.newHashSet();
        modIdSet.addAll(this.customEMCforMod.keySet());
        modIdSet.addAll(this.customNonItemEMCforMod.keySet());
        for (String modId : modIdSet) {
            if (modId == null) continue;
            int valueCount = 0;
            if (this.customEMCforMod.containsKey(modId)) {
                valueCount += this.customEMCforMod.get(modId).size();
            }
            if (this.customNonItemEMCforMod.containsKey(modId)) {
                valueCount += this.customNonItemEMCforMod.get(modId).size();
            }
            priorityMap.put(modId, config.getInt(modId + "priority", "customEMCPriorities", 1, 0, 512, "Priority for Mod with ModId = " + modId + ". Values: " + valueCount));
        }
        if (modIdSet.contains(null)) {
            int valueCount = 0;
            if (this.customEMCforMod.containsKey(null)) {
                valueCount += this.customEMCforMod.get(null).size();
            }
            if (this.customNonItemEMCforMod.containsKey(null)) {
                valueCount += this.customNonItemEMCforMod.get(null).size();
            }
            priorityMap.put(null, config.getInt("modlessCustomEMCPriority", "", 1, 0, 512, "Priority for custom EMC values for which the ModId could not be determined. 0 to disable. Values: " + valueCount));
        }
        ArrayList modIds = new ArrayList(modIdSet);
        Collections.sort(modIds, new Comparator<String>(){

            @Override
            public int compare(String a, String b) {
                return -((Integer)priorityMap.get(a) - (Integer)priorityMap.get(b));
            }
        });
        for (String modId : modIds) {
            NormalizedSimpleStack normStack;
            String modIdOrUnknown;
            String string = modIdOrUnknown = modId == null ? "unknown mod" : modId;
            if (this.customEMCforMod.containsKey(modId)) {
                for (Map.Entry<String, Integer> entry : this.customEMCforMod.get(modId).entrySet()) {
                    normStack = this.deserializeFromString(entry.getKey());
                    if (this.isAllowedToSet(modId, normStack, entry.getValue(), config)) {
                        mapper.setValueBefore(normStack, (Integer)((Comparable)entry.getValue()));
                        PELogger.logInfo(String.format("%s setting value for %s to %s", modIdOrUnknown, normStack, entry.getValue()));
                        continue;
                    }
                    PELogger.logInfo(String.format("Disallowed %s to set the value for %s to %s", modIdOrUnknown, normStack, entry.getValue()));
                }
            }
            if (!this.customNonItemEMCforMod.containsKey(modId)) continue;
            for (Map.Entry<Object, Integer> entry : this.customNonItemEMCforMod.get(modId).entrySet()) {
                normStack = (NormalizedSimpleStack)entry.getKey();
                if (this.isAllowedToSet(modId, normStack, entry.getValue(), config)) {
                    mapper.setValueBefore(normStack, (Integer)((Comparable)entry.getValue()));
                    PELogger.logInfo(String.format("%s setting value for %s to %s", modIdOrUnknown, normStack, entry.getValue()));
                    continue;
                }
                PELogger.logInfo(String.format("Disallowed %s to set the value for %s to %s", modIdOrUnknown, normStack, entry.getValue()));
            }
        }
    }

    protected boolean isAllowedToSet(String modId, NormalizedSimpleStack stack, Integer value, Configuration config) {
        String itemName;
        if (stack instanceof NormalizedSimpleStack.NSSItem) {
            NormalizedSimpleStack.NSSItem item = (NormalizedSimpleStack.NSSItem)stack;
            itemName = (String)Item.field_150901_e.func_177774_c(Item.field_150901_e.func_148754_a(item.id));
        } else {
            itemName = "IntermediateFakeItemsUsedInRecipes:";
        }
        String modForItem = itemName.substring(0, itemName.indexOf(58));
        String permission = config.getString(modForItem, "permissions." + modId, "both", String.format("Allow '%s' to set and or remove values for '%s'. Options: [both, set, remove, none]", modId, modForItem), new String[]{"both", "set", "remove", "none"});
        if (permission.equals("both")) {
            return true;
        }
        if (value == 0) {
            return permission.equals("remove");
        }
        return permission.equals("set");
    }
}

