/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.events;

import moze_intel.projecte.PECore;
import moze_intel.projecte.gameObjs.ObjHandler;
import moze_intel.projecte.gameObjs.container.AlchBagContainer;
import moze_intel.projecte.gameObjs.container.inventory.AlchBagInventory;
import moze_intel.projecte.gameObjs.items.AlchemicalBag;
import moze_intel.projecte.handlers.PlayerChecks;
import moze_intel.projecte.playerData.AlchBagProps;
import moze_intel.projecte.playerData.AlchemicalBags;
import moze_intel.projecte.playerData.Transmutation;
import moze_intel.projecte.playerData.TransmutationOffline;
import moze_intel.projecte.playerData.TransmutationProps;
import moze_intel.projecte.utils.ChatHelper;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.PELogger;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class PlayerEvents {
    @SubscribeEvent
    public void cloneEvent(PlayerEvent.Clone evt) {
        if (!evt.wasDeath) {
            return;
        }
        NBTTagCompound bag = new NBTTagCompound();
        NBTTagCompound transmute = new NBTTagCompound();
        AlchBagProps.getDataFor(evt.original).saveNBTData(bag);
        TransmutationProps.getDataFor(evt.original).saveNBTData(transmute);
        AlchBagProps.getDataFor(evt.entityPlayer).loadNBTData(bag);
        TransmutationProps.getDataFor(evt.entityPlayer).loadNBTData(transmute);
        PELogger.logDebug("Reapplied bag and knowledge on player respawning");
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (!event.entity.field_70170_p.field_72995_K && event.entity instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.entity;
            Transmutation.sync((EntityPlayer)player);
            AlchemicalBags.syncFull((EntityPlayer)player);
        }
    }

    @SubscribeEvent
    public void onConstruct(EntityEvent.EntityConstructing evt) {
        if (evt.entity instanceof EntityPlayer) {
            TransmutationOffline.clear(evt.entity.func_110124_au());
            PELogger.logDebug("Clearing offline data cache in preparation to load online data");
            TransmutationProps.register((EntityPlayer)evt.entity);
            AlchBagProps.register((EntityPlayer)evt.entity);
        }
    }

    @SubscribeEvent
    public void onHighAlchemistJoin(PlayerEvent.PlayerLoggedInEvent evt) {
        if (PECore.uuids.contains(evt.player.func_110124_au().toString())) {
            IChatComponent prior = ChatHelper.modifyColor((IChatComponent)new ChatComponentTranslation("pe.server.high_alchemist", new Object[0]), EnumChatFormatting.BLUE);
            IChatComponent playername = ChatHelper.modifyColor((IChatComponent)new ChatComponentText(" " + evt.player.func_70005_c_() + " "), EnumChatFormatting.GOLD);
            IChatComponent latter = ChatHelper.modifyColor((IChatComponent)new ChatComponentTranslation("pe.server.has_joined", new Object[0]), EnumChatFormatting.BLUE);
            MinecraftServer.func_71276_C().func_71203_ab().func_148539_a(prior.func_150257_a(playername).func_150257_a(latter));
        }
    }

    @SubscribeEvent
    public void playerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        PlayerChecks.onPlayerChangeDimension((EntityPlayerMP)event.player);
    }

    @SubscribeEvent
    public void pickupItem(EntityItemPickupEvent event) {
        EntityPlayer player = event.entityPlayer;
        World world = player.field_70170_p;
        if (world.field_72995_K) {
            return;
        }
        if (player.field_71070_bA instanceof AlchBagContainer) {
            AlchBagInventory inv = ((AlchBagContainer)player.field_71070_bA).inventory;
            if (ItemHelper.invContainsItem(inv, new ItemStack(ObjHandler.blackHole, 1, 1)) || ItemHelper.invContainsItem(inv, new ItemStack(ObjHandler.voidRing, 1, 1)) && ItemHelper.hasSpace(inv, event.item.func_92059_d())) {
                ItemStack remain = ItemHelper.pushStackInInv(inv, event.item.func_92059_d());
                if (remain == null) {
                    event.item.func_174867_a(10);
                    event.item.func_70106_y();
                    world.func_72956_a((Entity)player, "random.pop", 0.2f, ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                } else {
                    event.item.func_92058_a(remain);
                }
                event.setCanceled(true);
            }
        } else {
            ItemStack bag = AlchemicalBag.getFirstBagWithSuctionItem(player, player.field_71071_by.field_70462_a);
            if (bag == null) {
                return;
            }
            ItemStack[] inv = AlchemicalBags.get(player, (byte)bag.func_77952_i());
            if (ItemHelper.hasSpace(inv, event.item.func_92059_d())) {
                ItemStack remain = ItemHelper.pushStackInInv(inv, event.item.func_92059_d());
                if (remain == null) {
                    event.item.func_174867_a(10);
                    event.item.func_70106_y();
                    world.func_72956_a((Entity)player, "random.pop", 0.2f, ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                } else {
                    event.item.func_92058_a(remain);
                }
                AlchemicalBags.set(player, (byte)bag.func_77952_i(), inv);
                AlchemicalBags.syncPartial(player, bag.func_77952_i());
                event.setCanceled(true);
            }
        }
    }
}

