/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import moze_intel.projecte.api.item.IPedestalItem;
import moze_intel.projecte.api.item.IProjectileShooter;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.entity.EntityWaterProjectile;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.gameObjs.tiles.DMPedestalTile;
import moze_intel.projecte.utils.ClientKeyHelper;
import moze_intel.projecte.utils.FluidHelper;
import moze_intel.projecte.utils.MathUtils;
import moze_intel.projecte.utils.PEKeybind;
import moze_intel.projecte.utils.PlayerHelper;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.Interface(iface="baubles.api.IBauble", modid="Baubles")
public class EvertideAmulet
extends ItemPE
implements IProjectileShooter,
IBauble,
IPedestalItem,
IFluidContainerItem {
    public EvertideAmulet() {
        this.func_77655_b("evertide_amulet");
        this.func_77625_d(1);
        this.setNoRepair();
        this.func_77642_a(this);
    }

    public boolean func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing sideHit, float f1, float f2, float f3) {
        if (!world.field_72995_K && PlayerHelper.hasEditPermission((EntityPlayerMP)player, pos)) {
            int waterLevel;
            IFluidHandler tank;
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof IFluidHandler && FluidHelper.canFillTank(tank = (IFluidHandler)tile, FluidRegistry.WATER, sideHit)) {
                FluidHelper.fillTank(tank, FluidRegistry.WATER, sideHit, 1000);
                return true;
            }
            IBlockState state = world.func_180495_p(pos);
            if (state.func_177230_c() == Blocks.field_150383_bp && (waterLevel = ((Integer)state.func_177229_b((IProperty)BlockCauldron.field_176591_a)).intValue()) < 3) {
                ((BlockCauldron)state.func_177230_c()).func_176590_a(world, pos, state, waterLevel + 1);
            }
        }
        return false;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        BlockPos blockPosHit;
        MovingObjectPosition mop;
        if (!world.field_72995_K && (mop = this.func_77621_a(world, player, false)) != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && !(world.func_175625_s(blockPosHit = mop.func_178782_a()) instanceof IFluidHandler) && world.func_175623_d(blockPosHit.func_177972_a(mop.field_178784_b))) {
            world.func_72956_a((Entity)player, "projecte:item.pewatermagic", 1.0f, 1.0f);
            this.placeWater(world, player, blockPosHit.func_177972_a(mop.field_178784_b));
            PlayerHelper.swingItem(player);
        }
        return stack;
    }

    private void placeWater(World world, EntityPlayer player, BlockPos pos) {
        Material material = world.func_180495_p(pos).func_177230_c().func_149688_o();
        if (world.field_73011_w.func_177500_n()) {
            world.func_72908_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), "random.fizz", 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)pos.func_177958_n() + Math.random(), (double)pos.func_177956_o() + Math.random(), (double)pos.func_177952_p() + Math.random(), 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            if (!(world.field_72995_K || material.func_76220_a() || material.func_76224_d())) {
                world.func_175655_b(pos, true);
            }
            world.func_175656_a(pos, Blocks.field_150358_i.func_176223_P());
            PlayerHelper.checkedPlaceBlock((EntityPlayerMP)player, pos, Blocks.field_150358_i.func_176223_P());
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int invSlot, boolean par5) {
        int z;
        int y;
        if (invSlot > 8 || !(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        int x = (int)Math.floor(player.field_70165_t);
        BlockPos pos = new BlockPos(x, y = (int)(player.field_70163_u - player.func_70033_W()), z = (int)Math.floor(player.field_70161_v));
        if ((world.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150355_j || world.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150358_i) && world.func_175623_d(pos)) {
            if (!player.func_70093_af()) {
                player.field_70181_x = 0.0;
                player.field_70143_R = 0.0f;
                player.field_70122_E = true;
            }
            if (!world.field_72995_K && player.field_71075_bZ.func_75094_b() < 0.25f) {
                PlayerHelper.setPlayerWalkSpeed(player, 0.25f);
            }
        } else if (!world.field_72995_K) {
            if (player.func_70090_H()) {
                player.func_70050_g(300);
            }
            if (player.field_71075_bZ.func_75094_b() != 0.1f) {
                PlayerHelper.setPlayerWalkSpeed(player, 0.1f);
            }
        }
    }

    @Override
    public boolean shootProjectile(EntityPlayer player, ItemStack stack) {
        World world = player.field_70170_p;
        if (!world.field_73011_w.func_177500_n()) {
            world.func_72956_a((Entity)player, "projecte:item.pewatermagic", 1.0f, 1.0f);
            world.func_72838_d((Entity)new EntityWaterProjectile(world, player));
            return true;
        }
        return false;
    }

    public FluidStack getFluid(ItemStack container) {
        return new FluidStack(FluidRegistry.WATER, 1000);
    }

    public int getCapacity(ItemStack container) {
        return 1000;
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        return new FluidStack(FluidRegistry.WATER, 1000);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        list.add(String.format(StatCollector.func_74838_a((String)"pe.evertide.tooltip1"), ClientKeyHelper.getKeyName(PEKeybind.FIRE_PROJECTILE)));
        list.add(StatCollector.func_74838_a((String)"pe.evertide.tooltip2"));
        list.add(StatCollector.func_74838_a((String)"pe.evertide.tooltip3"));
        list.add(StatCollector.func_74838_a((String)"pe.evertide.tooltip4"));
    }

    @Optional.Method(modid="Baubles")
    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.AMULET;
    }

    @Optional.Method(modid="Baubles")
    public void onWornTick(ItemStack stack, EntityLivingBase player) {
        this.func_77663_a(stack, player.field_70170_p, (Entity)player, 0, false);
    }

    @Optional.Method(modid="Baubles")
    public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
    }

    @Optional.Method(modid="Baubles")
    public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
    }

    @Optional.Method(modid="Baubles")
    public boolean canEquip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Optional.Method(modid="Baubles")
    public boolean canUnequip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Override
    public void updateInPedestal(World world, BlockPos pos) {
        if (!world.field_72995_K && ProjectEConfig.evertidePedCooldown != -1) {
            DMPedestalTile tile = (DMPedestalTile)world.func_175625_s(pos);
            if (tile.getActivityCooldown() == 0) {
                int i = (300 + world.field_73012_v.nextInt(600)) * 20;
                world.func_72912_H().func_76080_g(i);
                world.func_72912_H().func_76090_f(i);
                world.func_72912_H().func_76084_b(true);
                tile.setActivityCooldown(ProjectEConfig.evertidePedCooldown);
            } else {
                tile.decrementActivityCooldown();
            }
        }
    }

    @Override
    public List<String> getPedestalDescription() {
        ArrayList list = Lists.newArrayList();
        if (ProjectEConfig.evertidePedCooldown != -1) {
            list.add(EnumChatFormatting.BLUE + StatCollector.func_74838_a((String)"pe.evertide.pedestal1"));
            list.add(EnumChatFormatting.BLUE + String.format(StatCollector.func_74838_a((String)"pe.evertide.pedestal2"), MathUtils.tickToSecFormatted(ProjectEConfig.evertidePedCooldown)));
        }
        return list;
    }
}

