/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import moze_intel.projecte.api.item.IPedestalItem;
import moze_intel.projecte.api.item.IProjectileShooter;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.entity.EntityLavaProjectile;
import moze_intel.projecte.gameObjs.items.IFireProtector;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.gameObjs.tiles.DMPedestalTile;
import moze_intel.projecte.utils.ClientKeyHelper;
import moze_intel.projecte.utils.FluidHelper;
import moze_intel.projecte.utils.MathUtils;
import moze_intel.projecte.utils.PEKeybind;
import moze_intel.projecte.utils.PlayerHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.Interface(iface="baubles.api.IBauble", modid="Baubles")
public class VolcaniteAmulet
extends ItemPE
implements IProjectileShooter,
IBauble,
IPedestalItem,
IFireProtector {
    public VolcaniteAmulet() {
        this.func_77655_b("volcanite_amulet");
        this.func_77625_d(1);
        this.func_77642_a(this);
    }

    public boolean func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing sideHit, float f1, float f2, float f3) {
        IFluidHandler tank;
        TileEntity tile;
        if (!world.field_72995_K && PlayerHelper.hasEditPermission((EntityPlayerMP)player, pos) && (tile = world.func_175625_s(pos)) instanceof IFluidHandler && FluidHelper.canFillTank(tank = (IFluidHandler)tile, FluidRegistry.LAVA, sideHit) && VolcaniteAmulet.consumeFuel(player, stack, 32.0, true)) {
            FluidHelper.fillTank(tank, FluidRegistry.LAVA, sideHit, 1000);
            return true;
        }
        return false;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        BlockPos blockPosHit;
        MovingObjectPosition mop;
        if (!world.field_72995_K && (mop = this.func_77621_a(world, player, false)) != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && !(world.func_175625_s(blockPosHit = mop.func_178782_a()) instanceof IFluidHandler) && world.func_175623_d(blockPosHit.func_177972_a(mop.field_178784_b)) && VolcaniteAmulet.consumeFuel(player, stack, 32.0, true)) {
            this.placeLava(world, player, blockPosHit.func_177972_a(mop.field_178784_b));
            world.func_72956_a((Entity)player, "projecte:item.petransmute", 1.0f, 1.0f);
            PlayerHelper.swingItem(player);
        }
        return stack;
    }

    private void placeLava(World world, EntityPlayer player, BlockPos pos) {
        PlayerHelper.checkedPlaceBlock((EntityPlayerMP)player, pos, Blocks.field_150356_k.func_176223_P());
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int invSlot, boolean par5) {
        int z;
        int y;
        if (invSlot > 8 || !(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        int x = (int)Math.floor(player.field_70165_t);
        BlockPos pos = new BlockPos(x, y = (int)(player.field_70163_u - player.func_70033_W()), z = (int)Math.floor(player.field_70161_v));
        if ((player.field_70170_p.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150353_l || player.field_70170_p.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150356_k) && player.field_70170_p.func_175623_d(pos)) {
            if (!player.func_70093_af()) {
                player.field_70181_x = 0.0;
                player.field_70143_R = 0.0f;
                player.field_70122_E = true;
            }
            if (!player.field_70170_p.field_72995_K && player.field_71075_bZ.func_75094_b() < 0.25f) {
                PlayerHelper.setPlayerWalkSpeed(player, 0.25f);
            }
        } else if (!player.field_70170_p.field_72995_K && player.field_71075_bZ.func_75094_b() != 0.1f) {
            PlayerHelper.setPlayerWalkSpeed(player, 0.1f);
        }
    }

    @Override
    public boolean shootProjectile(EntityPlayer player, ItemStack stack) {
        player.field_70170_p.func_72956_a((Entity)player, "projecte:item.petransmute", 1.0f, 1.0f);
        player.field_70170_p.func_72838_d((Entity)new EntityLavaProjectile(player.field_70170_p, player));
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        list.add(String.format(StatCollector.func_74838_a((String)"pe.volcanite.tooltip1"), ClientKeyHelper.getKeyName(PEKeybind.FIRE_PROJECTILE)));
        list.add(StatCollector.func_74838_a((String)"pe.volcanite.tooltip2"));
        list.add(StatCollector.func_74838_a((String)"pe.volcanite.tooltip3"));
        list.add(StatCollector.func_74838_a((String)"pe.volcanite.tooltip4"));
    }

    @Optional.Method(modid="Baubles")
    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.AMULET;
    }

    @Optional.Method(modid="Baubles")
    public void onWornTick(ItemStack stack, EntityLivingBase ent) {
        int z;
        int y;
        if (!(ent instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)ent;
        int x = (int)Math.floor(player.field_70165_t);
        BlockPos pos = new BlockPos(x, y = (int)(player.field_70163_u - player.func_70033_W()), z = (int)Math.floor(player.field_70161_v));
        if ((player.field_70170_p.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150353_l || player.field_70170_p.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150356_k) && player.field_70170_p.func_175623_d(pos)) {
            if (!player.func_70093_af()) {
                player.field_70181_x = 0.0;
                player.field_70143_R = 0.0f;
                player.field_70122_E = true;
            }
            if (!player.field_70170_p.field_72995_K && player.field_71075_bZ.func_75094_b() < 0.25f) {
                PlayerHelper.setPlayerWalkSpeed(player, 0.25f);
            }
        } else if (!player.field_70170_p.field_72995_K && player.field_71075_bZ.func_75094_b() != 0.1f) {
            PlayerHelper.setPlayerWalkSpeed(player, 0.1f);
        }
    }

    @Optional.Method(modid="Baubles")
    public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
    }

    @Optional.Method(modid="Baubles")
    public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
    }

    @Optional.Method(modid="Baubles")
    public boolean canEquip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Optional.Method(modid="Baubles")
    public boolean canUnequip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Override
    public void updateInPedestal(World world, BlockPos pos) {
        if (!world.field_72995_K && ProjectEConfig.volcanitePedCooldown != -1) {
            DMPedestalTile tile = (DMPedestalTile)world.func_175625_s(pos);
            if (tile.getActivityCooldown() == 0) {
                world.func_72912_H().func_76080_g(0);
                world.func_72912_H().func_76090_f(0);
                world.func_72912_H().func_76084_b(false);
                world.func_72912_H().func_76069_a(false);
                tile.setActivityCooldown(ProjectEConfig.volcanitePedCooldown);
            } else {
                tile.decrementActivityCooldown();
            }
        }
    }

    @Override
    public List<String> getPedestalDescription() {
        ArrayList list = Lists.newArrayList();
        if (ProjectEConfig.volcanitePedCooldown != -1) {
            list.add(EnumChatFormatting.BLUE + StatCollector.func_74838_a((String)"pe.volcanite.pedestal1"));
            list.add(EnumChatFormatting.BLUE + String.format(StatCollector.func_74838_a((String)"pe.volcanite.pedestal2"), MathUtils.tickToSecFormatted(ProjectEConfig.volcanitePedCooldown)));
        }
        return list;
    }

    @Override
    public boolean canProtectAgainstFire(ItemStack stack, EntityPlayerMP player) {
        return true;
    }
}

