/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.armor;

import moze_intel.projecte.gameObjs.ObjHandler;
import moze_intel.projecte.utils.EnumArmorType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class GemArmorBase
extends ItemArmor
implements ISpecialArmor {
    private final EnumArmorType armorPiece;

    public GemArmorBase(EnumArmorType armorType) {
        super(ItemArmor.ArmorMaterial.DIAMOND, 0, armorType.ordinal());
        this.func_77637_a(ObjHandler.cTab);
        this.func_77655_b("pe_gem_armor_" + armorType.ordinal());
        this.func_77627_a(false);
        this.func_77656_e(0);
        this.armorPiece = armorType;
    }

    public static boolean hasAnyPiece(EntityPlayer player) {
        for (ItemStack i : player.field_71071_by.field_70460_b) {
            if (i == null || !(i.func_77973_b() instanceof GemArmorBase)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasFullSet(EntityPlayer player) {
        for (ItemStack i : player.field_71071_by.field_70460_b) {
            if (i != null && i.func_77973_b() instanceof GemArmorBase) continue;
            return false;
        }
        return true;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        EnumArmorType type = ((GemArmorBase)armor.func_77973_b()).armorPiece;
        if (source.func_94541_c()) {
            return new ISpecialArmor.ArmorProperties(1, 1.0, 750);
        }
        if (type == EnumArmorType.FEET && source == DamageSource.field_76379_h) {
            return new ISpecialArmor.ArmorProperties(1, 1.0, 15);
        }
        if (type == EnumArmorType.HEAD || type == EnumArmorType.FEET) {
            return new ISpecialArmor.ArmorProperties(0, 0.2, 400);
        }
        return new ISpecialArmor.ArmorProperties(0, 0.3, 500);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        EnumArmorType type = ((GemArmorBase)armor.func_77973_b()).armorPiece;
        return type == EnumArmorType.HEAD || type == EnumArmorType.FEET ? 4 : 6;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
    }

    @SideOnly(value=Side.CLIENT)
    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        char index = this.armorPiece == EnumArmorType.LEGS ? (char)'2' : '1';
        return "projecte:textures/armor/gem_" + index + ".png";
    }
}

