/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.tiles;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import java.util.Map;
import moze_intel.projecte.api.tile.IEmcAcceptor;
import moze_intel.projecte.api.tile.IEmcProvider;
import moze_intel.projecte.api.tile.TileEmcBase;
import moze_intel.projecte.gameObjs.tiles.RelayMK1Tile;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.server.gui.IUpdatePlayerListBox;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public abstract class TileEmc
extends TileEmcBase
implements IUpdatePlayerListBox {
    public TileEmc() {
        this.setMaximumEMC(1.073741824E9);
    }

    public TileEmc(int maxAmount) {
        this.setMaximumEMC(maxAmount);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState state, IBlockState newState) {
        return state.func_177230_c() != newState.func_177230_c();
    }

    public boolean hasMaxedEmc() {
        return this.getStoredEmc() >= this.getMaximumEmc();
    }

    public void sendToAllAcceptors(double emc) {
        if (!(this instanceof IEmcProvider)) {
            throw new UnsupportedOperationException("sending without being a provider");
        }
        Map tiles = Maps.filterValues(WorldHelper.getAdjacentTileEntitiesMapped(this.field_145850_b, this), (Predicate)Predicates.instanceOf(IEmcAcceptor.class));
        double emcPer = emc / (double)tiles.size();
        for (Map.Entry entry : tiles.entrySet()) {
            if (this instanceof RelayMK1Tile && entry.getValue() instanceof RelayMK1Tile) continue;
            double provide = ((IEmcProvider)((Object)this)).provideEMC(((EnumFacing)entry.getKey()).func_176734_d(), emcPer);
            double remain = provide - ((IEmcAcceptor)entry.getValue()).acceptEMC((EnumFacing)entry.getKey(), provide);
            this.addEMC(remain);
        }
    }
}

