/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.integration.NEI;

import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.Map;
import moze_intel.projecte.gameObjs.ObjHandler;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.WorldTransmutations;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class NEIWorldTransmuteHandler
extends TemplateRecipeHandler {
    private static String name = StatCollector.func_74838_a((String)"pe.nei.worldtransmute");
    private static String id = "worldTransmutation";

    public String getRecipeName() {
        return name;
    }

    public String getGuiTexture() {
        return "projecte:textures/gui/nei.png";
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(id) && ((Object)((Object)this)).getClass() == NEIWorldTransmuteHandler.class) {
            for (Map.Entry<IBlockState, Pair<IBlockState, IBlockState>> entry : WorldTransmutations.getWorldTransmutations().entrySet()) {
                if (entry == null) continue;
                if (entry.getValue().getLeft() != null) {
                    this.arecipes.add(new CachedTransmutationRecipe(entry.getKey(), false));
                }
                if (entry.getValue().getRight() == null) continue;
                this.arecipes.add(new CachedTransmutationRecipe(entry.getKey(), true));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (Map.Entry<IBlockState, Pair<IBlockState, IBlockState>> entry : WorldTransmutations.getWorldTransmutations().entrySet()) {
            IBlockState resultState = (IBlockState)entry.getValue().getLeft();
            IBlockState altResultState = (IBlockState)entry.getValue().getRight();
            if (resultState != null && NEIServerUtils.areStacksSameTypeCrafting((ItemStack)ItemHelper.stateToStack(resultState, 1), (ItemStack)result)) {
                this.arecipes.add(new CachedTransmutationRecipe(entry.getKey(), false));
                continue;
            }
            if (altResultState == null || !NEIServerUtils.areStacksSameTypeCrafting((ItemStack)ItemHelper.stateToStack(altResultState, 1), (ItemStack)result)) continue;
            this.arecipes.add(new CachedTransmutationRecipe(entry.getKey(), true));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (Map.Entry<IBlockState, Pair<IBlockState, IBlockState>> entry : WorldTransmutations.getWorldTransmutations().entrySet()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)ItemHelper.stateToStack(entry.getKey(), 1), (ItemStack)ingredient) || entry == null) continue;
            this.arecipes.add(new CachedTransmutationRecipe(entry.getKey(), true));
        }
    }

    public void drawForeground(int recipe) {
        String sneak = StatCollector.func_74838_a((String)"key.sneak");
        CachedTransmutationRecipe r = (CachedTransmutationRecipe)((Object)this.arecipes.get(recipe));
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        if (r.sneaking) {
            fr.func_78276_b(sneak, 70, 40, 0);
        }
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(83, 23, 25, 10), id, new Object[0]));
    }

    public class CachedTransmutationRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private IBlockState input;
        private IBlockState output;
        public boolean sneaking;

        public CachedTransmutationRecipe(IBlockState in, boolean sneak) {
            super((TemplateRecipeHandler)NEIWorldTransmuteHandler.this);
            this.input = in;
            this.sneaking = sneak;
            this.output = WorldTransmutations.getWorldTransmutation(in, this.sneaking);
        }

        public PositionedStack getIngredient() {
            return new PositionedStack((Object)this.getStack(this.input), 22, 23);
        }

        public PositionedStack getResult() {
            return new PositionedStack((Object)this.getStack(this.output), 128, 23);
        }

        public PositionedStack getOtherStack() {
            return new PositionedStack((Object)new ItemStack(ObjHandler.philosStone), 60, 23);
        }

        private ItemStack getStack(IBlockState state) {
            Fluid f = FluidRegistry.lookupFluidForBlock((Block)state.func_177230_c());
            if (f != null) {
                for (FluidContainerRegistry.FluidContainerData fd : FluidContainerRegistry.getRegisteredFluidContainerData()) {
                    if (fd.fluid.getFluid() != f) continue;
                    return fd.filledContainer.func_77946_l().func_151001_c(f.getLocalizedName(fd.fluid));
                }
                return new ItemStack(Blocks.field_180401_cv).func_151001_c(f.getLocalizedName(new FluidStack(f, 1000)));
            }
            return ItemHelper.stateToDroppedStack(state, 1);
        }
    }
}

