/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.playerData;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.ItemHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class TransmutationProps
implements IExtendedEntityProperties {
    private final EntityPlayer player;
    private double transmutationEmc;
    private List<ItemStack> knowledge = Lists.newArrayList();
    private ItemStack[] inputLocks = new ItemStack[9];
    private boolean hasFullKnowledge;
    public static final String PROP_NAME = "ProjectETransmutation";

    public static void register(EntityPlayer player) {
        player.registerExtendedProperties(PROP_NAME, (IExtendedEntityProperties)new TransmutationProps(player));
    }

    public static TransmutationProps getDataFor(EntityPlayer player) {
        return (TransmutationProps)player.getExtendedProperties(PROP_NAME);
    }

    public TransmutationProps(EntityPlayer player) {
        this.player = player;
    }

    public ItemStack[] getInputLocks() {
        return this.inputLocks;
    }

    public void setInputLocks(ItemStack[] inputLocks) {
        this.inputLocks = inputLocks;
    }

    protected boolean hasFullKnowledge() {
        return this.hasFullKnowledge;
    }

    protected void setFullKnowledge(boolean fullKnowledge) {
        this.hasFullKnowledge = fullKnowledge;
    }

    protected double getTransmutationEmc() {
        return this.transmutationEmc;
    }

    protected void setTransmutationEmc(double transmutationEmc) {
        this.transmutationEmc = transmutationEmc;
    }

    protected List<ItemStack> getKnowledge() {
        this.pruneStaleKnowledge();
        return this.knowledge;
    }

    private void pruneDuplicateKnowledge() {
        ItemHelper.compactItemListNoStacksize(this.knowledge);
        for (ItemStack s : this.knowledge) {
            if (s.field_77994_a <= 1) continue;
            s.field_77994_a = 1;
        }
    }

    private void pruneStaleKnowledge() {
        Iterator<ItemStack> iter = this.knowledge.iterator();
        while (iter.hasNext()) {
            if (EMCHelper.doesItemHaveEmc(iter.next())) continue;
            iter.remove();
        }
    }

    protected NBTTagCompound saveForPacket() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74780_a("transmutationEmc", this.transmutationEmc);
        compound.func_74757_a("tome", this.hasFullKnowledge);
        this.pruneStaleKnowledge();
        NBTTagList knowledgeWrite = new NBTTagList();
        for (ItemStack i : this.knowledge) {
            NBTTagCompound tag = i.func_77955_b(new NBTTagCompound());
            knowledgeWrite.func_74742_a((NBTBase)tag);
        }
        NBTTagList inputLockWrite = ItemHelper.toIndexedNBTList(this.inputLocks);
        compound.func_74782_a("knowledge", (NBTBase)knowledgeWrite);
        compound.func_74782_a("inputlocks", (NBTBase)inputLockWrite);
        return compound;
    }

    public void readFromPacket(NBTTagCompound compound) {
        this.transmutationEmc = compound.func_74769_h("transmutationEmc");
        this.hasFullKnowledge = compound.func_74767_n("tome");
        NBTTagList list = compound.func_150295_c("knowledge", 10);
        this.knowledge.clear();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            ItemStack item = ItemStack.func_77949_a((NBTTagCompound)list.func_150305_b(i));
            if (item == null) continue;
            this.knowledge.add(item);
        }
        NBTTagList list2 = compound.func_150295_c("inputlocks", 10);
        this.inputLocks = ItemHelper.copyIndexedNBTToArray(list2, new ItemStack[9]);
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagCompound properties = new NBTTagCompound();
        properties.func_74780_a("transmutationEmc", this.transmutationEmc);
        properties.func_74757_a("tome", this.hasFullKnowledge);
        this.pruneStaleKnowledge();
        NBTTagList knowledgeWrite = new NBTTagList();
        for (ItemStack i : this.knowledge) {
            NBTTagCompound tag = i.func_77955_b(new NBTTagCompound());
            knowledgeWrite.func_74742_a((NBTBase)tag);
        }
        NBTTagList inputLockWrite = ItemHelper.toIndexedNBTList(this.inputLocks);
        properties.func_74782_a("knowledge", (NBTBase)knowledgeWrite);
        properties.func_74782_a("inputlock", (NBTBase)inputLockWrite);
        compound.func_74782_a(PROP_NAME, (NBTBase)properties);
    }

    public void loadNBTData(NBTTagCompound compound) {
        NBTTagCompound properties = compound.func_74775_l(PROP_NAME);
        this.transmutationEmc = properties.func_74769_h("transmutationEmc");
        this.hasFullKnowledge = properties.func_74767_n("tome");
        NBTTagList list = properties.func_150295_c("knowledge", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            ItemStack item = ItemStack.func_77949_a((NBTTagCompound)list.func_150305_b(i));
            if (item == null) continue;
            this.knowledge.add(item);
        }
        this.pruneDuplicateKnowledge();
        NBTTagList list2 = properties.func_150295_c("inputlock", 10);
        this.inputLocks = ItemHelper.copyIndexedNBTToArray(list2, new ItemStack[9]);
    }

    public void init(Entity entity, World world) {
    }
}

