/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.utils;

import moze_intel.projecte.api.item.IItemEmc;
import moze_intel.projecte.gameObjs.tiles.AlchChestTile;
import moze_intel.projecte.gameObjs.tiles.CollectorMK1Tile;
import moze_intel.projecte.gameObjs.tiles.CondenserTile;
import moze_intel.projecte.gameObjs.tiles.RMFurnaceTile;
import moze_intel.projecte.gameObjs.tiles.RelayMK1Tile;
import moze_intel.projecte.utils.MathUtils;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;

public final class ComparatorHelper {
    public static int getForAlchChest(World world, BlockPos pos) {
        return Container.func_94526_b((IInventory)((AlchChestTile)world.func_175625_s(pos)));
    }

    public static int getForCollector(World world, BlockPos pos) {
        CollectorMK1Tile tile = (CollectorMK1Tile)world.func_175625_s(pos);
        ItemStack charging = tile.getChargingItem();
        if (charging != null) {
            if (charging.func_77973_b() instanceof IItemEmc) {
                IItemEmc itemEmc = (IItemEmc)charging.func_77973_b();
                double max = itemEmc.getMaximumEmc(charging);
                double current = itemEmc.getStoredEmc(charging);
                return MathUtils.scaleToRedstone(current, max);
            }
            double needed = tile.getEmcToNextGoal();
            double current = tile.getStoredEmc();
            return MathUtils.scaleToRedstone(current, needed);
        }
        return MathUtils.scaleToRedstone(tile.getStoredEmc(), tile.getMaximumEmc());
    }

    public static int getForCondenser(World world, BlockPos pos) {
        return Container.func_94526_b((IInventory)((CondenserTile)world.func_175625_s(pos)));
    }

    public static int getForMatterFurnace(World world, BlockPos pos) {
        return Container.func_94526_b((IInventory)((RMFurnaceTile)world.func_175625_s(pos)));
    }

    public static int getForRelay(World world, BlockPos pos) {
        RelayMK1Tile relay = (RelayMK1Tile)world.func_175625_s(pos);
        return MathUtils.scaleToRedstone(relay.getStoredEmc(), relay.getMaximumEmc());
    }
}

