/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.utils;

import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import moze_intel.projecte.api.item.IItemEmc;
import moze_intel.projecte.emc.EMCMapper;
import moze_intel.projecte.emc.FuelMapper;
import moze_intel.projecte.emc.SimpleStack;
import moze_intel.projecte.utils.Constants;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public final class EMCHelper {
    public static double consumePlayerFuel(EntityPlayer player, double minFuel) {
        if (player.field_71075_bZ.field_75098_d) {
            return minFuel;
        }
        InventoryPlayer inv = player.field_71071_by;
        LinkedHashMap map = Maps.newLinkedHashMap();
        boolean metRequirement = false;
        int emcConsumed = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack == null) continue;
            if (stack.func_77973_b() instanceof IItemEmc) {
                IItemEmc itemEmc = (IItemEmc)stack.func_77973_b();
                if (!(itemEmc.getStoredEmc(stack) >= minFuel)) continue;
                itemEmc.extractEmc(stack, minFuel);
                player.field_71069_bz.func_75142_b();
                return minFuel;
            }
            if (metRequirement || !FuelMapper.isStackFuel(stack)) continue;
            int emc = EMCHelper.getEmcValue(stack);
            int toRemove = (int)Math.ceil((minFuel - (double)emcConsumed) / (double)emc);
            if (stack.field_77994_a >= toRemove) {
                map.put(i, toRemove);
                emcConsumed += emc * toRemove;
                metRequirement = true;
                continue;
            }
            map.put(i, stack.field_77994_a);
            emcConsumed += emc * stack.field_77994_a;
            if (!((double)emcConsumed >= minFuel)) continue;
            metRequirement = true;
        }
        if (metRequirement) {
            for (Map.Entry entry : map.entrySet()) {
                inv.func_70298_a(((Integer)entry.getKey()).intValue(), ((Integer)entry.getValue()).intValue());
            }
            player.field_71069_bz.func_75142_b();
            return emcConsumed;
        }
        return -1.0;
    }

    public static boolean doesBlockHaveEmc(Block block) {
        if (block == null) {
            return false;
        }
        return EMCHelper.doesItemHaveEmc(new ItemStack(block));
    }

    public static boolean doesItemHaveEmc(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        SimpleStack iStack = new SimpleStack(stack);
        if (!iStack.isValid()) {
            return false;
        }
        if (!stack.func_77981_g() && stack.func_77958_k() != 0) {
            iStack.damage = 0;
        }
        return EMCMapper.mapContains(iStack);
    }

    public static boolean doesItemHaveEmc(Item item) {
        if (item == null) {
            return false;
        }
        return EMCHelper.doesItemHaveEmc(new ItemStack(item));
    }

    public static int getEmcValue(Block Block2) {
        SimpleStack stack = new SimpleStack(new ItemStack(Block2));
        if (stack.isValid() && EMCMapper.mapContains(stack)) {
            return EMCMapper.getEmcValue(stack);
        }
        return 0;
    }

    public static int getEmcValue(Item item) {
        SimpleStack stack = new SimpleStack(new ItemStack(item));
        if (stack.isValid() && EMCMapper.mapContains(stack)) {
            return EMCMapper.getEmcValue(stack);
        }
        return 0;
    }

    public static int getEmcValue(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        SimpleStack iStack = new SimpleStack(stack);
        if (!iStack.isValid()) {
            return 0;
        }
        if (!EMCMapper.mapContains(iStack) && !stack.func_77981_g() && stack.func_77958_k() != 0) {
            iStack.damage = 0;
            if (EMCMapper.mapContains(iStack)) {
                int emc = EMCMapper.getEmcValue(iStack);
                int relDamage = stack.func_77958_k() - stack.func_77952_i();
                if (relDamage <= 0) {
                    return emc;
                }
                long result = emc * relDamage;
                if (result <= 0L) {
                    return emc;
                }
                result /= (long)stack.func_77958_k();
                result += (long)EMCHelper.getEnchantEmcBonus(stack);
                if ((result = (long)((double)result + EMCHelper.getStoredEMCBonus(stack))) > Integer.MAX_VALUE) {
                    return emc;
                }
                if (result <= 0L) {
                    return 1;
                }
                return (int)result;
            }
        } else if (EMCMapper.mapContains(iStack)) {
            return EMCMapper.getEmcValue(iStack) + EMCHelper.getEnchantEmcBonus(stack) + (int)EMCHelper.getStoredEMCBonus(stack);
        }
        return 0;
    }

    public static int getEnchantEmcBonus(ItemStack stack) {
        int result = 0;
        Map enchants = EnchantmentHelper.func_82781_a((ItemStack)stack);
        if (!enchants.isEmpty()) {
            for (Map.Entry entry : enchants.entrySet()) {
                Enchantment ench = Enchantment.func_180306_c((int)((Integer)entry.getKey()));
                if (ench.func_77324_c() == 0) continue;
                result += 5000 / ench.func_77324_c() * (Integer)entry.getValue();
            }
        }
        return result;
    }

    public static int getKleinStarMaxEmc(ItemStack stack) {
        return Constants.MAX_KLEIN_EMC[stack.func_77952_i()];
    }

    public static double getStoredEMCBonus(ItemStack stack) {
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("StoredEMC")) {
            return stack.func_77978_p().func_74769_h("StoredEMC");
        }
        return 0.0;
    }
}

