/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.collector;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import moze_intel.projecte.emc.arithmetics.IValueArithmetic;
import moze_intel.projecte.emc.collector.AbstractMappingCollector;
import moze_intel.projecte.utils.PELogger;

public abstract class MappingCollector<T, V extends Comparable<V>, A extends IValueArithmetic<V>>
extends AbstractMappingCollector<T, V, A> {
    private static final boolean DEBUG_GRAPHMAPPER = false;
    protected final A arithmetic;
    protected final Map<T, Conversion> overwriteConversion = Maps.newHashMap();
    protected final Map<T, List<Conversion>> conversionsFor = Maps.newHashMap();
    private final Map<T, List<Conversion>> usedIn = Maps.newHashMap();
    protected final Map<T, V> fixValueBeforeInherit = Maps.newHashMap();
    protected final Map<T, V> fixValueAfterInherit = Maps.newHashMap();
    private final Map<T, Integer> noDependencyConversionCount = Maps.newHashMap();

    protected MappingCollector(A arithmetic) {
        super(arithmetic);
        this.arithmetic = arithmetic;
    }

    protected static void debugFormat(String format, Object ... args) {
    }

    protected static void debugPrintln(String s) {
        MappingCollector.debugFormat("%s", s);
    }

    public static <K, V> List<V> getOrCreateList(Map<K, List<V>> map, K key) {
        List<Object> list;
        if (map.containsKey(key)) {
            list = map.get(key);
        } else {
            list = new LinkedList();
            map.put(key, list);
        }
        return list;
    }

    private List<Conversion> getConversionsFor(T something) {
        return MappingCollector.getOrCreateList(this.conversionsFor, something);
    }

    protected List<Conversion> getUsesFor(T something) {
        return MappingCollector.getOrCreateList(this.usedIn, something);
    }

    private int getNoDependencyConversionCountFor(T something) {
        Integer count = this.noDependencyConversionCount.get(something);
        if (count == null) {
            return 0;
        }
        return count;
    }

    private void increaseNoDependencyConversionCountFor(T something) {
        this.noDependencyConversionCount.put(something, this.getNoDependencyConversionCountFor(something) + 1);
    }

    private void addConversionToIngredientUsages(Conversion conversion) {
        for (Map.Entry ingredient : conversion.ingredientsWithAmount.entrySet()) {
            List<Conversion> usesForIngredient = this.getUsesFor(ingredient.getKey());
            if (ingredient.getValue() == null) {
                throw new IllegalArgumentException("ingredient amount value has to be != null");
            }
            usesForIngredient.add(conversion);
        }
    }

    @Override
    public void addConversion(int outnumber, T output, Map<T, Integer> ingredientsWithAmount, A arithmeticForConversion) {
        ingredientsWithAmount = Maps.newHashMap(ingredientsWithAmount);
        if (output == null || ingredientsWithAmount.containsKey(null)) {
            PELogger.logWarn(String.format("Ignoring Recipe because of invalid ingredient or output: %s -> %dx%s", ingredientsWithAmount, outnumber, output));
            return;
        }
        if (outnumber <= 0) {
            throw new IllegalArgumentException("outnumber has to be > 0!");
        }
        Conversion conversion = new Conversion(output, outnumber, ingredientsWithAmount);
        conversion.value = this.arithmetic.getZero();
        conversion.arithmeticForConversion = arithmeticForConversion;
        if (this.getConversionsFor(output).contains(conversion)) {
            return;
        }
        this.getConversionsFor(output).add(conversion);
        if (ingredientsWithAmount.size() == 0) {
            this.increaseNoDependencyConversionCountFor(output);
        }
        this.addConversionToIngredientUsages(conversion);
    }

    @Override
    public void setValueBefore(T something, V value) {
        if (something == null) {
            return;
        }
        if (this.fixValueBeforeInherit.containsKey(something)) {
            PELogger.logWarn("Overwriting fixValueBeforeInherit for " + something + ":" + this.fixValueBeforeInherit.get(something) + " to " + value);
        }
        this.fixValueBeforeInherit.put(something, value);
        this.fixValueAfterInherit.remove(something);
    }

    @Override
    public void setValueAfter(T something, V value) {
        if (something == null) {
            return;
        }
        if (this.fixValueAfterInherit.containsKey(something)) {
            PELogger.logWarn("Overwriting fixValueAfterInherit for " + something + ":" + this.fixValueAfterInherit.get(something) + " to " + value);
        }
        this.fixValueAfterInherit.put(something, value);
    }

    @Override
    public void setValueFromConversion(int outnumber, T something, Map<T, Integer> ingredientsWithAmount) {
        if (something == null || ingredientsWithAmount.containsKey(null)) {
            PELogger.logWarn(String.format("Ignoring setValueFromConversion because of invalid ingredient or output: %s -> %dx%s", ingredientsWithAmount, outnumber, something));
            return;
        }
        if (outnumber <= 0) {
            throw new IllegalArgumentException("outnumber has to be > 0!");
        }
        Conversion conversion = new Conversion(something, outnumber, ingredientsWithAmount);
        conversion.arithmeticForConversion = this.arithmetic;
        if (this.overwriteConversion.containsKey(something)) {
            Conversion oldConversion = this.overwriteConversion.get(something);
            PELogger.logWarn("Overwriting setValueFromConversion " + this.overwriteConversion.get(something) + " with " + conversion);
            for (T ingredient : ingredientsWithAmount.keySet()) {
                this.getUsesFor(ingredient).remove(oldConversion);
            }
        }
        this.addConversionToIngredientUsages(conversion);
        this.overwriteConversion.put(something, conversion);
    }

    public abstract Map<T, V> generateValues();

    protected class Conversion {
        public final T output;
        public int outnumber = 1;
        public V value;
        public Map<T, Integer> ingredientsWithAmount;
        public A arithmeticForConversion;

        Conversion(T output) {
            this.value = MappingCollector.this.arithmetic.getZero();
            this.output = output;
        }

        Conversion(T output, int outnumber, Map<T, Integer> ingredientsWithAmount) {
            this(output);
            this.outnumber = outnumber;
            this.ingredientsWithAmount = ingredientsWithAmount;
        }

        public String toString() {
            return "" + this.value + " + " + this.ingredientsToString() + " => " + this.outnumber + "*" + this.output;
        }

        public String ingredientsToString() {
            if (this.ingredientsWithAmount == null || this.ingredientsWithAmount.size() == 0) {
                return "nothing";
            }
            StringBuilder sb = new StringBuilder();
            Iterator iter = this.ingredientsWithAmount.entrySet().iterator();
            if (iter.hasNext()) {
                Map.Entry entry = iter.next();
                sb.append(entry.getValue()).append("*").append(entry.getKey().toString());
                while (iter.hasNext()) {
                    entry = iter.next();
                    sb.append(" + ").append(entry.getValue()).append("*").append(entry.getKey().toString());
                }
            }
            return sb.toString();
        }

        public boolean equals(Conversion other) {
            if (this.output.equals(other.output) && this.value.equals(other.value)) {
                if (this.ingredientsWithAmount == null || this.ingredientsWithAmount.size() == 0) {
                    return other.ingredientsWithAmount == null || other.ingredientsWithAmount.size() == 0;
                }
                return this.ingredientsWithAmount.equals(other.ingredientsWithAmount);
            }
            return false;
        }
    }
}

