/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.events;

import moze_intel.projecte.PECore;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.capabilities.IAlchBagProvider;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.gameObjs.items.AlchemicalBag;
import moze_intel.projecte.handlers.PlayerChecks;
import moze_intel.projecte.impl.AlchBagImpl;
import moze_intel.projecte.impl.KnowledgeImpl;
import moze_intel.projecte.impl.TransmutationOffline;
import moze_intel.projecte.utils.ChatHelper;
import moze_intel.projecte.utils.PELogger;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketCollectItem;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class PlayerEvents {
    @SubscribeEvent
    public void cloneEvent(PlayerEvent.Clone evt) {
        NBTTagCompound bags = (NBTTagCompound)((IAlchBagProvider)evt.getOriginal().getCapability(ProjectEAPI.ALCH_BAG_CAPABILITY, null)).serializeNBT();
        ((IAlchBagProvider)evt.getEntityPlayer().getCapability(ProjectEAPI.ALCH_BAG_CAPABILITY, null)).deserializeNBT((NBTBase)bags);
        NBTTagCompound knowledge = (NBTTagCompound)((IKnowledgeProvider)evt.getOriginal().getCapability(ProjectEAPI.KNOWLEDGE_CAPABILITY, null)).serializeNBT();
        ((IKnowledgeProvider)evt.getEntityPlayer().getCapability(ProjectEAPI.KNOWLEDGE_CAPABILITY, null)).deserializeNBT((NBTBase)knowledge);
        PELogger.logDebug("Reapplied bag and knowledge on player respawning");
    }

    @SubscribeEvent
    public void attachCaps(AttachCapabilitiesEvent.Entity evt) {
        if (evt.getEntity() instanceof EntityPlayer) {
            evt.addCapability(AlchBagImpl.Provider.NAME, (ICapabilityProvider)new AlchBagImpl.Provider());
            evt.addCapability(KnowledgeImpl.Provider.NAME, (ICapabilityProvider)new KnowledgeImpl.Provider());
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (!event.getEntity().field_70170_p.field_72995_K && event.getEntity() instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.getEntity();
            ((IKnowledgeProvider)player.getCapability(ProjectEAPI.KNOWLEDGE_CAPABILITY, null)).sync(player);
            ((IAlchBagProvider)player.getCapability(ProjectEAPI.ALCH_BAG_CAPABILITY, null)).sync(null, player);
        }
    }

    @SubscribeEvent
    public void onConstruct(EntityEvent.EntityConstructing evt) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER && evt.getEntity() instanceof EntityPlayer && !(evt.getEntity() instanceof FakePlayer)) {
            TransmutationOffline.clear(evt.getEntity().func_110124_au());
            PELogger.logDebug("Clearing offline data cache in preparation to load online data");
        }
    }

    @SubscribeEvent
    public void onHighAlchemistJoin(PlayerEvent.PlayerLoggedInEvent evt) {
        if (PECore.uuids.contains(evt.player.func_110124_au().toString())) {
            ITextComponent prior = ChatHelper.modifyColor((ITextComponent)new TextComponentTranslation("pe.server.high_alchemist", new Object[0]), TextFormatting.BLUE);
            ITextComponent playername = ChatHelper.modifyColor((ITextComponent)new TextComponentString(" " + evt.player.func_70005_c_() + " "), TextFormatting.GOLD);
            ITextComponent latter = ChatHelper.modifyColor((ITextComponent)new TextComponentTranslation("pe.server.has_joined", new Object[0]), TextFormatting.BLUE);
            FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_148539_a(prior.func_150257_a(playername).func_150257_a(latter));
        }
    }

    @SubscribeEvent
    public void playerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        PlayerChecks.onPlayerChangeDimension((EntityPlayerMP)event.player);
    }

    @SubscribeEvent
    public void pickupItem(EntityItemPickupEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        World world = player.field_70170_p;
        if (world.field_72995_K) {
            return;
        }
        ItemStack bag = AlchemicalBag.getFirstBagWithSuctionItem(player, player.field_71071_by.field_70462_a);
        if (bag == null) {
            return;
        }
        IItemHandler handler = ((IAlchBagProvider)player.getCapability(ProjectEAPI.ALCH_BAG_CAPABILITY, null)).getBag(EnumDyeColor.func_176764_b((int)bag.func_77952_i()));
        ItemStack remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)event.getItem().func_92059_d(), (boolean)false);
        if (remainder == null) {
            event.getItem().func_174867_a(10);
            event.getItem().func_70106_y();
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
        } else {
            event.getItem().func_92058_a(remainder);
        }
        ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketCollectItem(event.getItem().func_145782_y(), player.func_145782_y()));
        event.setCanceled(true);
    }
}

