/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.container.inventory;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.emc.FuelMapper;
import moze_intel.projecte.utils.Comparators;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.ItemSearchHelper;
import moze_intel.projecte.utils.NBTWhitelist;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class TransmutationInventory
extends CombinedInvWrapper {
    public final EntityPlayer player;
    public final IKnowledgeProvider provider;
    private final IItemHandlerModifiable inputLocks;
    private final IItemHandlerModifiable learning;
    public final IItemHandlerModifiable outputs;
    public final ItemStack invItem;
    private static final int LOCK_INDEX = 8;
    private static final int FUEL_START = 12;
    public int learnFlag = 0;
    public int unlearnFlag = 0;
    public String filter = "";
    public int searchpage = 0;
    public final List<ItemStack> knowledge = Lists.newArrayList();

    public TransmutationInventory(EntityPlayer player, ItemStack invItem) {
        super(new IItemHandlerModifiable[]{(IItemHandlerModifiable)((IKnowledgeProvider)player.getCapability(ProjectEAPI.KNOWLEDGE_CAPABILITY, null)).getInputAndLocks(), new ItemStackHandler(2), new ItemStackHandler(16)});
        this.player = player;
        this.provider = (IKnowledgeProvider)player.getCapability(ProjectEAPI.KNOWLEDGE_CAPABILITY, null);
        this.inputLocks = this.itemHandler[0];
        this.learning = this.itemHandler[1];
        this.outputs = this.itemHandler[2];
        this.invItem = invItem;
        if (player.field_70170_p.field_72995_K) {
            this.updateClientTargets();
        }
    }

    public void handleKnowledge(ItemStack stack) {
        if (stack.field_77994_a > 1) {
            stack.field_77994_a = 1;
        }
        if (!stack.func_77981_g() && stack.func_77958_k() != 0 && stack.func_77952_i() != 0) {
            stack.func_77964_b(0);
        }
        if (!this.provider.hasKnowledge(stack)) {
            this.learnFlag = 300;
            if (stack.func_77942_o() && !NBTWhitelist.shouldDupeWithNBT(stack)) {
                stack.func_77982_d(null);
            }
            this.provider.addKnowledge(stack);
            if (!this.player.field_70170_p.field_72995_K) {
                this.provider.sync((EntityPlayerMP)this.player);
            }
        }
        this.updateClientTargets();
    }

    public void handleUnlearn(ItemStack stack) {
        if (stack.field_77994_a > 1) {
            stack.field_77994_a = 1;
        }
        if (!stack.func_77981_g() && stack.func_77958_k() != 0 && stack.func_77952_i() != 0) {
            stack.func_77964_b(0);
        }
        if (this.provider.hasKnowledge(stack)) {
            this.unlearnFlag = 300;
            if (stack.func_77942_o() && !NBTWhitelist.shouldDupeWithNBT(stack)) {
                stack.func_77982_d(null);
            }
            this.provider.removeKnowledge(stack);
            if (!this.player.field_70170_p.field_72995_K) {
                this.provider.sync((EntityPlayerMP)this.player);
            }
        }
        this.updateClientTargets();
    }

    public void checkForUpdates() {
        int fuelEmc;
        int matterEmc = EMCHelper.getEmcValue(this.outputs.getStackInSlot(0));
        if ((double)Math.max(matterEmc, fuelEmc = EMCHelper.getEmcValue(this.outputs.getStackInSlot(12))) > this.provider.getEmc()) {
            this.updateClientTargets();
        }
    }

    public void updateClientTargets() {
        if (!this.player.field_70170_p.field_72995_K) {
            return;
        }
        this.knowledge.clear();
        this.knowledge.addAll(this.provider.getKnowledge());
        for (int i = 0; i < this.outputs.getSlots(); ++i) {
            this.outputs.setStackInSlot(i, null);
        }
        ItemStack lockCopy = null;
        Collections.sort(this.knowledge, Comparators.ITEMSTACK_EMC_DESCENDING);
        ItemSearchHelper searchHelper = ItemSearchHelper.create(this.filter);
        if (this.inputLocks.getStackInSlot(8) != null) {
            int reqEmc = EMCHelper.getEmcValue(this.inputLocks.getStackInSlot(8));
            if (this.provider.getEmc() < (double)reqEmc) {
                return;
            }
            lockCopy = ItemHelper.getNormalizedStack(this.inputLocks.getStackInSlot(8));
            if (lockCopy.func_77942_o() && !NBTWhitelist.shouldDupeWithNBT(lockCopy)) {
                lockCopy.func_77982_d(new NBTTagCompound());
            }
            Iterator<ItemStack> iter = this.knowledge.iterator();
            int pagecounter = 0;
            while (iter.hasNext()) {
                ItemStack stack = iter.next();
                if (EMCHelper.getEmcValue(stack) > reqEmc) {
                    iter.remove();
                    continue;
                }
                if (ItemHelper.basicAreStacksEqual(lockCopy, stack)) {
                    iter.remove();
                    continue;
                }
                if (!searchHelper.doesItemMatchFilter(stack)) {
                    iter.remove();
                    continue;
                }
                if (pagecounter >= this.searchpage * 12) continue;
                ++pagecounter;
                iter.remove();
            }
        } else {
            Iterator<ItemStack> iter = this.knowledge.iterator();
            int pagecounter = 0;
            while (iter.hasNext()) {
                ItemStack stack = iter.next();
                if (this.provider.getEmc() < (double)EMCHelper.getEmcValue(stack)) {
                    iter.remove();
                    continue;
                }
                if (!searchHelper.doesItemMatchFilter(stack)) {
                    iter.remove();
                    continue;
                }
                if (pagecounter >= this.searchpage * 12) continue;
                ++pagecounter;
                iter.remove();
            }
        }
        int matterCounter = 0;
        int fuelCounter = 0;
        if (lockCopy != null) {
            if (FuelMapper.isStackFuel(lockCopy)) {
                this.outputs.setStackInSlot(12, lockCopy);
                ++fuelCounter;
            } else {
                this.outputs.setStackInSlot(0, lockCopy);
                ++matterCounter;
            }
        }
        for (ItemStack stack : this.knowledge) {
            if (FuelMapper.isStackFuel(stack)) {
                if (fuelCounter >= 4) continue;
                this.outputs.setStackInSlot(12 + fuelCounter, stack);
                ++fuelCounter;
                continue;
            }
            if (matterCounter >= 12) continue;
            this.outputs.setStackInSlot(matterCounter, stack);
            ++matterCounter;
        }
    }

    public void writeIntoOutputSlot(int slot, ItemStack item) {
        if (EMCHelper.doesItemHaveEmc(item) && (double)EMCHelper.getEmcValue(item) <= this.provider.getEmc() && this.provider.hasKnowledge(item)) {
            this.outputs.setStackInSlot(slot, item);
        } else {
            this.outputs.setStackInSlot(slot, null);
        }
    }

    public void addEmc(double value) {
        this.provider.setEmc(this.provider.getEmc() + value);
        if (this.provider.getEmc() >= 1.073741824E9 || this.provider.getEmc() < 0.0) {
            this.provider.setEmc(1.073741824E9);
        }
    }

    public void removeEmc(double value) {
        this.provider.setEmc(this.provider.getEmc() - value);
        if (this.provider.getEmc() < 0.0) {
            this.provider.setEmc(0.0);
        }
    }

    public boolean hasMaxedEmc() {
        return this.provider.getEmc() >= 1.073741824E9;
    }

    public IItemHandlerModifiable getHandlerForSlot(int slot) {
        return super.getHandlerFromIndex(super.getIndexForSlot(slot));
    }

    public int getIndexFromSlot(int slot) {
        for (IItemHandlerModifiable h : this.itemHandler) {
            if (slot < h.getSlots()) continue;
            slot -= h.getSlots();
        }
        return slot;
    }
}

