/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.PESounds;
import moze_intel.projecte.gameObjs.items.CataliticLens;
import moze_intel.projecte.gameObjs.items.ItemCharge;
import moze_intel.projecte.network.PacketHandler;
import moze_intel.projecte.network.packets.ParticlePKT;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;

public class DestructionCatalyst
extends ItemCharge {
    public DestructionCatalyst() {
        super("destruction_catalyst", (byte)3);
        this.setNoRepair();
    }

    protected DestructionCatalyst(String name, byte numCharges) {
        super(name, numCharges);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (world.field_72995_K) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        RayTraceResult mop = this.func_77621_a(world, player, false);
        if (mop != null && mop.field_72313_a.equals((Object)RayTraceResult.Type.BLOCK)) {
            int numRows = this.calculateDepthFromCharge(stack);
            boolean hasAction = false;
            BlockPos coords = mop.func_178782_a();
            AxisAlignedBB box = WorldHelper.getDeepBox(coords, mop.field_178784_b, --numRows);
            ArrayList drops = Lists.newArrayList();
            for (BlockPos pos : WorldHelper.getPositionsFromBox(box)) {
                List<ItemStack> list;
                IBlockState state = world.func_180495_p(pos);
                Block block = state.func_177230_c();
                float hardness = state.func_185887_b(world, pos);
                if (world.func_175623_d(pos) || hardness >= 50.0f || hardness == -1.0f) continue;
                if (!DestructionCatalyst.consumeFuel(player, stack, 8.0, true)) break;
                if (!hasAction) {
                    hasAction = true;
                }
                if (PlayerHelper.hasBreakPermission((EntityPlayerMP)player, pos)) {
                    list = WorldHelper.getBlockDrops(world, player, world.func_180495_p(pos), stack, pos);
                    if (list != null && list.size() > 0) {
                        drops.addAll(list);
                    }
                    world.func_175698_g(pos);
                    if (world.field_73012_v.nextInt(8) == 0) {
                        PacketHandler.sendToAllAround(new ParticlePKT(world.field_73012_v.nextBoolean() ? EnumParticleTypes.EXPLOSION_NORMAL : EnumParticleTypes.SMOKE_LARGE, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), 32.0));
                    }
                }
                if ((list = WorldHelper.getBlockDrops(world, player, world.func_180495_p(pos), stack, pos)) != null && list.size() > 0) {
                    drops.addAll(list);
                }
                world.func_175698_g(pos);
                if (world.field_73012_v.nextInt(8) != 0) continue;
                PacketHandler.sendToAllAround(new ParticlePKT(world.field_73012_v.nextBoolean() ? EnumParticleTypes.EXPLOSION_NORMAL : EnumParticleTypes.SMOKE_LARGE, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), 32.0));
            }
            PlayerHelper.swingItem(player);
            if (hasAction) {
                WorldHelper.createLootDrop(drops, world, mop.func_178782_a());
                world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, PESounds.DESTRUCT, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    protected int calculateDepthFromCharge(ItemStack stack) {
        byte charge = this.getCharge(stack);
        if (charge <= 0) {
            return 1;
        }
        if (this instanceof CataliticLens) {
            return 8 + charge * 8;
        }
        return (int)Math.pow(2.0, 1 + charge);
    }
}

