/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.rings;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.item.IModeChanger;
import moze_intel.projecte.api.item.IPedestalItem;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.entity.EntityHomingArrow;
import moze_intel.projecte.gameObjs.items.rings.RingToggle;
import moze_intel.projecte.gameObjs.tiles.DMPedestalTile;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.MathUtils;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ArchangelSmite
extends RingToggle
implements IPedestalItem,
IModeChanger {
    public ArchangelSmite() {
        super("archangel_smite");
        this.func_77625_d(1);
        this.setNoRepair();
    }

    @Override
    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        if (!world.field_72995_K && this.getMode(stack) == 1 && entity instanceof EntityLivingBase) {
            this.fireArrow(stack, world, (EntityLivingBase)entity);
        }
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K) {
            this.fireArrow(stack, world, (EntityLivingBase)player);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    private void fireArrow(ItemStack ring, World world, EntityLivingBase shooter) {
        EntityHomingArrow arrow = new EntityHomingArrow(world, shooter, 2.0f);
        if (!(shooter instanceof EntityPlayer) || ArchangelSmite.consumeFuel((EntityPlayer)shooter, ring, EMCHelper.getEmcValue(Items.field_151032_g), true)) {
            arrow.func_184547_a((Entity)shooter, shooter.field_70125_A, shooter.field_70177_z, 0.0f, 3.0f, 1.0f);
            world.func_184148_a(null, shooter.field_70165_t, shooter.field_70163_u, shooter.field_70161_v, SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + 0.5f);
            world.func_72838_d((Entity)arrow);
        }
    }

    @Override
    public void updateInPedestal(@Nonnull World world, @Nonnull BlockPos pos) {
        if (!world.field_72995_K && ProjectEConfig.archangelPedCooldown != -1) {
            DMPedestalTile tile = (DMPedestalTile)world.func_175625_s(pos);
            if (tile.getActivityCooldown() == 0) {
                if (!world.func_72872_a(EntityLiving.class, tile.getEffectBounds()).isEmpty()) {
                    for (int i = 0; i < 3; ++i) {
                        EntityHomingArrow arrow = new EntityHomingArrow(world, (EntityLivingBase)FakePlayerFactory.get((WorldServer)((WorldServer)world), (GameProfile)PECore.FAKEPLAYER_GAMEPROFILE), 2.0f);
                        arrow.field_70165_t = tile.centeredX;
                        arrow.field_70163_u = tile.centeredY + 2.0;
                        arrow.field_70161_v = tile.centeredZ;
                        arrow.field_70159_w = 0.0;
                        arrow.field_70179_y = 0.0;
                        arrow.field_70181_x = 1.0;
                        arrow.func_184185_a(SoundEvents.field_187737_v, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + 0.5f);
                        world.func_72838_d((Entity)arrow);
                    }
                }
                tile.setActivityCooldown(ProjectEConfig.archangelPedCooldown);
            } else {
                tile.decrementActivityCooldown();
            }
        }
    }

    @Override
    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public List<String> getPedestalDescription() {
        ArrayList list = Lists.newArrayList();
        if (ProjectEConfig.archangelPedCooldown != -1) {
            list.add(TextFormatting.BLUE + I18n.func_135052_a((String)"pe.archangel.pedestal1", (Object[])new Object[0]));
            list.add(TextFormatting.BLUE + I18n.func_135052_a((String)"pe.archangel.pedestal2", (Object[])new Object[]{MathUtils.tickToSecFormatted(ProjectEConfig.archangelPedCooldown)}));
        }
        return list;
    }
}

