/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.rings;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.PESounds;
import moze_intel.projecte.api.item.IPedestalItem;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.items.rings.RingToggle;
import moze_intel.projecte.gameObjs.tiles.DMPedestalTile;
import moze_intel.projecte.handlers.PlayerTimers;
import moze_intel.projecte.utils.MathUtils;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.Interface(iface="baubles.api.IBauble", modid="Baubles")
public class LifeStone
extends RingToggle
implements IBauble,
IPedestalItem {
    public LifeStone() {
        super("life_stone");
        this.setNoRepair();
    }

    @Override
    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        if (world.field_72995_K || par4 > 8 || !(entity instanceof EntityPlayer)) {
            return;
        }
        super.func_77663_a(stack, world, entity, par4, par5);
        EntityPlayer player = (EntityPlayer)entity;
        if (stack.func_77952_i() != 0) {
            if (!LifeStone.consumeFuel(player, stack, 128.0, false)) {
                stack.func_77964_b(0);
            } else {
                PlayerTimers.activateFeed(player);
                PlayerTimers.activateHeal(player);
                if (player.func_110143_aJ() < player.func_110138_aP() && PlayerTimers.canHeal(player)) {
                    world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, PESounds.HEAL, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    player.func_70691_i(2.0f);
                    LifeStone.removeEmc(stack, 64.0);
                }
                if (player.func_71024_bL().func_75121_c() && PlayerTimers.canFeed(player)) {
                    world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, PESounds.HEAL, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    player.func_71024_bL().func_75122_a(2, 10.0f);
                    LifeStone.removeEmc(stack, 64.0);
                }
            }
        }
    }

    @Override
    public boolean changeMode(@Nonnull EntityPlayer player, @Nonnull ItemStack stack, EnumHand hand) {
        if (stack.func_77952_i() == 0) {
            if (!(LifeStone.getEmc(stack) < 64.0) || LifeStone.consumeFuel(player, stack, 64.0, false)) {
                stack.func_77964_b(1);
            }
        } else {
            stack.func_77964_b(0);
        }
        return true;
    }

    @Optional.Method(modid="Baubles")
    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.AMULET;
    }

    @Optional.Method(modid="Baubles")
    public void onWornTick(ItemStack stack, EntityLivingBase player) {
        this.func_77663_a(stack, player.field_70170_p, (Entity)player, 0, false);
    }

    @Optional.Method(modid="Baubles")
    public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
    }

    @Optional.Method(modid="Baubles")
    public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
    }

    @Optional.Method(modid="Baubles")
    public boolean canEquip(ItemStack stack, EntityLivingBase player) {
        return true;
    }

    @Optional.Method(modid="Baubles")
    public boolean canUnequip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Override
    public void updateInPedestal(@Nonnull World world, @Nonnull BlockPos pos) {
        if (!world.field_72995_K && ProjectEConfig.lifePedCooldown != -1) {
            DMPedestalTile tile = (DMPedestalTile)world.func_175625_s(pos);
            if (tile.getActivityCooldown() == 0) {
                List players = world.func_72872_a(EntityPlayerMP.class, tile.getEffectBounds());
                for (EntityPlayerMP player : players) {
                    if (player.func_110143_aJ() < player.func_110138_aP()) {
                        world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, PESounds.HEAL, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        player.func_70691_i(1.0f);
                    }
                    if (!player.func_71024_bL().func_75121_c()) continue;
                    world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, PESounds.HEAL, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    player.func_71024_bL().func_75122_a(1, 1.0f);
                }
                tile.setActivityCooldown(ProjectEConfig.lifePedCooldown);
            } else {
                tile.decrementActivityCooldown();
            }
        }
    }

    @Override
    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public List<String> getPedestalDescription() {
        ArrayList list = Lists.newArrayList();
        if (ProjectEConfig.lifePedCooldown != -1) {
            list.add(TextFormatting.BLUE + I18n.func_135052_a((String)"pe.life.pedestal1", (Object[])new Object[0]));
            list.add(TextFormatting.BLUE + I18n.func_135052_a((String)"pe.life.pedestal2", (Object[])new Object[]{MathUtils.tickToSecFormatted(ProjectEConfig.lifePedCooldown)}));
        }
        return list;
    }
}

